    
;/*****************************************************/
    PRESERVE8
    AREA    MMU_CODE, CODE, READONLY
    CODE32

;/*****************************************************/
; ID Code Register c0

    EXPORT cp15_readIDCode

cp15_readIDCode

    MRC     p15, 0, r0, c0, c0, 0
    BX      LR

;/*****************************************************/
; Cache Type Register c0

    EXPORT cp15_readCacheType

cp15_readCacheType

    MRC     p15, 0, r0, c0, c0, 1
    BX      LR

;/*****************************************************/
; TCM Status Register c0

    EXPORT cp15_readTCMStatus

cp15_readTCMStatus

    MRC     p15, 0, r0, c0, c0, 2
    BX      LR

;/*****************************************************/
; Control Register c1

    EXPORT  cp15_readControlRegister
    EXPORT  cp15_writeControlRegister

cp15_readControlRegister

    MRC     p15, 0, r0, c1, c0, 0
    BX      LR

cp15_writeControlRegister

    MCR     p15, 0, r0, c1, c0, 0
    BX      LR

;/*****************************************************/
; Translation Table Base Register c2

    EXPORT  cp15_readTTB
    EXPORT  cp15_writeTTB

cp15_readTTB

    MRC     p15, 0, r0, c2, c0, 0   
    BX      LR

cp15_writeTTB

    MCR     p15, 0, r0, c2, c0, 0   
    BX      LR
    
;/*****************************************************/
; Domain Access Control Register c3

    EXPORT  cp15_readDomainRegister
    EXPORT  cp15_writeDomainRegister

cp15_readDomainRegister

    MRC     p15, 0, r0, c3, c0, 0
    BX      LR

cp15_writeDomainRegister

    MCR     p15, 0, r0, c3, c0, 0
    BX      LR

;/*****************************************************/
; Fault Status Register c5

    EXPORT  cp15_readDFSR
    EXPORT  cp15_writeDFSR
    EXPORT  cp15_readIFSR
    EXPORT  cp15_writeIFSR

cp15_readDFSR

    MRC     p15, 0, r0, c5, c0, 0
    BX      LR

cp15_writeDFSR

    MCR     p15, 0, r0, c5, c0, 0
    BX      LR

cp15_readIFSR

    MRC     p15, 0, r0, c5, c0, 1
    BX      LR

cp15_writeIFSR

    MCR     p15, 0, r0, c5, c0, 1
    BX      LR

;/*****************************************************/
; Fault Address Register c6

    EXPORT  cp15_readFaultAddress
    EXPORT  cp15_writeFaultAddress

cp15_readFaultAddress

    MRC     p15, 0, r0, c6, c0, 0
    BX      LR
 
cp15_writeFaultAddress

    MCR     p15, 0, r0, c6, c0, 0
    BX      LR

;/*****************************************************/
; Cache Operations Register c7

;/*****************************************************/
; TLB Operations Register c8

    EXPORT cp15_InvalidateTLB

cp15_InvalidateTLB

    MCR     p15, 0, r0, c7, c7, 0       ; invalidate caches
    MCR     p15, 0, r0, c8, c7, 0  
    BX      LR

;/*****************************************************/
; TLB Lockdown Register c10

    EXPORT  cp15_setLockedAddr

cp15_setLockedAddr

    LDR     r1, [r0]                ; access the memory section which will be locked
    MCR     p15, 0, r0, c8, c7, 1   ; invalidate TLB single entry to ensure that LockAddr is not already in the TLB
    MRC     p15, 0, r1, c10, c0, 0  ; read the lockdown register
    ORR     r1, r1, #1              ; set the preserve bit
    MCR     p15, 0, r1, c10, c0, 0  ; write to the lockdown register
    LDR     r0,[r0]                 ; TLB will miss, and entry will be loaded
    MRC     p15, 0, r1, c10, c0, 0  ; read the lockdown register (victim will have incremented)
    BIC     r1, r1, #1              ; clear preserve bit
    MCR     p15, 0, r1, c10, c0, 0  ; write to the lockdown register
    BX      LR

;/*****************************************************/
    EXPORT  mem_zero
    EXPORT  mem_copy

mem_zero
;addr    RN  0
;len     RN  1

    STMFD   SP!, {R4-R11}

    MOV     R4, #0
    MOV     R5, #0
    MOV     R6, #0
    MOV     R7, #0
    MOV     R8, #0
    MOV     R9, #0
    MOV     R10, #0
    MOV     R11, #0

_zi_loop
    SUBS    R1, R1, #32     ;~32
    STMCSIA R0!, {R4-R11}
    BHI     _zi_loop

    MOVS    R1, R1, lsl #28 ;31~16
    STMCSIA R0!, {R4-R7}

    MOVS    R1, R1, lsl #1  ;15~8
    STMCSIA R0!, {R4-R5}

    MOVS    R1, R1, lsl #1  ;7~4
    STRCS   R4, [R0], #4

    MOVS    R1, R1, lsl #1  ;3~2
    STRHCS  R4, [R0], #2

    STRBMI  R4, [R0], #1    ;1

    LDMFD   SP!,{R4-R11}
    BX      LR


mem_copy
;dest    RN  0
;src     RN  1
;len     RN  2

    STMFD   SP!, {R4-R11}

_copy_loop
    SUBS    R2, R2, #32     ;~32
    LDMCSIA r1!, {r4-r11}
    STMCSIA R0!, {R4-R11}
    BHI     _copy_loop

    MOVS    R2, R2, lsl #28 ;31~16
    LDMCSIA R1!, {R4-R7}
    STMCSIA R0!, {R4-R7}

    MOVS    R2, R2, lsl #1  ;15~8
    LDMCSIA R1!, {R4-R5}
    STMCSIA R0!, {R4-R5}

    MOVS    R2, R2, lsl #1  ;7~4
    LDRCS   R4, [R1], #4
    STRCS   R4, [R0], #4

    MOVS    R2, R2, lsl #1  ;3~2
    LDRHCS  R4, [R1], #2
    STRHCS  R4, [R0], #2

    LDRBMI  R4, [R1], #1    ;1
    STRBMI  R4, [R0], #1    ;1

    LDMFD   SP!, {R4-R11}
    BX      LR    
     
;/*****************************************************/
    EXPORT  get_arm_mode

OS_CPU_ARM_MODE_MASK	EQU	0x1F

get_arm_mode

    MRS     R0, CPSR
    AND     R0, R0, #OS_CPU_ARM_MODE_MASK

    BX      LR
    
;/*****************************************************/
    EXPORT  read_cpsr

read_cpsr

    MRS     R0, CPSR

    BX      LR

;/*****************************************************/
    EXPORT  busy_delay

busy_delay

    SUBS    r0, r0, #1
    BCS     busy_delay

    BX      LR

    
    END

