/*******************************************************************************
 * Copyright (C) 2016, ZTE Corporation.
 *
 * File Name:    hal_vibrator.c
 * File Mark:
 * Description:  This file contains the hardware interface for vibrator driver
 * Others:
 * Version:       V1.0
 * Author:        taochao
 * Date:          2016-03-15
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drv_api.h"
#include "string.h"
#include "drvs_gpio.h"
#include "drvs_ret.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#define VIB_DEBUG_DEF
		
#ifdef VIB_DEBUG_DEF
#define vib_printf(s...)  zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, ##s);
#else
#define vib_printf(s...)
#endif


/****************************************************************************
* 	                                           Local Types
****************************************************************************/

static T_ZDrvVib_State gVib_State = VIB_STATE_OFF;

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/
SINT32 vib_Open(VOID *devData, T_ZDRVIO_FLAGS flags);
SINT32 vib_Close(VOID *devData);
SINT32 vib_ctrl(VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg);

static SINT32 vib_Enable(T_ZDrvVib_Power bl_on);
static SINT32 vib_CheckState (T_ZDrvVib_State *state);

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_ZDrvIODev_Ops g_vibOps=
{
	.open	= vib_Open,
	.close	= vib_Close,
	.ctrl		= vib_ctrl
};

T_ZDrvIODev_Handle g_vibIoHandle = {0};
UINT32 g_VibGpioPin = NULL;


/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
void testvibrator(BOOL bl_on)
{
	vib_Enable(bl_on);
}

/**************************************************************************
* Function: Vib_Init
* Description: init  the vibrator device
* Parameters:
*   Input:
*              None
*   Outpu: None
* Returns:
*	        None
* Others: None
**************************************************************************/
SINT32 vib_Open(VOID *devData, T_ZDRVIO_FLAGS flags)
{

	
	
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: halVib_Init
* Description: init  the vibrator device
* Parameters:
*   Input:
*              None
*   Outpu: None
* Returns:
*	        None
* Others: None
**************************************************************************/
SINT32 vib_Close(VOID *devData)
{
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: halVib_Enable
* Description: enable or disable  the vibrator device
* Parameters:
*   Input:
*              bl_on TRUE open the vibrator,FALSE close the vibrator
*   Outpu: None
* Returns:
*	        None
* Others: None
**************************************************************************/
static SINT32 vib_Enable(T_ZDrvVib_Power bl_on)
{
	SINT32 nRet =0;
	
	nRet = zDrvGpio_SetFunc(g_VibGpioPin, GPIO42_GPIO42);
	zDrvGpio_SetDirection(g_VibGpioPin, GPIO_OUT);
    if(bl_on == VIB_POWER_ENABLE)
    {
		zDrvGpio_SetOutputValue(g_VibGpioPin, GPIO_HIGH);

		gVib_State =  VIB_STATE_ON;
    }
    else
    {
		zDrvGpio_SetOutputValue(g_VibGpioPin, GPIO_LOW);

		gVib_State = VIB_STATE_OFF;
    }

    return nRet;
}

/****************************************************************************
* Function: vib_ctrl
* Description: Ctrl vib device.
* Parameters:
*   Input:
*              None
*   Outpu: None
* Returns:
*	        DRV_SUCCESS: successfully Ctrl the vibdevice
*             DRV_ERR_NOT_OPENED: vib device not open.
*             DRV_ERROR: other error.
* Others: None
****************************************************************************/

SINT32 vib_ctrl(VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg)
{
	SINT32 ret = 0;
	vib_printf("in vib_ctrl	function=[%d]\n",function);

	if(!arg)
		return DRV_ERR_INVALID_PARAM;

	switch(function)
	{
		case IOCTL_VIB_ENABLE:
		{
			ret = vib_Enable(*(T_ZDrvVib_Power *)arg);
			break;
		}
		case IOCTL_VIB_CHECKSTA:
		{
			ret = vib_CheckState((T_ZDrvVib_State *)arg);
			break;
		}
		default:
		return DRV_ERR_INVALID_IOCTL_CMD;
	}

	return ret;
}


/**************************************************************************
* Function: vib_CheckState
* Description: get the vibrator state
* Parameters:
*   Input:
*              None
*   Outpu: None
* Returns:
*	        None
* Others: None
**************************************************************************/

static SINT32 vib_CheckState (T_ZDrvVib_State *state)
{
	#if 0
    T_ZDrvPmic_LdoOnoff status;

    status = zDrvPmic_GetVvibOnoff();

    if(status == PM_LDO_ON)
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
	#endif 

	*state = gVib_State;
	
	return DRV_SUCCESS ;
}

/**************************************************************************
* Function: Vib_SetInstance
* Description: vibrator function installr
* Parameters:
*   Input:
*            None
*
*   Outpu: None
* Returns:
*	        HAL_RET_OK
* Others: None
**************************************************************************/
static VOID vib_SetInstance(VOID)
{
    g_vibIoHandle = zDrvIODev_Connect(ZDRV_DEV_VIB, NULL, &g_vibOps);
}

/*******************************************************************************
 * Function: zDrvVib_Initiate
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvVib_Initiate(VOID)
{
	g_VibGpioPin = zDrvGpio_Request("vib_gpio_pin");
	if( g_VibGpioPin == NULL )
		return DRV_ERROR;
   vib_SetInstance();
   return DRV_SUCCESS;
}
