/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    uicc_trc.h
 * File Mark:    
 * Description:  This header file contains declarations for debug purposes.
 * Others:        
 * Version:       v1.0
 * Author:        mtr
 * Date:          2006-08-10
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#ifndef _UICC_TRC_H
#define _UICC_TRC_H

#ifdef TRAP_HANDLING
  #include "trap.h"
#endif

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#ifndef TRAP_HANDLING
  #define UICC_NO_DEBUG
#endif

#ifndef TRAP_UICC_UART /* These enumerations are now defined in trap.h */
  #define TRAP_UICC_UART      0x1000
  #define TRAP_UICC_TIMER     0x1001
  #define TRAP_UICC_ATR       0x1002
  #define TRAP_UICC_PPS       0x1003
  #define TRAP_UICC_T0_CMD    0x1004
  #define TRAP_UICC_T0_TRANS  0x1005
  #define TRAP_UICC_T1_BLOCK  0x1006
  #define TRAP_UICC_T1_LINK   0x1007
  #define TRAP_UICC_T1_TRANS  0x1008
  #define TRAP_UICC_CTRL      0x1009
  #define TRAP_UICC_IO        0x100A 
  #define TRAP_UICC_CI        0x100B 
#endif

#define UICC_TRACE_NOF_BUFFERS   4 /* Number of trace logs */
#define UICC_TRACE_LOG_SIZE      9 /* Header (5) + 2 data bytes + SW1 and SW2 */
#define UICC_MAX_LOG_STORE_SIZE 19 /* UICC Exception/Trap log store size. */

/****************************************************************************
* 	                                        Types
****************************************************************************/
/******************************************************************/
/************************                **************************/
/**********************       LOCAL        ************************/
/********************    TRAP & EXCEPTION    **********************/
/******************   IDENTIFICATION NUMBERS   ********************/
/******************** ~~~~~~~~~~~~~~~~~~~~~~ **********************/
/**********************                    ************************/
/************************                **************************/
/******************************************************************/

/* Sub identity number for TRAP_UICC_UART      */
/*-------------------------==============------*/
enum
{
  UICC_ACTIVATE_VCC_FAILED =1,
  UICC_DEACTIVATE_VCC_FAILED,
  UICC_DMA_ALLOC_FAILED
};

/* Sub identity number for TRAP_UICC_TIMER     */
/*-------------------------===============-----*/
enum
{
  UICC_FIRST_2 = 1
};

/* Sub identity number for TRAP_UICC_ATR       */
/*-------------------------=============-------*/
enum
{
  UICC_ANSWER_TO_RESET_FAILED_1 = 1,
  UICC_ANSWER_TO_RESET_FAILED_2,
  UICC_ANSWER_TO_RESET_FAILED_3    
};

/* Sub identity number for TRAP_UICC_PPS       */
/*-------------------------=============-------*/
enum
{
  UICC_PROTOCOL_SELECTION_FAILED_1 = 1,
  UICC_PROTOCOL_SELECTION_FAILED_2,
  UICC_PROTOCOL_SELECTION_FAILED_3          
};

/* Sub identity number for TRAP_UICC_T0_CMD    */
/*-------------------------================----*/
enum
{
  UICC_T0_INSTRUCTION_FAILED_1 = 1,
  UICC_T0_INSTRUCTION_FAILED_2,
  UICC_T0_INSTRUCTION_FAILED_3  
};

/* Sub identity number for TRAP_UICC_T0_TRANS  */
/*-------------------------==================--*/
enum
{
    UICC_T0_TRANS_ERROR_1 = 1,
    UICC_T0_TRANS_ERROR_2,
    UICC_T0_TRANS_ERROR_3    
};

/* Sub identity number for TRAP_UICC_T1_BLOCK  */
/*-------------------------==================--*/
enum
{
  UICC_T1_BLOCK_ERROR_1 = 1,
  UICC_T1_BLOCK_ERROR_2,
  UICC_T1_BLOCK_ERROR_3  
};

/* Sub identity number for TRAP_UICC_T1_LINK   */
/*-------------------------=================---*/
enum
{
  UICC_T1_LINK_ERROR_1 = 1,
  UICC_T1_LINK_ERROR_2,  
  UICC_T1_LINK_ERROR_3,  
  UICC_T1_LINK_ERROR_4    
};

/* Sub identity number for TRAP_UICC_T1_TRANS  */
/*-------------------------==================--*/
enum
{
  UICC_T1_TRANS_ERROR_1 = 1,
  UICC_T1_TRANS_ERROR_2,
  UICC_T1_TRANS_ERROR_3      
};

/* Sub identity number for TRAP_UICC_CTRL      */
/*-------------------------==============------*/
enum
{
  UICC_UNEXPECTED_EVENT = 1,
  UICC_NO_SIM_ACCESS_EVENT,
  UICC_MAIN_UNEXPT_EVENT,
  UICC_INVALID_BASEBAND_INFO
};

/* Sub identity number for TRAP_UICC_IO        */      
/*-------------------------============--------*/
enum
{
  UICC_CREATE_SEMAPHOR_ERROR = 1,
  UICC_OBTAIN_SEMAPHOR_ERROR,
  UICC_RELEASE_SEMAPHOR_ERROR,
  UICC_TRANSPORT_APDU_PARAMETER_ERROR,
  UICC_RESET_PARAMETER_ERROR,
  UICC_FAULTY_RESET_MODE,
  UICC_CLOSE_ERROR,
  UICC_WRONG_OPERATION_STATE = 40,
  UICC_WRONG_OPERATION_STATE_1,
  UICC_WRONG_OPERATION_STATE_2,
  UICC_WRONG_OPERATION_STATE_3,
  UICC_WRONG_OPERATION_STATE_4,
  UICC_WRONG_OPERATION_STATE_5,
  UICC_WRONG_OPERATION_STATE_6  
};

/* Sub identity number for TRAP_UICC_CI        */      
/*-------------------------============--------*/
enum
{
  UICC_WRITECMD_UNKNOWN_INS = 1, 
  UICC_WRITECMD_APDU_EXECUTION_ERROR,
  UICC_WRITECMD_PARAM_ERROR,
  UICC_RESETCARD_FAILED,
  UICC_DEACTIVATECARD_FAILED  
};

/*---------------------------------------------*/
/* External defines.                           */
/*---------------------------------------------*/
#ifndef UICC_NO_DEBUG
  typedef struct
  {
    ushort  nof_ins_req;   /* The number of hits on SIM_WriteCmd from host. */
    ushort  nof_ins_cnt;   /* The number of commenced instructions by UICC_ctrl_ins */
    ushort  nof_ins_con;   /* The number of ins. confirm mails sent to host. */
    ushort  nof_status_ind;/* The number of status mails sent to host. */
    ubyte   log_buf_cnt;   /* Current used log buffer */
    ubyte   log_buf[UICC_TRACE_NOF_BUFFERS][UICC_TRACE_LOG_SIZE]; /* Instruction log buffer */
  } T_UICC_TRACE;
#endif

/****************************************************************************
 *                                           Constants
 ****************************************************************************/
                     
/****************************************************************************
 *                                           Global  Variables
 ****************************************************************************/
#ifndef UICC_NO_DEBUG
  extern T_UICC_TRACE UICC_trace;
#endif

#ifndef UICC_NO_DEBUG
  /* Pointer for storing debug information in connection with exception 
     or TRAP handling. The maximum store size is limited to size defined
     by UICC_MAX_LOG_STORE_SIZE. */
  extern ubyte *UICC_log_data_ptr;
#endif

/****************************************************************************
*                                           Function Prototypes
****************************************************************************/
extern void UICC_raise_exception(ushort trap_id, ubyte local_id, ubyte log_data_size);
extern void UICC_generate_sw_trap(ushort trap_id, ubyte local_id, ubyte log_data_size);

#endif /*  _UICC_TRC_H*/

                                                 /* End of file.              */
