/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_REF_CFG_H_
#define _DRVS_REF_CFG_H_
#include "drvs_sys.h"
#include "drvs_pmic_regulator.h"
#include "drvs_chip_cfg.h" 			/*for reg base*/
#include <generated/autoconf.h>



/************************************charger*********************************/
#define CHG_IN_GPIO_FUNC_SEL	GPIO48_GPIO48
#define CHG_IN_EXT_INT_FUNC_SEL	GPIO48_EXT_INT1
#define CHG_STATE_GPIO_FUNC_SEL	GPIO54_GPIO54
#define CHG_STATE_EXT_INT_FUNC_SEL	GPIO54_EXT_INT7
#define CHG_CTRL_GPIO_FUNC_SEL	GPIO130_GPIO130
#define CHG_EN_GPIO_FUNC_SEL	GPIO131_GPIO131

#define CHG_STATE_INT    EX7_INT
#define CHG_IN_INT      EX1_INT
/************************************charger   end*********************************/

/************************************i2c*********************************/
#define I2C0_CLK_FUN_SEL	GPIO43_SCL0
#define I2C0_DATA_FUN_SEL	GPIO44_SDA0

#define I2C1_CLK_FUN_SEL	GPIO45_SCL1
#define I2C1_DATA_FUN_SEL	GPIO46_SDA1

#define I2C0_WCLK_SEL      WCLK_I2C_26M
#define I2C1_WCLK_SEL      WCLK_I2C_26M

/************************************i2c end*********************************/


/************************************lcd*********************************/
//#define LCD_BL_IC_USED   /*GPIO used*/

#define LCD_TE_ON

/* LOAD-BY-TRACE flag storing address.
    1. In normal startup procedure, BOOT will clear all IRAM space. So the value of this address will be 0.
    2. In LOAD-BY-TRACE procedure, *.cmm script file have already set this address's content to 1. */
#define LCD_LOADBYTRACEFLAG_ADDR    (0x82000500)

#define PIN_SPI_CS			GPIO25
#define PIN_SPI_SCL			GPIO26
#define PIN_SPI_SDA			GPIO28
#define PIN_SPI_DCX 			GPIO27
#define PIN_LCD_TE                 GPIO49
#define PIN_LCD_BL_EN           GPIO119
#define PIN_LCD_RST 		       GPIO120


#define SPI_CS_FUNC_SEL 	GPIO25_SSP0_CS
#define SPI_SCL_FUNC_SEL 	GPIO26_SSP0_CLK
#define SPI_SDA_FUNC_SEL 	GPIO28_SSP0_TXD
#define SPI_DCX_FUNC_SEL 	GPIO27_SSP0_RXD

#define GPIO_CS_FUNC_SEL 	GPIO25_GPIO25
#define GPIO_SCL_FUNC_SEL 	GPIO26_GPIO26
#define GPIO_SDA_FUNC_SEL 	GPIO28_GPIO28
#define GPIO_DCX_FUNC_SEL 	GPIO27_GPIO27

#define GPIO_RST_FUNC_SEL 	GPIO120_GPIO120
#define GPIO_BL_EN_FUNC_SEL 	GPIO119_GPIO119

#ifdef LCD_TE_ON
#define GPIO_TE_FUNC_SEL GPIO49_EXT_INT2
#define LCD_TE_INT   EX2_INT
#define LCD_TE_INT_LEVEL   INT_NEGEDGE
#endif


/************************************lcd end*********************************/


/************************************pmic*********************************/
/*define the pmic int to ps or ap*/
#define PMIC_INT_TO_PS

#define PMIC_INT_0              ( EX0_INT )
#define EXT_INT0_PMIC_FUNC_SEL	GPIO47_EXT_INT0
#define PSHOLD1_PIN_GPIO_DIRECTION   GPIO_OUT/*the diff debug by GPIO*/

#define PMIC_LLP_DEFINE  LLP_SHUTDOWN

/************************************pmic end*********************************/

/************************************spi*********************************/
#define PIN_SPI_CS_0		GPIO25
#define PIN_SPI_RX_0		GPIO27
#define PIN_SPI_TX_0		GPIO28
#define PIN_SPI_CLK_0		GPIO26

#define PIN_SPI_CS_1		GPIO87
#define PIN_SPI_RX_1		GPIO89
#define PIN_SPI_TX_1		GPIO90
#define PIN_SPI_CLK_1		GPIO88

#define GPIO_FUN_SPI_CS_0	GPIO25_GPIO25
#define GPIO_FUN_SPI_RX_0	GPIO27_GPIO27
#define GPIO_FUN_SPI_TX_0	GPIO28_GPIO28
#define GPIO_FUN_SPI_CLK_0	GPIO26_GPIO26

#define GPIO_FUN_SPI_CS_1	GPIO87_GPIO87
#define GPIO_FUN_SPI_RX_1	GPIO89_GPIO89
#define GPIO_FUN_SPI_TX_1	GPIO90_GPIO90
#define GPIO_FUN_SPI_CLK_1	GPIO88_GPIO88

#define SSP_FUN_SPI_CS_0	GPIO25_SSP0_CS
#define SSP_FUN_SPI_RX_0	GPIO27_SSP0_RXD
#define SSP_FUN_SPI_TX_0	GPIO28_SSP0_TXD
#define SSP_FUN_SPI_CLK_0	GPIO26_SSP0_CLK

#define SSP_FUN_SPI_CS_1	GPIO87_CAM_SPI_CS
#define SSP_FUN_SPI_RX_1	GPIO89_CAM_SPI_DATA0
#define SSP_FUN_SPI_TX_1	GPIO90_CAM_SPI_TXD
#define SSP_FUN_SPI_CLK_1	GPIO88_CAM_SPI_CLK

typedef enum _T_SspMasterFreq
{
	SSP_MASTER_52M = 	WCLK_SSP_104M,
	SSP_MASTER_39M = 	WCLK_SSP_78M,
	SSP_MASTER_26M = 	WCLK_SSP_52M,
	SSP_MASTER_13M = 	WCLK_SSP_26M,
	SSP_MASTER_6M5 = 	WCLK_SSP_13M,
}
T_SspMasterFreq;

typedef enum _T_SspSlaveFreq
{		
	SSP_SLAVE_39M = 	WCLK_SSP_156M,
	SSP_SLAVE_26M = 	WCLK_SSP_104M,
	SSP_SLAVE_19M5 = 	WCLK_SSP_78M,
	SSP_SLAVE_13M = 	WCLK_SSP_52M,
	SSP_SLAVE_6M5 = 	WCLK_SSP_26M,
}
T_SspSlaveFreq;

#ifdef _USE_LCD_SIZE_240_320
#define DEF_SSP0_CFG_SSPCLK		SSP_MASTER_39M 
#else
#define DEF_SSP0_CFG_SSPCLK		SSP_MASTER_13M 
#endif
/************************************spi end*********************************/

#define SD_FUN_HOST_CLK_1 		GPIO72_SD1_HOST_SDCLK
#define SD_FUN_HOST_CMD_1 		GPIO73_SD1_CMD
#define SD_FUN_HOST_DATA0_1 	GPIO74_SD1_DATA0
#define SD_FUN_HOST_DATA1_1 	GPIO75_SD1_DATA1
#define SD_FUN_HOST_DATA2_1 	GPIO76_SD1_DATA2
#define SD_FUN_HOST_DATA3_1 	GPIO77_SD1_DATA3

/************************************int**************************************/
#define INT_MODE_BASE        (PS_CRM_REG_BASE + 0x2070)

/************************************int end*********************************/


/************************************spinlock*********************************/
#define SHARED_DEVICE1_REG	 (SOC_CRM_REG_BASE + 0x170)
#define SHARED_DEVICE2_REG	 (SOC_CRM_REG_BASE + 0x174)
#define SHARED_DEVICE3_REG	 (SOC_CRM_REG_BASE + 0x178)
#define SHARED_DEVICE4_REG	 (SOC_CRM_REG_BASE + 0x17c)
#define SHARED_DEVICE5_REG	 (SOC_CRM_REG_BASE + 0x180)
#define SHARED_DEVICE6_REG	 (SOC_CRM_REG_BASE + 0x184)
#define SHARED_DEVICE7_REG	 (SOC_CRM_REG_BASE + 0x188)
#define SHARED_DEVICE8_REG	 (SOC_CRM_REG_BASE + 0x18c)

/************************************spinlock end*********************************/
/************************************audio_config*********************************/
//_USE_REF_AUDIO_ON_7520V3_PHONE
#define AUDIO_CODEC_EN_GPIO_FUNC_SEL	GPIO123_GPIO123
#define AUDIO_CODEC_RESET_GPIO_FUNC_SEL	GPIO122_GPIO122
#define AUDIO_CODEC_CLK_GPIO_FUNC_SEL	GPIO15_CLK_OUT0
/************************************audio_config   end*********************************/

/************************************camera*********************************/
#define CAMERA_FUN_POWER       GPIO128_GPIO128
#define CAMERA_FUN_PWDN        GPIO127_GPIO127
#define CAMERA_FUN_MCLK        GPIO16_CLK_OUT1

/************************************camera end*********************************/

/************************************spicc*********************************/
#define SPICC_FUN_CLK          	GPIO88_CAM_SPI_CLK
#define SPICC_FUN_DATA0			GPIO89_CAM_SPI_DATA0
#define SPICC_FUN_DATA1			GPIO90_CAM_SPI_DATA1
#define SPICC_FUN_DATA2			GPIO91_CAM_SPI_DATA2
#define SPICC_FUN_DATA3			GPIO92_CAM_SPI_DATA3


/************************************spicc end*********************************/

/************************************uicc************************************/
#ifdef CONFIG_ARCH_ZX297520V3_MDL
#define UICC_GPIO			ZX29_GPIO_49
#define UICC_GPIO_FUN_GPIO	GPIO49_GPIO49
#define UICC_GPIO_EXT_INT	GPIO49_EXT_INT2
#define UICC_EXT_INT		EX2_INT
//xf.li@20230410 add for sim hot-swappable start
#define SIM_IN				GPIO_LOW
#define SIM_OUT				GPIO_HIGH
#define SIM_IN_LEVEL		INT_LOWLEVEL
#define	SIM_OUT_LEVEL		INT_HIGHLEVEL
//#define SIM_IN				GPIO_HIGH
//#define SIM_OUT				GPIO_LOW
//#define SIM_IN_LEVEL		INT_HIGHLEVEL
//#define	SIM_OUT_LEVEL		INT_LOWLEVEL
//xf.li@20230410 add for sim hot-swappable end
#else 
#define UICC_GPIO			ZX29_GPIO_50
#define UICC_GPIO_FUN_GPIO	GPIO50_GPIO50
#define UICC_GPIO_EXT_INT	GPIO50_EXT_INT3
#define UICC_EXT_INT		EX3_INT
#define SIM_IN				GPIO_LOW
#define SIM_OUT				GPIO_HIGH
#define SIM_IN_LEVEL		INT_LOWLEVEL
#define	SIM_OUT_LEVEL		INT_HIGHLEVEL

#endif

#define UICC_GPIO_NAME		"usim_in"
#if (defined CONFIG_ARCH_ZX297520V3_EVB) || (defined CONFIG_ARCH_ZX297520V3_MDL) || (defined CONFIG_ARCH_ZX297520V3_CPE) || (defined CONFIG_ARCH_ZX297520V3_WATCH)
#define UICC_ENABLE_IN_OUT_DETECTION
#endif
/**********************************uicc end**********************************/


/************************************dma*********************************/
#define DMAC0_CFG_CH0		DMA_CHANNEL_CONFIG(DMAC0_CH_UART0_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH1		DMA_CHANNEL_CONFIG(DMAC0_CH_UART0_RX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH2		DMA_CHANNEL_CONFIG(DMAC0_CH_UART1_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH3		DMA_CHANNEL_CONFIG(DMAC0_CH_UART1_RX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH4		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP0_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH5		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP0_RX,CORE_ID_ARM0,FALSE,TRUE)
#define DMAC0_CFG_CH6		DMA_CHANNEL_CONFIG(DMAC0_CH_GPRS0,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH7		DMA_CHANNEL_CONFIG(DMAC0_CH_GPRS1,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH8		DMA_CHANNEL_CONFIG(DMAC0_CH_USIM,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH9		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S0_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH10		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S0_RX0,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH11		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S1_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH12		DMA_CHANNEL_CONFIG(DMAC0_CH_I2S1_RX0,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH13		DMA_CHANNEL_CONFIG(DMAC0_CH_SPIFC0_TX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH14		DMA_CHANNEL_CONFIG(DMAC0_CH_SPIFC0_RX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH15		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP1_TX,CORE_ID_ARM0,FALSE,TRUE)
#define DMAC0_CFG_CH16		DMA_CHANNEL_CONFIG(DMAC0_CH_SSP1_RX,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH17		DMA_CHANNEL_CONFIG(DMAC0_CH_UART2_TX,CORE_ID_ARM0,FALSE,TRUE)
#define DMAC0_CFG_CH18		DMA_CHANNEL_CONFIG(DMAC0_CH_UART2_RX,CORE_ID_ARM0,FALSE,TRUE)
#define DMAC0_CFG_CH19		DMA_CHANNEL_CONFIG(DMAC0_CH_EMBMS,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH20		DMA_CHANNEL_CONFIG(DMAC0_CH_USIM1,CORE_ID_ARM0,FALSE,FALSE)
#define DMAC0_CFG_CH21		DMA_CHANNEL_CONFIG(DMAC0_CH_M2M_TX,CORE_ID_ARM0,FALSE,TRUE)
#define DMAC0_CFG_CH22		DMA_CHANNEL_CONFIG(DMAC0_CH_M2M_RX,CORE_ID_ARM0,FALSE,TRUE)
/************************************dma end*********************************/

#endif/*_DRVS_REF_CFG_H_*/
