/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    Drvs_voiceprocess.h
 * File Mark:
 * Description:  Provide the interface of using vp
 * Others:
 * Version:       V0.5
 * Author:        lvwenhua
 * Date:          2012-06-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_VP_H
#define _DRVS_VP_H

#include "drvs_i2s.h"
#include "drvs_tdm.h"
#include "drvs_volte.h"
#include "drvs_rpmsg.h"
#include "NvParam_drv.h"

#define VOICE_TONE_MIXER_FUNCTION
//#define TEST_WHITE_NOISE
typedef enum
{
    VP_I2S_IDLE = 0,
    VP_I2S_OPEN,
    VP_I2S_INUSE,
    VP_LOOP_ON
} T_Vp_I2sStatus;

/*  Voice process channel selection. */
typedef enum
{
    VP_PATH_HANDSET    = 0,
    VP_PATH_SPEAKER,
    VP_PATH_HEADSET,
    VP_PATH_BLUETOOTH,
    VP_PATH_BLUETOOTH_NO_NR,
    VP_PATH_HSANDSPK,

    VP_PATH_OFF = 255,

    MAX_VP_PATH = VP_PATH_OFF
} T_ZDrv_VpPath;

typedef enum
{
    VP_VOL_0    = 0,
    VP_VOL_1,
    VP_VOL_2,
    VP_VOL_3,
    VP_VOL_4,
    VP_VOL_5,
    VP_VOL_6,
    VP_VOL_7,
    VP_VOL_8,
    VP_VOL_9,
    VP_VOL_10,
    VP_VOL_11,

    MAX_VP_VOL
} T_ZDrv_VpVol;

typedef enum
{
    VP_FS_8000  = 0,              ///< 8k sampling rate
    VP_FS_11025 = 1,              ///< 11.025k sampling rate
    VP_FS_12000 = 2,              ///< 12k sampling rate
    VP_FS_16000 = 3,              ///< 16k sampling rate
    VP_FS_22050 = 4,              ///< 22.050k sampling rate
    VP_FS_24000 = 5,              ///< 24k sampling rate
    VP_FS_32000 = 6,              ///< 32k sampling rate
    VP_FS_44100 = 7,              ///< 44.1k sampling rate
    VP_FS_48000 = 8,              ///< 48k sampling rate
    MAX_VP_FS = 9              ///< Max sampling rate count

} T_ZDrv_VpFs;

typedef enum
{
    VP_DTMF_KEY_0    = 0,
    VP_DTMF_KEY_1,
    VP_DTMF_KEY_2,
    VP_DTMF_KEY_3,
    VP_DTMF_KEY_4,
    VP_DTMF_KEY_5,
    VP_DTMF_KEY_6,
    VP_DTMF_KEY_7,
    VP_DTMF_KEY_8,
    VP_DTMF_KEY_9,
    VP_DTMF_KEY_10,    /*  *  */
    VP_DTMF_KEY_11,    /*  # */

    MAX_VP_DTMF_KEY
} T_ZDrv_VpDtmfKey;


//typedef   T_ZDrvVolte_Cfg  T_ZDrvVp_Cfg
typedef struct
{
	char* pPresetRx;
	unsigned long PresetLengthRx;
	char* pPresetTx;
	unsigned long PresetLengthTx;
} zDrvVp_NxpParamsTool;

typedef struct
{
	char* pPresetRx;
	unsigned long PresetLengthRx;
	char* pPresetTx;
	unsigned long PresetLengthTx;
} zDrvVp_ParamsTool;

typedef enum
{
    VP_VOICE_SOURCE ,
    VP_AUDIO_SOURCE ,
    VP_FM_SOURCE ,
    VP_EXTERN_AUDIO,
    VP_SOURCE_MAX
} T_ZDrvVp_SourceType;

/* 0 lowpower;1 sms;2 call standard;3 alarm beep;*/
typedef enum
{
    VP_LOWPOWER_TONE ,
    VP_SMS_TONE ,
    VP_CALLSTD_TONE ,
    VP_ALARM_TONE,
    VP_CALL_TIME_TONE,
    VP_0_KEY_TONE,
    VP_1_KEY_TONE,
    VP_2_KEY_TONE,
    VP_3_KEY_TONE,
    VP_4_KEY_TONE,
    VP_5_KEY_TONE,
    VP_6_KEY_TONE,
    VP_7_KEY_TONE,
    VP_8_KEY_TONE,
    VP_9_KEY_TONE,
    VP_HASH_KEY_TONE,	    //#
    VP_ASTERRIX_KEY_TONE,	    //*
    VP_RESERVED1_TONE,
    VP_RESERVED2_TONE,
    VP_RESERVED3_TONE,
    VP_RESERVED4_TONE,
    VP_RESERVED5_TONE,
    VP_RESERVED6_TONE,
    VP_TONE_MAX
} T_ZDrvVp_ToneNum;
typedef struct _T_HalMixerToneInfo
{
	BOOL StartMixer;/*mixer flag TRUE  start, FALSE stop;*/
	BOOL dataIsWb;/* TRUE  wb, FALSE nb, for voice mixer;*/
	UINT32 cur_tone_fcount;/*tone data already processed count*/
	UINT32 tone_total_size;/*tone data total size,unit 2byte*/
	UINT32 inter_mixer_fcount;/*inter ,tone_size/data_mixer_oncesize*/
	UINT32 rem_mixer_count;/*remainder ,  tone_size%data_mixer_oncesize*/
	UINT16 *ptdata_mixer;/* tone data array pointer */
	UINT32 data_mixer_oncesize;/*the size of a data processing, unit 2byte*/
} T_HalMixerToneInfo;

typedef struct _T_HalAudioLoopTestInfo
{
	BOOL startLoopTest;/*audo loop test flag TRUE  start, FALSE stop;*/
	UINT32 fs;/*tone data real frequence*/
	UINT32 sampFs;/*tone data sample frequence*/
	UINT8 *ptdata;/* audo loop test data array pointer */
	UINT32 totalSize;/*tone data total size,unit 2byte*/
	T_ZDrv_VpVol outpathvol[4];

} T_HalAudioLoopTestInfo;
typedef struct _T_HalAudioLoopTestPra
{
	UINT8 *src;/*tone data frequence*/
	UINT8 *dest;/*tone data sample frequence*/
	UINT32 sampfs;

} T_HalAudioLoopTestPra;

typedef enum
{
    ECALL_ST_INIT = 0,
	ECALL_ST_OPEN,//1				
	ECALL_ST_START,//2			
    ECALL_ST_IDLE,//3	
    ECALL_ST_RX_IDLE,//4	
    ECALL_ST_TX_IDLE,//5	
    ECALL_ST_INUSE,//6	
    ECALL_ST_RX_INUSE,//7	
    ECALL_ST_TX_INUSE,//8	     
	ECALL_ST_STOP,//9	
	ECALL_ST_CLOSE,//10		
    ECALL_ST_MAX
} T_Ecall_State;

 
typedef struct
{
	T_DrvEcall_Opt	opt;
	ZOSS_TIMER_ID timerId ;
	ZOSS_SEMAPHORE_ID wrSemaphore; 
	ZOSS_SEMAPHORE_ID rdSemaphore;
	T_Ecall_State ecallSta;
    T_Ecall_State ecallRxSta;//two state,idle/inuse
	T_Ecall_State ecallTxSta;//two state,idle/inuse	
	unsigned char* rxDataBuf;
	unsigned char* txDataBuf;
	int dataBufSize;

} T_Hal_EcallData; 

typedef struct
{
	//use for vp data process
	UINT8* pVpTempRxInBuffer;   //pVpRxInBuffer
	UINT8* pVpTempTxInBuffer;   //pVpTxInBuffer
	UINT8* pVpTempRxOutPutBuffer;//pVpRxOutPutBuffer
	UINT8* pVpTempTxOutPutBuffer;//pVpTxOutPutBuffer

	T_ZDrvI2S_Cfg *pVpI2sCfg; //i2s cfg

	T_ZDrvVp_Cfg vpCfgParam; //s_cfgParam

	T_ZDrvI2s_Params i2sWriteParam; //s_VpI2sWriteParam
	T_ZDrvI2s_Params i2sReadParam; //s_vpI2sReadParam

	UINT32 frameCount; //s_vpFrameCount
	UINT32 totalFrameBufSize; //s_vpTotalFrameBufSize
	UINT32 inOutBufUseSize; //s_inOutBufUseSize
	UINT32 rxSaveLen; //s_rxSaveLen
	UINT32 txSaveLen; //s_txSaveLen
	UINT32 saveLen; //save_len

	UINT8 pcmSlotNum; //s_vpPcmSlotNum
	UINT8 pcmWbSecDataPosition; //s_vpPcmWbSecDataPosition

	UINT8 volteVpWriteStopFlag;//s_volteVpWriteStopFlag
	UINT8 volteVpReadStopFlag;//s_volteVpReadStopFlag
	UINT8 volteVpCfgEnFlag; // s_volteVpCfgEnFlag
	BOOL firstWriteDataFlag;//s_firstWriteDataFlag
	BOOL firstReadDataFlag;//s_firstReadDataFlag
	BOOL i2sIsRstFlag;//s_i2sIsRstFlag
} T_zDrvVp_SpeechState; // T_zDrvVp_SpeechState

typedef struct
{
	UINT8 volteIsWb; //1 g_volteIsWb 
	UINT8 isUseSlicCodec; //2 g_isUseSlicCodec 
	UINT8 g_isUseTdm; //3
//for voice data process
	UINT8 voiceInGsmTdMode; //4 g_voiceInGsmTdMode 
	UINT8 voiceInVolteMode; //5 g_voiceInVolteMode 

	BOOL innerI2sIsMaster;//6 arm i2s2   g_innerI2sIsMaster 
	BOOL innerI2sIsI2sMode; //7 g_innerI2sIsI2sMode 
	BOOL vpLoopRuning; //8 g_vpLoopRuning 
	BOOL muteEn; //9 g_vpMuteEn 
	//BOOL nxpIsNormal; //10 g_vpNxpIsNormal  
	BOOL vProcIsNormal; //11 voice processing is normal flag 
	T_Vp_I2sStatus vpI2sStatus; //12 VpI2sStatus 

	T_ZDrv_VpPath  vpPath;//13 VP_PATH_HEADSET;//VP_PATH_SPEAKER; //VP_PATH_HANDSET; g_vpPath
	T_ZDrv_VpPath  vpLoopPath; //14 g_vpLoopPath 
	T_ZDrv_VpVol vpVol; //15 g_vpVol
	T_ZDrvVoice_MODE voiceMode; //16 g_vpVoiceMode
	SINT8 vpInitGain; //17 s_vpInitGain
	T_Audio_NvFlag	audio_ctrlFlag;//18 USE 32byte

    UINT8 dtmfDirSel;//19
    UINT32 sample_rate;//20
    UINT8 useDtmfLoop;//21
    SINT32 muteCount;//22 mute_count
    BOOL vpLoopBkRunning;//23 
	BOOL rxMuteEn; //24
	BOOL firstRegZCATFlag; //25
	T_Hal_EcallData	ecallData;//26
    UINT8 voice_nv_update;//27
} T_zDrvVoice_GbVar; //T_zDrvVoice_GbVar

typedef struct
{
	//use for store memory address
	UINT8* pVpRxInBuffer;  //s_pVpRxInBuffer
	UINT8* pVpTxInBuffer; //s_pVpTxInBuffer
	UINT8* pVpRxOutPutBuffer; //s_pVpRxOutPutBuffer
	UINT8* pVpTxOutPutBuffer; //s_pVpTxOutPutBuffer

	UINT32 inOutBufSize; //s_inOutBufSize

	T_ZDrvI2S_Cfg *pVpInnerI2sCfg;  //s_pVpInnerI2sCfg
	T_ZDrvI2S_Cfg *pVpExtI2sCfg;   //s_pVpExtI2sCfg
	T_ZDrvI2S_Cfg *pVpExtI2sWbCfg; //s_pVpExtI2sWbCfg
	T_ZDrvTdm_Cfg *s_pVpTdmCfg;
	T_ZDrvTdm_Cfg *s_pVpTdmWbCfg;
	T_ZDrvTdm_Cfg *pVpTdmCfg;

	T_ZDrvRpMsg_Msg pMsg;
	SINT32 pMsgBuf[2];
	//SINT32 muteCount;//mute_count

	ZOSS_THREAD_ID vpThread ; //s_VpThread
	ZOSS_THREAD_ID rcvDtmfThread ; //s_rcvDtmfThread
	ZOSS_SEMAPHORE_ID vpSemaphore; //s_VpSemaphore
	ZOSS_SEMAPHORE_ID vpThreadQuitSema;

	ZOSS_THREAD_ID vpLoopThread; //s_VpLoopThread
	ZOSS_SEMAPHORE_ID vpLoopSemaphore; //s_VpLoopSemaphore

	T_zDrvVp_SpeechState *vpState;
//	T_zDrvVoice_GbVar wrapVpGbVar;
} T_zDrvVp_State; //T_zDrvVp_State

SINT32 zDrvVp_SetPath(T_ZDrv_VpPath path);
SINT32 zDrvVp_SetVol(T_ZDrv_VpVol volume);
SINT32 zDrvVp_SetGain(SINT32 vgain, UINT32 channel);
/* 0 lowpower;1 sms;2 call standard;3 alarm beep;*/
SINT32 zDrvVp_ToneMixerStart(T_ZDrvVp_ToneNum toneNum);
SINT32 zDrvVp_SetMute(UINT32 enable, UINT32 channel);
SINT32 zDrvVp_RcdOnOff(UINT32 on);
SINT32 zDrvVp_DtmfTone(UINT32 Num);
SINT32 zDrvVp_Loop(T_ZDrv_VpPath path);
SINT32 zDrvVp_RingStart(VOID);
SINT32 zDrvVp_RingStop(VOID);
VOID zDrvVp_SetUseSlicFlag(BOOL useSlic);
SINT32 zDrvVp_NxpSetParam(zDrvVp_NxpParamsTool *NxpParamsTool);
SINT32 zDrvVp_NxpGetParam(zDrvVp_NxpParamsTool *NxpParamsTool);
SINT32 zDrvVp_SetFmPath(T_ZDrv_VpPath path, BOOL enable);
SINT32 zDrvVp_SetParam(zDrvVp_ParamsTool *paramsTool);
SINT32 zDrvVp_GetParam(zDrvVp_ParamsTool *paramsTool);
SINT32 zDrvVp_SetNvParam(zDrvVp_ParamsTool *paramsTool);
SINT32 zDrvVp_GetNvParam(zDrvVp_ParamsTool *paramsTool);

	
#endif
