/* ------------------------------------------------------------------
 * Copyright (C) 1998-2009 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/****************************************************************************************
Portions of this file are derived from the following 3GPP standard:

    3GPP TS 26.073
    ANSI-C code for the Adaptive Multi-Rate (AMR) speech codec
    Available from http://www.3gpp.org

(C) 2004, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TTA, TTC)
Permission to distribute, modify and use this file under the standard license
terms listed above has been obtained from the copyright holder.
****************************************************************************************/
/*
------------------------------------------------------------------------------



 Filename: ets_to_wmf.cpp
 Functions: ets_to_wmf

------------------------------------------------------------------------------
*/

/*----------------------------------------------------------------------------
; INCLUDES
----------------------------------------------------------------------------*/
#include "ets_to_ietf.h"
#include "typedef.h"

/*----------------------------------------------------------------------------
; MACROS
; Define module specific macros here
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; DEFINES
; Include all pre-processor statements here. Include conditional
; compile variables also.
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
; LOCAL FUNCTION DEFINITIONS
; Function Prototype declaration
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
; LOCAL VARIABLE DEFINITIONS
; Variable declaration - defined here and used outside this module
----------------------------------------------------------------------------*/

void ets_to_ietf(
    enum Frame_Type_3GPP frame_type_3gpp,
    Word16 *ets_input_ptr,
    UWord8 *ietf_output_ptr,
    CommonAmrTbls* common_amr_tbls)
{
    Word16  i;
    Word16  k = 0;
    Word16  j = 0;
    Word16 *ptr_temp;
    Word16  bits_left;
    UWord8  accum;
    const Word16* const* reorderBits_ptr = common_amr_tbls->reorderBits_ptr;
    const Word16* numOfBits_ptr = common_amr_tbls->numOfBits_ptr;

    ietf_output_ptr[j++] = (UWord8)(frame_type_3gpp << 3);

    if (frame_type_3gpp < AMR_SID)
    {
        for (i = 0; i < numOfBits_ptr[frame_type_3gpp] - 7;)
        {
            ietf_output_ptr[j]  =
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 7;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 6;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 5;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 4;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 3;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 2;
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << 1;
            ietf_output_ptr[j++] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]];
        }

        bits_left = numOfBits_ptr[frame_type_3gpp] -
                    (numOfBits_ptr[frame_type_3gpp] & 0xFFF8);

        ietf_output_ptr[j] = 0;

        for (k = 0; k < bits_left; k++)
        {
            ietf_output_ptr[j] |=
                (UWord8) ets_input_ptr[reorderBits_ptr[frame_type_3gpp][i++]] << (7 - k);

        }
    }
    else
    {

        ptr_temp = &ets_input_ptr[0];

        for (i = numOfBits_ptr[frame_type_3gpp] - 7; i > 0; i -= 8)
        {
            accum  = (UWord8) * (ptr_temp++) << 7;
            accum |= (UWord8) * (ptr_temp++) << 6;
            accum |= (UWord8) * (ptr_temp++) << 5;
            accum |= (UWord8) * (ptr_temp++) << 4;
            accum |= (UWord8) * (ptr_temp++) << 3;
            accum |= (UWord8) * (ptr_temp++) << 2;
            accum |= (UWord8) * (ptr_temp++) << 1;
            accum |= (UWord8) * (ptr_temp++);

            ietf_output_ptr[j++] = accum;
        }

        bits_left = numOfBits_ptr[frame_type_3gpp] -
                    (numOfBits_ptr[frame_type_3gpp] & 0xFFF8);

        ietf_output_ptr[j] = 0;

        for (i = 0; i < bits_left; i++)
        {
            ietf_output_ptr[j] |= *(ptr_temp++) << (7 - i);
        }
    }

    return;
}
