/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains the primary interrupt handling routines within the audio driver
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_interrupt.c
 *   Version: \main\6
 *   Date: 2007-10-02 09:06:52
 *   Responsible: johansek
 *   Comment:
 *     Removed compiler warning.
 */

#if !defined (_OSE_TYPES_H)
#define NUCLEUS_HISR
#endif 

/*******************************************************************************
*
*                               Include files
*
*******************************************************************************/
//#include "scttypes.h"           /* must be included in all files */
//#include "ms.h"                 /* must be included in all files */
#include "bastypes.h"           /* must be included in all files */
//#include "hw_reg.h"             /* Hardware register definitions */
//#include "REG_SGOLD_Regs.h"
#include "ptf.h"                /* Platform defines */
//#include "ilevels.h"            /* Platform defines */
#include "drvs_rtt.h"                /* Real-time timers */
#if defined(TRAP_HANDLING)
//#include "trap.h"               /* Exception and trap logging */
#endif
#include "aud_drv.h"            /* Audio driver types and functions */
#include "aud_com.h"            /* Types and functions used only within the audio driver */
#include "aud_vms_rec.h"        /* Interrupt handler for Voice Memo recorder */
#include "aud_vms_playback.h"   /* Interrupt handler for Voice Memo player */
#include "aud_ringer.h"              /* Interrupt handler for midi player */
#include "aud_i2s.h"                  /* Interrupt handler for I2S true slave mode */
#include "ThreadPriority.h"        /* Interrupt  Priority*/
#include "drvs_int.h"
#include "drvs_teak.h"



/*******************************************************************************
*
*                             External variables
*
*******************************************************************************/
#if defined (MP3_PRESENT) || defined (INTERNAL_POLYRINGER) || defined (PCM_PLAYER) || defined (VMS_PRESENT)
/* HISRs declared in drv_init.c through a define in drv_init.h */
extern NU_HISR AUD_POAK_INT2_HISR_control;
extern NU_HISR AUD_TEAK_INT4_HISR_control;
extern NU_HISR AUD_TEAK_INT5_HISR_control;
extern NU_HISR AUD_TEAK_INT6_HISR_control;
extern NU_HISR AUD_TEAK_INT7_HISR_control;

extern ZOSS_SEMAPHORE_ID  MIDI_SemaPID; //modify by lvwenhua 20150317
extern ZOSS_SEMAPHORE_ID  TONE_SemaPID; //modify by lvwenhua 20150317
extern ZOSS_SEMAPHORE_ID  VM_SemaPID; //modify by lvwenhua 20150317

extern VOID zDrv_VoiceMemoActive(VOID);
extern VOID zDrv_MidiActive(VOID);



/*******************************************************************************
*
*                        Externally visible functions
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: AUD_POAK_INT2_int_handler
* Return.....: -
* Description: Enables the interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_POAK_INT2_int_handler(
    int vector) /* not used */
{
    zDrv_VoiceMemoActive();
    SCU_DSPSRC2 |= CLEAR_INT;
}
/*------------------------------------------------------------------------------
* Function...: AUD_poak_int2_handle_int
* Return.....: -
* Description: Interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_poak_int2_handle_int()
{
    static U8 Previous_vm_cmd_hisr_complete = TRUE;
#if defined (MP3_PRESENT)
    static U8 Previous_mp3_playback_hisr_complete = TRUE;

    if(TRUE == Previous_mp3_playback_hisr_complete)
    {
        Previous_mp3_playback_hisr_complete  = FALSE;
        AudMP3SM(E_mp3_interrupt_handle, NULL);
        Previous_mp3_playback_hisr_complete  = TRUE;
    }
    else
    {
        AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed")
    }
#endif

    if(TRUE == Previous_vm_cmd_hisr_complete)
    {
        Previous_vm_cmd_hisr_complete = FALSE;
#if defined (VMS_PRESENT)
        AudVmsRecInterruptHandle();
        AudVmsPlaybackInterruptHandle();
#endif
#if defined (PCM_PLAYER)
        AudPcmRecordInterruptHandle();
#endif
        Previous_vm_cmd_hisr_complete = TRUE;
    }
    else
    {
        AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed")
    }
}

/*------------------------------------------------------------------------------
* Function...: AUD_TEAK_INT4_int_handler
* Return.....: -
* Description: Enables the interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_TEAK_INT4_int_handler(
    int vector) /* not used */
{
    zDrv_MidiActive();
    SCU_DSPSRC4 |= CLEAR_INT;
}
/*------------------------------------------------------------------------------
* Function...: AUD_teak_int4_handle_int
* Return.....: -
* Description: Interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_teak_int4_handle_int()
{
#if defined (INTERNAL_POLYRINGER)
    static U8 Previous_midi_player_hisr_complete = TRUE; 
    if(TRUE == Previous_midi_player_hisr_complete)
    {
        Previous_midi_player_hisr_complete = FALSE;
        AUD_HandleMidiPlayerTimeout();
        Previous_midi_player_hisr_complete = TRUE;
    }
    else
    {
        AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous midi player HISR has not yet completed")
    }
#endif
}

/*------------------------------------------------------------------------------
* Function...: AUD_TEAK_INT5_int_handler
* Return.....: -
* Description: Enables the interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_TEAK_INT5_int_handler(
    int vector) /* not used */
{
    //NU_Activate_HISR(&AUD_TEAK_INT5_HISR_control);
    SCU_DSPSRC5 |= CLEAR_INT;
}
/*------------------------------------------------------------------------------
* Function...: AUD_teak_int5_handle_int
* Return.....: -
* Description: Interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_teak_int5_handle_int()
{
#if defined (PCM_PLAYER)
    static U8 Previous_pcm_playback_hisr_complete = TRUE; 
    if(TRUE == Previous_pcm_playback_hisr_complete)
    {
        Previous_pcm_playback_hisr_complete = FALSE;
        AudPcmPlaybackInterruptHandle();
        Previous_pcm_playback_hisr_complete = TRUE;
    }
    else
    {
        AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed")
    }    
#endif 
}

/*------------------------------------------------------------------------------
* Function...: AUD_TEAK_INT6_int_handler
* Return.....: -
* Description: Enables the interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_TEAK_INT6_int_handler(
    int vector) /* not used */
{
    //NU_Activate_HISR(&AUD_TEAK_INT6_HISR_control);
    SCU_DSPSRC6 |= CLEAR_INT;
}
/*------------------------------------------------------------------------------
* Function...: AUD_teak_int6_handle_int
* Return.....: -
* Description: Interrupt handling routine.
* Modified...: xx.xx.xxxx by NN
------------------------------------------------------------------------------*/
void AUD_teak_int6_handle_int(void)
{
#if 0
#if defined (PCM_PLAYER)
   static U8 Previous_pcm_stereo_record_complete = TRUE;
#endif /* PCM_PLAYER */
#if defined (SBC_ENCODER)
    static U8 Previous_sbc_encoder_hisr_complete = TRUE;
    if(SM_CF & 0x2000)
    { /* Check communication flag 13 */
        if(TRUE == Previous_sbc_encoder_hisr_complete)
        {
            Previous_sbc_encoder_hisr_complete = FALSE;
            AudSBCEncoderInterruptHandle(); /* Call SBC encoder interrupt handler */
            Previous_sbc_encoder_hisr_complete = TRUE;
        }
        else
        {
            AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed")
        }
    }
#endif /* SBC_ENCODER */
#if defined (PCM_PLAYER)
    /* PCM STEREO RECORDING */
    if(SM_CF & 0x1000)
    { /* Check communication flag 12 */
        if(TRUE == Previous_pcm_stereo_record_complete)
        {
            Previous_pcm_stereo_record_complete = FALSE;
            AudPcmRecordInterruptHandle(); /* Call PCM stereo record interrupt handler */
            Previous_pcm_stereo_record_complete = TRUE;
        }
        else
        {
            AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed")
        }
    }
#endif
#endif
}

/*------------------------------------------------------------------------------
* Function...: AUD_TEAK_INT7_int_handler
* Return.....: -
* Description: Enables the interrupt handling routine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void AUD_TEAK_INT7_int_handler(
    int vector) /* not used */
{
    //NU_Activate_HISR(&AUD_TEAK_INT7_HISR_control);
    SCU_DSPSRC7 |= CLEAR_INT;
}
/*------------------------------------------------------------------------------
* Function...: AUD_teak_int7_handle_int
* Return.....: -
* Description: Interrupt handling routine.
* Modified...: 01.10.2007 by KBJ (added I2S2 interrupt handler)
------------------------------------------------------------------------------*/
void AUD_teak_int7_handle_int(void)
{
#if defined (STEON2_PROJECT)
    /* this interrupt is used for I2S2 true slave support */
    /* in this case is only I2S2 handled */
    static UINT8 Previous_I2S2_complete = TRUE;
    if(Previous_I2S2_complete == TRUE)
    {
        Previous_I2S2_complete = FALSE;
        AudI2S2InterruptHandle(); /* Call I2S2 interrupt handler */
        Previous_I2S2_complete = TRUE;
    }
    else
    {
        AUD_ERROR_REPORTING(aud_error_grade1, TRAP_AUD_ERROR, "Previous HISR has not yet completed");
    }
#endif /* STEON2_PROJECT */
}

/*------------------------------------------------------------------------------
* Function...: aud_init_audio_irq
* Return.....: -
* Description: Initialises the interrupt handling routines by associating
*              interrupt addresses (e.g. DSP_INT2) with functions (e.g.
*              AUD_POAK_INT2_int_handler).
* Modified...: 24.04.2007 by KBJ (added safe initialisation)
------------------------------------------------------------------------------*/
void aud_init_audio_irq(void)
{
    static BOOL initialised = FALSE;
    if(FALSE == initialised)
    {
        VOID (*old_lisr)(INT);
		
//        NU_Register_LISR(DSP_INT2, AUD_POAK_INT2_int_handler, &old_lisr);
//        SCU_DSPSRC2 |= ENABLE_INT;  /* enable use of DSP_INT2 */
//        NU_Register_LISR(DSP_INT4, AUD_TEAK_INT4_int_handler, &old_lisr);
//        SCU_DSPSRC4 = 0x5000;       /* enable use of DSP_INT4, Enable interrupt from DSP */
#if 0
        NU_Register_LISR(DSP_INT5, AUD_TEAK_INT5_int_handler, &old_lisr);
        SCU_DSPSRC5 = 0x5000;       /* enable use of DSP_INT5, Enable interrupt from DSP */
        NU_Register_LISR(DSP_INT6, AUD_TEAK_INT6_int_handler, &old_lisr);
        SCU_DSPSRC6 = 0x5000;       /* enable use of DSP_INT6, Enable interrupt from DSP */
        NU_Register_LISR(DSP_INT7, AUD_TEAK_INT7_int_handler, &old_lisr);
        SCU_DSPSRC7 = 0x5000;       /* enable use of DSP_INT7, Enable interrupt from DSP */
#endif
        initialised = TRUE;
/******************* edit by zhouzhongyao for dsp interrupt *************************/
#if 0
        zDrvDsp_IntRegister(2, AUD_POAK_INT2_int_handler, INT_GSM_DSP_INT2_PRI);
        SCU_DSPSRC2 |= ENABLE_INT;  /* enable use of DSP_INT2 */
        zDrvDsp_IntRegister(4, AUD_TEAK_INT4_int_handler, INT_GSM_DSP_INT4_PRI);
        SCU_DSPSRC4 |= ENABLE_INT;      /* enable use of DSP_INT4, Enable interrupt from DSP */
#endif	
        //zDrv_InstallIsr(96, AUD_POAK_INT2_int_handler, "poak_int2");
        zDrvInt_InstallIsr(29, AUD_POAK_INT2_int_handler, "poak_int2", INT_HIGHLEVEL);
        SCU_DSPSRC2 |= ENABLE_INT;  /* enable use of DSP_INT2 */
        //zDrv_InstallIsr(98, AUD_TEAK_INT4_int_handler, "teak_int4");
        zDrvInt_InstallIsr(31, AUD_TEAK_INT4_int_handler, "teak_int4", INT_HIGHLEVEL);
        SCU_DSPSRC4 |= ENABLE_INT;      /* enable use of DSP_INT4, Enable interrupt from DSP */
/*******************           edit                             end        *************************/		

    }
}
#endif /* MP3_PRESENT or INTERNAL_POLYRINGER or PCM_PLAYER or VMS_PRESENT */


