#inherit externalsrc package

DESCRIPTION = "apn database"
LICENSE = "MediaTekProprietary"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS = "libxml2 libbinder"

BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST}"
WORKONSRC = "${TOPDIR}/../src/lynq/lib/apn"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://apn \
          "

SRC-DIR = "${S}/../apn"

#inherit deploy workonsrc

EXTRA_OEMAKE = "'CROSS=${TARGET_PREFIX}'\
                'PROJECT=${PROJ}'\
                'ROOT=${STAGING_DIR_HOST}'\
                'BB_APN_OPTION=true'\
                'LDFLAGS=${BB_LDFLAGS_ADD}'"

FILES_${PN} = "${base_libdir}/*.so \
               ${base_bindir}\
               ${base_sbindir}\
               /system/etc/tele"

FILES_${PN}-dev = "${includedir}/"

FILES_${PN}-staticdev = "${base_libdir}/*.a"

FILES_${PN}-doc = "/doc"

do_compile () {
    if [ "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" ]; then
        oe_runmake all -C ${SRC-DIR} BB_CFLAGS_ADD="--sysroot=${STAGING_DIR_HOST} -mhard-float" LDFLAGS="${LDFLAGS}" ROOT=${STAGING_DIR_HOST} OFLAGS="${BB_INCLUDE_ADD}" SYS_CFLAGS="${BB_INCLUDE_ADD}"
    else
        oe_runmake all -C ${SRC-DIR} BB_CFLAGS_ADD="--sysroot=${STAGING_DIR_HOST} -mhard-float" CXX="${CXX} ${CXXFLAGS}" LDFLAGS="${LDFLAGS}" ROOT=${STAGING_DIR_HOST} OFLAGS="${BB_INCLUDE_ADD}" SYS_CFLAGS="${BB_INCLUDE_ADD}"
    fi
}

do_install() {
    install -d ${D}${includedir}
    install ${WORKONSRC}/inc/apn_interface.h ${D}${includedir}
    oe_runmake install -C ${SRC-DIR} ROOT=${D} PACKAGE_ARCH=${PACKAGE_ARCH}
    install -d ${D}/system/etc/tele/
    install -m 0644 ${SRC-DIR}/resource/apns-conf.xml ${D}/system/etc/tele/
    install -m 0644 ${SRC-DIR}/resource/apns-full-conf.xml ${D}/system/etc/tele/
    install -m 0644 ${SRC-DIR}/resource/apns-conf-pct*.xml ${D}/system/etc/tele/
}
