#inherit externalsrc package

DESCRIPTION = "liblynq-qser-gnss"
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = "file://LICENSE;md5=3f86c7f456a6d0bbeca155e65084eee1"
DEPENDS += "liblynq-log libxml2 liblynq-uci libsctel libbsp"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/liblynq-qser-gnss/"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://liblynq-qser-gnss\
          "

SRC-DIR = "${S}/../liblynq-qser-gnss"

TARGET_CC_ARCH += "${LDFLAGS}"
BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

FILES_${PN} += "${bindir} /data/gnss_update"

EXTRA_OEMAKE = "'TARGET_PLATFORM = ${TARGET_PLATFORM}'"

FILES_${PN} += "${base_libdir}/*.so "

FILES_${PN}-dev = "/test \
                   ${includedir}"

FILES_${PN}-doc = "/doc"

FILES_${PN}-dbg ="${base_bindir}/.debug \
                  ${base_libdir}/.debug \
                  ${base_sbindir}/.debug"

INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"


#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {
        oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -Os -Wl,--hash-style=gnu -DTELEPHONYWARE"
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}

    if [ -d "${WORKONSRC}" ] ; then
        install -d ${D}${includedir}/
        cp -raf ${SRC-DIR}/include/ ${D}${includedir}/
        install -d ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}UC6228CI-R3.2.10.100Build8019_mfg.pkg ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}bootloader_r3.0.0_build6773_uartboot_921600.pkg ${D}/data/gnss_update
        install -m 644 ${WORKONSRC}agps.conf ${D}/data/gnss_update
        ln -sf ./UC6228CI-R3.2.10.100Build8019_mfg.pkg ${D}/data/gnss_update/firmware.pkg
        ln -sf ./bootloader_r3.0.0_build6773_uartboot_921600.pkg ${D}/data/gnss_update/bootloader.pkg
    fi 
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}
