#Basic Configuration
DESCRIPTION = "LIBPAL"
SECTION = "base"
LICENSE = "MediaTekProprietary"
LIC_FILES_CHKSUM = "file://../libpal/LICENSE;md5=e1696b147d49d491bcb4da1a57173fff"
DEPENDS += "libbinder"
#inherit workonsrc
WORKONSRC = "${TOPDIR}/../src/lynq/lib/libpal/"
FILESEXTRAPATHS_prepend :="${TOPDIR}/../src/lynq/lib/:"
SRC_URI = " \
          file://libpal \
          "

SRC-DIR = "${S}/../libpal"

BB_INCLUDE_ADD = "--sysroot=${STAGING_DIR_HOST}"
BB_LDFLAGS_ADD = "--sysroot=${STAGING_DIR_HOST} -Wl,--hash-style=gnu"

inherit deploy

#Parameters passed to do_compile()
EXTRA_OEMAKE = "'CROSS=${TARGET_PREFIX}'\
                'PROJECT=${PROJ}'\
				'PREFIX=${BACH_PREFIX}'\
				'PACKAGE_ARCH=${PACKAGE_ARCH}'\
                'BB_INCLUDE_ADD=${BB_INCLUDE_ADD}'\
                'BB_LDFLAGS_ADD=${BB_LDFLAGS_ADD}'"

FILES_${PN} = "${base_libdir}/*.so\
               ${base_bindir} \
               /mnt\
               /tmp\
               /etc\
               /test"

FILES_${PN}-dev = "${includedir}"

FILES_${PN}-staticdev = "${base_libdir}/*.a"

FILES_${PN}-dbg = "/usr/src/debug \
				   ${base_libdir}/.debug \
				   ${base_bindir}"

#Skip strip check in QA test.
INSANE_SKIP_${PN} += "already-stripped"
INSANE_SKIP_${PN} += "installed-vs-shipped"

TARGET_CC_ARCH += "${LDFLAGS}"

do_compile () {
    unset LDFLAGS
    oe_runmake all -C ${SRC-DIR} ROOT=${STAGING_DIR_HOST}
}

do_install () {
    oe_runmake install -C ${SRC-DIR} ROOT=${D}
	
    install -d ${D}${includedir}/pal
    cp -af ${SRC-DIR}/include/* ${D}${includedir}/pal
}

addtask bachclean
do_bachclean () {
    oe_runmake clean
}

