#inherit externalsrc package systemd

DESCRIPTION = "lynq-fota-backup.service"

LICENSE = "MIT"
##License checksum file is always required
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=c794e8ff1acd3b7f156a6497e780dd54"

SRC_URI = "file://lynq-fota-backup.cpp \
	   file://lynq-fota-backup.sh \
	   file://makefile \
	   file://lynq-fota-backup.service \
	   file://LICENSE \
"


TARGET_CC_ARCH += "${LDFLAGS}"


DEPENDS += "liblynq-log liblynq-uci liblynq-qser-fota"
S = "${WORKDIR}"
#INHIBIT_PACKAGE_STRIP = "1"
do_compile () {

	
	if test "${PACKAGE_ARCH}" = "cortexa7hf-vfp-vfpv4-neon" || test "${PACKAGE_ARCH}" = "cortexa7hf-neon-vfpv4"; then
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST} -mhard-float"
	else
		oe_runmake all ROOT=${STAGING_DIR_HOST} OFLAGS="--sysroot=${STAGING_DIR_HOST}"
	fi
}
#INHIBIT_PACKAGE_STRIP = "1"


do_install() {
	install -d ${D}${bindir}/
	echo "Installing image PN ${PN}"
	echo "Installing image systemd_unitdir ${systemd_unitdir}"
	echo "Installing image D ${D}"
	echo "Installing image B ${B}"

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system/
		install -m 0644 ${B}/lynq-fota-backup.service ${D}${systemd_unitdir}/system
    else
		install -d ${D}${sysconfdir}/init.d
        	install -m 0755  ${S}/lynq-fota-backup.sh ${D}${sysconfdir}/init.d/
        	install -d ${D}${sysconfdir}/rcS.d
        	ln -s ../init.d/lynq-fota-backup.sh ${D}${sysconfdir}/rcS.d/S82lynq-fota-backup-service
	fi

	install -m 0755 ${S}/lynq-fota-backup ${D}${bindir}/
	install -d ${D}${includedir}
}
