DESCRIPTION = "at_ctl"
DEPENDS     = "libnvram libsoftap libsofttimer libatutils sqlcipher libatext libmxml libtelsvr libsd-daemon"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}


DEPENDS += " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'volte', 'libvoice', '', d)} \
    "

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
          file://at_ctl \
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://at_ctl.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://at_ctl.service","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://at_ctl.sysvinit","", d)} \
		  file://preconfigured_urs_policy.xml \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/at_ctl"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc
CFLAGS_append = "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app_open/platform/at_ctl/src/phone/inc"
CFLAGS_append += "${ZXIC_EXTRA_CFLAGS}"
LDLIBS_EXT = "${@bb.utils.contains('DISTRO_FEATURES', 'volte', '-lvoice', '', d)}"
#include at-ctl.inc

#inherit autotools pkgconfig systemd

do_compile() {
	make -C ${S_SRC_PATH} LDLIBS_EXT=${LDLIBS_EXT}
}

do_install () {
	install -d ${D}${bindir}/		
	install -m 0755 ${S_SRC_PATH}/at_ctl ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/at_ctl.init ${D}${sysconfdir}/init.d/at_ctl
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/at_ctl.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/at_ctl.sysvinit ${D}${sysconfdir}/init.d/at_ctl
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/at_ctl ${D}${sysconfdir}/rcS.d/S20at_ctl
		ln -s ../init.d/at_ctl ${D}${sysconfdir}/rcS.d/K80at_ctl
	fi
	
	install -d ${D}/etc_ro/config/
	install -m 0644 ${WORKDIR}/preconfigured_urs_policy.xml ${D}/etc_ro/config/

	#install elfs
	install -d ${ELFS-PATH}/
	#install -m 0755 ${S_SRC_PATH}/at_ctl ${ELFS-PATH}/${PN}/
	install -m 0755 ${S_SRC_PATH}/at_ctl ${ELFS-PATH}/
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/at_ctl
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/at_ctl","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    etc_ro/ \
    "
SYSTEMD_SERVICE_${PN}     = "at_ctl.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libnvram libsoftap libsofttimer libatutils sqlcipher libatext libmxml libvoice libsd-daemon"
