SUMMARY = "zxic Linux kernel"
SECTION = "kernel"
PV      = "${LINUX_VERSION}"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM ?= "file://COPYING;md5=6bc538ed5bd9a7fc9398086aedcd7e46"
LINUX_VERSION    ?= "5.10.156"

#pub include
include ${BSPDIR}/sources/meta-zxic/conf/pub.inc

DEPENDS += "kern-tools-native"
DEPENDS += "${@bb.utils.contains('DISTRO_FEATURES','dm-verity','zstd-native','',d)}"
inherit kernel  siteinfo  

EXTRA_OEMAKE_append = " LOADADDR=${KERNEL_LOADADDR} EXTRA_CFLAGS='${ZXIC_EXTRA_CFLAGS}' "
FILESEXTRAPATHS_prepend :="${SRC-PATH}:"
# PR_CONFIG_cpe = "linux-5_10-cpe-${BOOT_CTL}-defconfig"
# PR_CONFIG_v2x = "linux-5_10-v2x-${BOOT_CTL}-defconfig"
PR_CONFIG_vehicle_dc = "linux-5_10-vehicle_dc-${BOOT_CTL}-defconfig"
PR_CONFIG_vehicle_dc_4Gb = "linux-5_10-vehicle_dc_4Gb-${BOOT_CTL}-defconfig"
S = "${WORKDIR}/linux-5.10"

do_install[nostamp] = "1"

SRC_URI = "\
    file://linux-5.10    \
    file://${MACHINE}/${LINUX_BASE_CONFIG} \
    "

# returns all the elements from the src uri that are .cfg files
def find_cfgs(d):
    sources=src_patches(d, True)
    sources_list=[]
    for s in sources:
        if s.endswith('.cfg'):
            sources_list.append(s)

    return sources_list

kernel_do_configure() {
	# fixes extra + in /lib/modules/2.6.37+
	# $ scripts/setlocalversion . => +
	# $ make kernelversion => 2.6.37
	# $ make kernelrelease => 2.6.37+
	touch ${B}/.scmversion ${S}/.scmversion
	
	cp ${WORKDIR}/${MACHINE}/${LINUX_BASE_CONFIG}  ${WORKDIR}/defconfig 
	if [ "${S}" != "${B}" ] && [ -f "${S}/.config" ] && [ ! -f "${B}/.config" ]; then
		mv "${S}/.config" "${B}/.config"
	fi

	# Copy defconfig to .config if .config does not exist. This allows
	# recipes to manage the .config themselves in do_configure_prepend().
	if [ -f "${WORKDIR}/defconfig" ] && [ ! -f "${B}/.config" ]; then
		cp "${WORKDIR}/defconfig" "${B}/.config"
	fi
	
	merge_config.sh -m  ${WORKDIR}/defconfig ${@" ".join(find_cfgs(d))}
	${KERNEL_CONFIG_COMMAND}
}

fakeroot do_cpio () {
	if ${@bb.utils.contains('DISTRO_FEATURES','dm-verity','true','false',d)}; then
		cp  -v  ${BSPDIR}/sources/meta-zxic-custom/conf/distro/dm-verity/${KERNEL_INITRAMFS_CPIO}   ${B}/
	fi
}

do_install_append () {
	#install elfs
	install -d ${ELFS-PATH}/
	install -d ${BINS-PATH}/
	install -m 0755 ${WORKDIR}/image/boot/uImage ${ELFS-PATH}/uImage
	install -m 0755 ${WORKDIR}/image/boot/${MACHINE}-${DISTRO}.dtb  ${BINS-PATH}/ap_cpucap.dtb
	install -m 0755 ${WORKDIR}/image/boot/${MACHINE}-${DISTRO}.dtb  ${ELFS-PATH}/

	install -m 0755 ${B}/vmlinux              ${ELFS-PATH}/vmlinux
	install -m 0755 ${B}/System.map           ${ELFS-PATH}/System.map
	if [ -d ${WORKDIR}/image/lib/modules ]; then
		cp -rf  ${WORKDIR}/image/lib/modules      ${ELFS-PATH}/${PN}/
	fi
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/uImage
	rm -fr ${ELFS-PATH}/${MACHINE}-${DISTRO}.dtb
	rm -fr ${ELFS-PATH}/vmlinux
	rm -fr ${ELFS-PATH}/System.map
	rm -fr ${ELFS-PATH}/${PN}/modules	
}
addtask  cleanlibs after do_clean  before do_cleansstate
addtask  do_cpio   after do_configure before do_compile

COMPATIBLE_MACHINE = "^zxic$"
