#!/bin/sh
### BEGIN INIT INFO
# Provides:          mountvirtfs
# Required-Start:
# Required-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Mount kernel virtual file systems.
# Description:       Mount initial set of virtual filesystems the kernel
#                    provides and that are required by everything.
### END INIT INFO

if [ -e /proc ] && ! [ -e /proc/mounts ]; then
  mount -t proc proc /proc
fi

if [ -e /sys ] && grep -q sysfs /proc/filesystems && ! [ -e /sys/class ]; then
  mount -t sysfs sysfs /sys
fi

if [ -e /sys/kernel/debug ] && grep -q debugfs /proc/filesystems; then
  mount -t debugfs debugfs /sys/kernel/debug
fi

if [ -e /sys/kernel/config ] && grep -q configfs /proc/filesystems; then
  mount -t configfs configfs /sys/kernel/config
fi

if [ -e /sys/firmware/efi/efivars ] && grep -q efivarfs /proc/filesystems; then
  mount -t efivarfs efivarfs /sys/firmware/efi/efivars
fi

if ! [ -e /dev/zero ] && [ -e /dev ] && grep -q devtmpfs /proc/filesystems; then
  mount -n -t devtmpfs devtmpfs /dev
fi

mkdir -p /tmp
mount   -t  tmpfs   tmpfs    /tmp
mkdir -p /run
mount   -t  tmpfs   tmpfs    /run
mkdir -p /dev/pts
mount   -t  devpts  devpts   /dev/pts

mkdir -p /tmp/run

#软锁panic
#echo 1 > /proc/sys/kernel/softlockup_panic
#内存耗尽oom panic
echo 1 > /proc/sys/vm/panic_on_oom
#警告panic
#echo 1 > /proc/sys/kernel/panic_on_warn
#echo 0 > /proc/sys/kernel/hung_task_timeout_secs

echo "mount configfs..."
mount none /sys/kernel/config  -t configfs

