#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "sc_at.h"

#ifdef __cplusplus
extern "C" {
#endif

int check_cmd(char* cmd_str,char* check_str)
{
    int check_size = strlen(check_str);
    for(int i = 0; i < check_size; i++)
    {
        // 输入包含非字母字符
        if (!isalpha(cmd_str[i]))
        {
            return -1;
        }
        // 不匹配
        if (tolower(cmd_str[i]) != check_str[i] && toupper(cmd_str[i]) != check_str[i])
        {
            return -1;
        }
    }
    return 0;
}

int main(int argc, char *argv[])
{
    int ret;
    int i = 0;
    char rsp[256] = {0};
    char at_cmd[64] = {0};
    char* check_str = "AT";
    if(argc < 2)
    {
        printf("wrong input\r\n");
        return -1;
    }
    ret = check_cmd(argv[1],check_str);
    if(ret)
    {
        printf("wrong input\r\n");
        return -1;
    }
    sprintf(at_cmd,"%s\n",argv[1]);
    ret = sc_at_send(1,at_cmd,rsp,sizeof(rsp));
    if(ret)
    {
        printf("at_send failed.the reason is: %s\r\n",rsp);
    }
    else
    {
        printf("AT RSP:%s\r\n",rsp);
    }
    return 0;
}

#ifdef __cplusplus
}
#endif