#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <include/lynq-gpio.h>


int main(int argc,char** argv)
{
    int ret;
    int gpio;
    int direction;
    int value;
    int pullsel;
    if(argc < 2)
    {
        printf("wrong input format, please -h \n");
        return -1;
    }

    if(strcmp(argv[1],"-h") == 0)
    {
        printf("        -h                                        --help\n");;
        printf("        -ds  [gpio][direction]                    --lynq_gpio_direction_set\n");
        printf("        -vs  [gpio][value]                        --lynq_gpio_value_set\n");
        printf("        -ps  [gpio][pullsel]                      --lynq_gpio_pullsel_set\n");
        printf("        -vg  [gpio]                               --lynq_gpio_value_get\n");
        printf("        -pg  [gpio]                               --lynq_gpio_pullsel_get\n");
        return 0;
    }

    gpio = atoi(argv[2]);
    ret = lynq_gpio_init(gpio, 0, 0, 0);
    if(ret != 0)
    {
        printf("lynq_gpio_init fail\n");
    }
    else
    {
        printf("lynq_gpio_init success\n");
    }

    if(strcmp(argv[1],"-ds") == 0)
    {
        if(argc < 3)
        {
            printf("wrong input format, please -h \n");
            return -1;
        }
        direction = atoi(argv[3]);
        ret = lynq_gpio_direction_set(gpio, direction);
        if(ret != 0)
        {
            printf("lynq_gpio_direction_set fail\n");
        }
        else
        {
            printf("lynq_gpio_direction_set success\n");
        }

    }
    else if(strcmp(argv[1],"-vs") == 0)
    {
        if(argc < 3)
        {
            printf("wrong input format, please -h \n");
            return -1;
        }
        value = atoi(argv[3]);
        ret = lynq_gpio_value_set(gpio, value);
        if(ret < 0)
        {
            printf("lynq_gpio_value_set fail\n");
        }
        else
        {
            printf("lynq_gpio_value_set success\n");
        }
    }
    else if (strcmp(argv[1],"-ps") == 0)
    {
        if(argc < 3)
        {
            printf("wrong input format, please -h \n");
            return -1;
        }
        pullsel = atoi(argv[3]);
        ret = lynq_gpio_pullsel_set(gpio, pullsel);
        if(ret != 0)
        {
            printf("lynq_gpio_pullsel_set fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("lynq_gpio_pullsel_set success\n");
        }
    }

    else if (strcmp(argv[1],"-vg") == 0)
    {
        ret = lynq_gpio_value_get(gpio);
        if(ret < 0)
        {
            printf("lynq_gpio_value_get fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("lynq_gpio_value_get success\n");
            printf("ret=%d\n", ret);
        }
    }
    else if(strcmp(argv[1],"-pg") == 0)
    {
        ret = lynq_gpio_pullsel_get(gpio);
        if(ret < 0)
        {
            printf("lynq_gpio_pullsel_get fail\n");
            printf("ret=%d\n", ret);
        }
        else
        {
            printf("lynq_gpio_pullsel_get success\n");
            printf("ret=%d\n", ret);
        }
    }
    else
    {
        printf("wrong input format, please -h \n");
        return -1;
    }

    ret = lynq_gpio_deinit(gpio);
    if(ret != 0)
    {
        printf("lynq_gpio_deinit fail\n");
        printf("ret=%d\n", ret);
    }
    else
    {
        printf("lynq_gpio_deinit success\n");
    }

    return 0;

}
