#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <dlfcn.h>
#include <stdint.h>

int (*lynq_get_upgrade_status)(void);
int (*lynq_fota_set_addr_value)(char *value,int size);
int (*lynq_fota_nrestart)(void);
int (*lynq_rock_main)(int first_run);

void *dlHandle_fota = NULL;

int main(int argc,char *argv[])
{
    int ret = 0;
    int reboot_flag; 
    char *value = argv[1];
    printf("Enter main function\n");
    
    const char *lynqLibPath_fota = "/lib/liblynq-fota.so";
    dlHandle_fota = dlopen(lynqLibPath_fota, RTLD_NOW);
    if (dlHandle_fota == NULL) 
    {
        printf("dlopen dlHandle_fota failed: %s\n", dlerror());
        return -1;
    }

    lynq_fota_set_addr_value = (int (*)(char *value,int size))dlsym(dlHandle_fota, "lynq_fota_set_addr_value");
    if(lynq_fota_set_addr_value == NULL)
    {
        printf("lynq fota ser addr value is null\n");
        return -1;
    }

    lynq_get_upgrade_status = (int (*)(void))dlsym(dlHandle_fota,"lynq_get_upgrade_status");
    if(lynq_get_upgrade_status == NULL)
    {
        printf("lynq_get_upgrade_status is null\n");
        return -1;
    }
    lynq_fota_nrestart = (int (*)())dlsym(dlHandle_fota,"lynq_fota_nrestart");
    if(lynq_fota_nrestart == NULL)
    {
        printf("lynq_fota_nrestart is null\n");
        return -1;
    }
    lynq_rock_main = (int (*)(int first_run))dlsym(dlHandle_fota,"lynq_rock_main");
    if(lynq_rock_main == NULL)
    {
        printf("lynq_rock_main is null\n");
        return -1;
    }
    
    ret = lynq_fota_set_addr_value(value,(int )strlen(value));
    if(ret != 0)
    {
        printf("set upgrade package addr failed\n");
        return -1;
    }

    printf("Please chose  reboot or not when upgrade done  1: reboot 0: not reboot\n");
    scanf("%d",&reboot_flag);

    switch(reboot_flag)
    {
        case 0:
            printf("Not reboot when upgrade done!!!\n ");
            ret = lynq_fota_nrestart();
            printf("upgrade result is %d\n",ret);
            ret = lynq_get_upgrade_status();
            printf("get upgrade status result is %d\n",ret);
            break;

        case 1:
            printf("Will reboot when upgrade done!!!\n ");
            ret = lynq_rock_main(1);
            printf("upgrade result is %d\n",ret);
            ret = lynq_get_upgrade_status();
            printf("get upgrade status result is %d\n",ret);
            break;

        default:
            printf("please input right flag 1 or 0\n");
            break;

    }
    
    return 0;

}

