DESCRIPTION = "libsctel"
DEPENDS     = "libscipc libsofttimer libsoftap libatutils libnvram libatreg libgcc"
SECTION     = "lib"
LICENSE     = "zte"
PV          = "1.0.0"
PR          = "r0"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk:"
SRC_URI = " \
          file://libsctel \
          "

S       = "${WORKDIR}"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
CFLAGS_append = "-I ${BSPDIR}/zxic_code/zxic_source/zxic_app_open/platform/at_ctl/inc"

do_compile () {
	make -C libsctel
}

do_install () {
	install -d ${D}${libdir}/
	install -d ${D}/usr/include
	
	install -m 0755 ${S}/libsctel/libsctel.so  ${D}${libdir}/
	install -m 0755 ${S}/libsctel/libsctel.a   ${D}${libdir}/
	
	install -m 0644 ${S}/libsctel/include/*.h ${D}/usr/include/

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/libsctel/libsctel.so ${ELFS-PATH}/
}

#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/libsctel.so
}

FILES_${PN}       += "${libdir}/*.so"
FILES_${PN}-dbg   += "${libdir}/.debug"
FILES_SOLIBSDEV   = ""
INSANE_SKIP_${PN} = "dev-so"
RDEPENDS_${PN} = " libscipc libsofttimer libsoftap libatutils libnvram libatreg libgcc"
