DESCRIPTION = "mnet_whitelist"
DEPENDS = "libsctel libsoftap libatutils libsofttimer libnvram libscipc"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}:"
SRC_URI = " \
          file://test/mnet_whitelist \		  
		  ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://mnet_whitelist.init","", d)} \
		  ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://mnet_whitelist.service","", d)} \
          "
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"
S_SRC_PATH = "${S}/test/mnet_whitelist"
#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc
#include +=
#inherit autotools pkgconfig systemd

do_compile() {
	make -C ${S_SRC_PATH}
}

do_install () {
	install -d ${D}${bindir}/
	install -m 0755 ${S_SRC_PATH}/mnet_whitelist ${D}${bindir}/
	
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/mnet_whitelist.init ${D}${sysconfdir}/init.d/mnet_whitelist
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/mnet_whitelist.service ${D}${systemd_unitdir}/system
	fi
	
	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S_SRC_PATH}/mnet_whitelist ${ELFS-PATH}/	
}

do_cleanlibs () {
	rm -fr ${ELFS-PATH}/mnet_whitelist
}

addtask  cleanlibs after do_clean  before do_cleansstate

FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/mnet_whitelist","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "mnet_whitelist.service"
SYSTEMD_AUTO_ENABLE_${PN} = "disable"

RDEPENDS_${PN} = "libsctel libsoftap libatutils libsofttimer libnvram libscipc"
