DESCRIPTION = "rild"
DEPENDS     = "libbinder libril"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/sdk:"
SRC_URI = " \
    file://rild \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://rild.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://rild.service","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://rild.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C rild
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/rild/rild ${D}${bindir}/
	install -m 0755 ${S}/rild/radiooptions ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/rild.init ${D}${sysconfdir}/init.d/rild
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/rild.service ${D}${systemd_unitdir}/system
	fi
	
	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/rild.sysvinit ${D}${sysconfdir}/init.d/rild
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/rild ${D}${sysconfdir}/rcS.d
		##/S22rild
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/rild/rild ${ELFS-PATH}/
	install -m 0755 ${S}/rild/radiooptions ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/rild
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/init.d/rild","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "rild.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = "libbinder libril"
