DESCRIPTION = "wlan_proxy"
DEPENDS     = "libsoftap libsofttimer libnvram libatutils libscipc libsctel"
SECTION     = "app"
LICENSE     = "zte"
PV = "1.0.0"
PR = "r0"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
inherit ${CLASS_COM}

#配置code路径信息。
FILESEXTRAPATHS_prepend :="${APP-OPEN-PATH}/platform:"
SRC_URI = " \
    file://wlan_proxy \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://wlan_proxy.init","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://wlan_proxy.service","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "file://wlan_proxy.sysvinit","", d)} \
    "

LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/zte;md5=c075689d1d1e06d4ab5bbe53623a6808"
S = "${WORKDIR}"

#引用公用头文件和编译选项。
include ${BSPDIR}/sources/meta-zxic/conf/app_com.inc

#编译
do_compile() {
	make -C wlan_proxy
}

#库文件的安装
do_install() {
	install -d ${D}${bindir}/
	install -m 0755 ${S}/wlan_proxy/wlan_proxy ${D}${bindir}/

	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/wlan_proxy.init ${D}${sysconfdir}/init.d/wlan_proxy
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
		install -d ${D}${systemd_unitdir}/system
		install -m 0644 ${WORKDIR}/wlan_proxy.service ${D}${systemd_unitdir}/system
	fi

	if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/wlan_proxy.sysvinit ${D}${sysconfdir}/init.d/wlan_proxy
		install -d ${D}${sysconfdir}/rcS.d
		ln -s ../init.d/wlan_proxy ${D}${sysconfdir}/rcS.d/S21wlan_proxy
	fi

	#install elfs
	install -d ${ELFS-PATH}/
	install -m 0755 ${S}/wlan_proxy/wlan_proxy ${ELFS-PATH}/
}
#清库
do_cleanlibs () {
	rm -fr ${ELFS-PATH}/wlan_proxy
}

addtask  cleanlibs after do_clean  before do_cleansstate

#rootfs包含的文件
FILES_${PN} = "\
    ${bindir}/ \
    ${@bb.utils.contains("DISTRO_FEATURES", "procd", "${sysconfdir}/","", d)} \
    ${@bb.utils.contains("DISTRO_FEATURES", "sysvinit", "${sysconfdir}/","", d)} \
    "
SYSTEMD_SERVICE_${PN}     = "wlan_proxy.service"
SYSTEMD_AUTO_ENABLE_${PN} = "enable"

RDEPENDS_${PN} = " libsoftap libsofttimer libnvram libatutils libscipc libsctel"