FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

CLASS_COM = " \
    ${@bb.utils.contains('DISTRO_FEATURES', 'procd', 'openwrt openwrt-services', '', d)} \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', 'systemd', '', d)} \
"
SRC_URI += "\
    file://miniupnpd.init.d.script \
	file://0002-upnp-fix.patch \
	${@bb.utils.contains("DISTRO_FEATURES", "procd", "file://miniupnpd.init","", d)} \
	${@bb.utils.contains("DISTRO_FEATURES", "systemd", "file://miniupnpd.service","", d)} \
"
EXTRA_OEMAKE_append = "CONFIG_OPTIONS="""
do_compile() {
    cd ${S}
    CONFIG_OPTIONS="" oe_runmake -f Makefile.linux config.h
    CONFIG_OPTIONS="" oe_runmake -f Makefile.linux
}

do_install() {
    install -d ${D}/${sbindir}
    install ${S}/miniupnpd ${D}/${sbindir}
    install -d ${D}/${sysconfdir}/${BPN}
    install ${S}/netfilter/iptables_init.sh ${D}/${sysconfdir}/${BPN}
    install ${S}/netfilter/iptables_removeall.sh ${D}/${sysconfdir}/${BPN}
    install ${S}/netfilter/ip6tables_init.sh ${D}/${sysconfdir}/${BPN}
    install ${S}/netfilter/miniupnpd_functions.sh ${D}/${sysconfdir}/${BPN}
    install ${S}/netfilter/ip6tables_removeall.sh ${D}/${sysconfdir}/${BPN}
    install -m 0644 -b ${S}/miniupnpd.conf ${D}/${sysconfdir}/${BPN}
    install -d ${D}/${sysconfdir}/init.d
    #install ${S}/linux/miniupnpd.init.d.script ${D}/${sysconfdir}/init.d/miniupnpd
	#if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
	install ${WORKDIR}/miniupnpd.init.d.script ${D}/${sysconfdir}/init.d/miniupnpd
	#fi
	if ${@bb.utils.contains('DISTRO_FEATURES','systemd','true','false',d)}; then
    install -d ${D}${systemd_unitdir}/system
    install -m 0644 ${WORKDIR}/miniupnpd.service ${D}${systemd_unitdir}/system/
	fi
	if ${@bb.utils.contains('DISTRO_FEATURES','procd','true','false',d)}; then
		install -Dm 0755 ${WORKDIR}/miniupnpd.init ${D}${sysconfdir}/init.d/miniupnpd
	fi
}