/*****************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name:PubNvParam_AMT.h
 * File Mark:
 * Description:public config NV parameters
 *  Date:      2013-08-21
 *  Author:    hupo
  ****************************************************************************/
#ifndef _RONVPARAM_AMT_H
#define	_RONVPARAM_AMT_H

#include "RONvConfig.h"

// AMT COMM ITEM
#define OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS                OS_FLASH_AMT_COMM_RO_NONFAC_BASE_ADDR
#define OS_FLASH_AMT_COMM_RO_IMEI_SIZE                   8

#define OS_FLASH_AMT_COMM_RO_IMEI_Reserved_ADDRESS       OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS + OS_FLASH_AMT_COMM_RO_IMEI_SIZE
#define OS_FLASH_AMT_COMM_RO_IMEI_Reserved_SIZE          12

#define OS_FLASH_AMT_COMM_RO_IMEISV_ADDRESS              OS_FLASH_AMT_COMM_RO_IMEI_Reserved_ADDRESS + OS_FLASH_AMT_COMM_RO_IMEI_Reserved_SIZE
#define OS_FLASH_AMT_COMM_RO_IMEISV_SIZE                 8

#define OS_FLASH_AMT_COMM_RO_IMEISV_Reserved_ADDRESS     OS_FLASH_AMT_COMM_RO_IMEISV_ADDRESS + OS_FLASH_AMT_COMM_RO_IMEISV_SIZE
#define OS_FLASH_AMT_COMM_RO_IMEISV_Reserved_SIZE        12

#define OS_FLASH_AMT_COMM_RO_BOARDNNUM_ADDRESS           OS_FLASH_AMT_COMM_RO_IMEISV_Reserved_ADDRESS + OS_FLASH_AMT_COMM_RO_IMEISV_Reserved_SIZE
#define OS_FLASH_AMT_COMM_RO_BOARDNNUM_SIZE              20

#define OS_FLASH_AMT_COMM_RO_MSerialNum_ADDRESS          OS_FLASH_AMT_COMM_RO_BOARDNNUM_ADDRESS + OS_FLASH_AMT_COMM_RO_BOARDNNUM_SIZE
#define OS_FLASH_AMT_COMM_RO_MSerialNum_SIZE             20

#define OS_FLASH_AMT_COMM_RO_ValidFlag_ADDRESS           OS_FLASH_AMT_COMM_RO_MSerialNum_ADDRESS + OS_FLASH_AMT_COMM_RO_MSerialNum_SIZE
#define OS_FLASH_AMT_COMM_RO_ValidFlag_SIZE              4

#define OS_FLASH_AMT_COMM_RO_InternalMAC_ADDRESS         OS_FLASH_AMT_COMM_RO_ValidFlag_ADDRESS + OS_FLASH_AMT_COMM_RO_ValidFlag_SIZE
#define OS_FLASH_AMT_COMM_RO_InternalMAC_SIZE            20

#define OS_FLASH_AMT_COMM_RO_ExternalMAC_ADDRESS         OS_FLASH_AMT_COMM_RO_InternalMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_InternalMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_ExternalMAC_SIZE            20

#define OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS             OS_FLASH_AMT_COMM_RO_ExternalMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_ExternalMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE                20

#define OS_FLASH_AMT_COMM_RO_NvVersion_ADDRESS           OS_FLASH_AMT_COMM_RO_WIFIMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_NvVersion_SIZE              40

#define OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS            OS_FLASH_AMT_COMM_RO_NvVersion_ADDRESS + OS_FLASH_AMT_COMM_RO_NvVersion_SIZE
#define OS_FLASH_AMT_COMM_RO_TestInfo_SIZE               200

#define OS_FLASH_AMT_COMM_RO_SOFTVERSION_ADDRESS         OS_FLASH_AMT_COMM_RO_TestInfo_ADDRESS + OS_FLASH_AMT_COMM_RO_TestInfo_SIZE
#define OS_FLASH_AMT_COMM_RO_SOFTVERSION_SIZE            10

#define OS_FLASH_AMT_COMM_RO_V4Key_ADDRESS               OS_FLASH_AMT_COMM_RO_SOFTVERSION_ADDRESS + OS_FLASH_AMT_COMM_RO_SOFTVERSION_SIZE
#define OS_FLASH_AMT_COMM_RO_V4Key_SIZE                  84

#define OS_FLASH_AMT_COMM_RO_V4Key_Reserved_ADDRESS      OS_FLASH_AMT_COMM_RO_V4Key_ADDRESS + OS_FLASH_AMT_COMM_RO_V4Key_SIZE
#define OS_FLASH_AMT_COMM_RO_V4Key_Reserved_SIZE         16

#define OS_FLASH_AMT_COMM_RO_SaleState_ADDRESS           OS_FLASH_AMT_COMM_RO_V4Key_Reserved_ADDRESS + OS_FLASH_AMT_COMM_RO_V4Key_Reserved_SIZE
#define OS_FLASH_AMT_COMM_RO_SaleState_SIZE              2

#define OS_FLASH_AMT_COMM_RO_SaleState_Reserved_ADDRESS  OS_FLASH_AMT_COMM_RO_SaleState_ADDRESS + OS_FLASH_AMT_COMM_RO_SaleState_SIZE
#define OS_FLASH_AMT_COMM_RO_SaleState_Reserved_SIZE     16

#define OS_FLASH_AMT_COMM_RO_BANDBITMAP_ADDRESS          OS_FLASH_AMT_COMM_RO_SaleState_Reserved_ADDRESS + OS_FLASH_AMT_COMM_RO_SaleState_Reserved_SIZE
#define OS_FLASH_AMT_COMM_RO_BANDBITMAP_SIZE             112

#define OS_FLASH_AMT_COMM_RO_BANDBITMAP_Reserved_ADDRESS OS_FLASH_AMT_COMM_RO_BANDBITMAP_ADDRESS + OS_FLASH_AMT_COMM_RO_BANDBITMAP_SIZE
#define OS_FLASH_AMT_COMM_RO_BANDBITMAP_Reserved_SIZE    40

#define OS_FLASH_AMT_COMM_RO_ETHMAC_ADDRESS              OS_FLASH_AMT_COMM_RO_BANDBITMAP_Reserved_ADDRESS + OS_FLASH_AMT_COMM_RO_BANDBITMAP_Reserved_SIZE
#define OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE                 20

#define OS_FLASH_AMT_COMM_RO_LockKey_ADDRESS             OS_FLASH_AMT_COMM_RO_ETHMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_LockKey_SIZE                20

#define OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS            OS_FLASH_AMT_COMM_RO_LockKey_ADDRESS + OS_FLASH_AMT_COMM_RO_LockKey_SIZE
#define OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE               20

#define OS_FLASH_AMT_COMM_RO_USBMAC_ADDRESS              OS_FLASH_AMT_COMM_RO_WIFIMAC2_ADDRESS + OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE
#define OS_FLASH_AMT_COMM_RO_USBMAC_SIZE                 20

#define OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS                OS_FLASH_AMT_COMM_RO_USBMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_USBMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_GMAC_SIZE                   20

#define OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_ADDRESS                OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS + OS_FLASH_AMT_COMM_RO_GMAC_SIZE
#define OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_SIZE                   128

#define OS_FLASH_AMT_COMM_RO_AUTH_KEY_ADDRESS                OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_ADDRESS + OS_FLASH_AMT_COMM_RO_FEATURE_KEY_MD5_SIZE
#define OS_FLASH_AMT_COMM_RO_AUTH_KEY_SIZE                   20

#define OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_ADDRESS                OS_FLASH_AMT_COMM_RO_AUTH_KEY_ADDRESS + OS_FLASH_AMT_COMM_RO_AUTH_KEY_SIZE
#define OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_SIZE                   256



// ݣɵ
#define OS_FLASH_AMT_COMM_RO_GBDATA_ADDRESS              OS_FLASH_AMT_COMM_RO_NONFAC_BASE_ADDR + 0x2800
#define OS_FLASH_AMT_COMM_RO_GBDATA_SIZE                 5120
// ¹滮,οƺⲿͻ1kֽڴ洢
#define OS_FLASH_AMT_COMM_RO_USER_DEFINE_ADDRESS         OS_FLASH_AMT_COMM_RO_NONFAC_BASE_ADDR + 0x7C00
#define OS_FLASH_AMT_COMM_RO_USER_DEFINE_SIZE            0x400

#define OS_FLASH_AMT_COMM_RO_REF_DEFINE_ADDRESS          OS_FLASH_AMT_COMM_RO_NONFAC_BASE_ADDR + 0x7800
#define OS_FLASH_AMT_COMM_RO_REF_DEFINE_SIZE             0x400


// ,Ҫ,ãֱöӦXXX_SIZE궨
#define ZPS_ImeiLen                                      OS_FLASH_AMT_COMM_RO_IMEI_SIZE
#define ZPS_ImeiSvLen                                    OS_FLASH_AMT_COMM_RO_IMEISV_SIZE
#define ZPS_DEV_MSINFO_MAX_BORDNAME_LEN                  OS_FLASH_AMT_COMM_RO_BOARDNNUM_SIZE
#define ZPS_DEV_MSINFO_MAX_WIFIMAC_LEN                   OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE
#define ZPS_DEV_MSINFO_MAX_SOFTVERSION_LEN               OS_FLASH_AMT_COMM_RO_SOFTVERSION_SIZE
#define ZPS_DEV_MSINFO_MAX_WIFIMAC2_LEN                  OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE

#define Comm_DEV_MSINFO_MAX_WIFIMAC_Area_Len             OS_FLASH_AMT_COMM_RO_WIFIMAC_SIZE
#define Comm_DEV_MSINFO_MAX_WIFIMAC2_Area_Len            OS_FLASH_AMT_COMM_RO_WIFIMAC2_SIZE
#define Comm_DEV_MSINFO_MAX_ETHMAC_Area_Len              OS_FLASH_AMT_COMM_RO_ETHMAC_SIZE

#define ZPS_DEV_MSINFO_MAX_Keys_LEN             	     OS_FLASH_AMT_COMM_RO_V4Key_SIZE
#define Comm_DEV_MSINFO_Keys_Area_Len                    OS_FLASH_AMT_COMM_RO_V4Key_SIZE
#define ZPS_DEV_MSINFO_MAX_SaleState_LEN                 OS_FLASH_AMT_COMM_RO_SaleState_SIZE


typedef   enum
{
    ABIMEI_NVPARAM,                 // Ӳ豸
    ABIMEISV_NVPARAM,               // 汾Ѿʹ
    ABBORDNUm_NVPARAM,              // 
    ABMSERIALNUM_NVPARAM,           // 
    ABVALIDFLAG_NVPARAM,            // MACַѡָʾλ

    ABMAC_INT_NVPARAM,              // ڲMACַ
    ABMAC_EXT_NVPARAM,              // ⲿMACַ
    ABMAC_WIFI_NVPARAM,             // WIFI MACַ
    ABNV_VERSION_NVPARAM,           // NV汾Ϣ
    ABTESTINFO_NVPARAM,             // Ա־λ
    ABSOFTVERSION_NVPARAM,          // Ҫ޸Ŀǰ汾Ųֻ
    ABNET_V4KEY_NVPARAM,
    ABSALE_STATE_NVPARAM,           // MF832S+ͳƱ־
    ABBANDBITMAP_NVPARAM,           // BAND BITMAP
    ABMAC_ETH_NVPARAM,              // ETH MACַ
    ABNET_LCOKKEY_NVPARAM,          // 
    ABMAC_WIFI2_NVPARAM,            // MF971ĿӵڶWIFIַ
    ABMAC_USBMAC_NVPARAM,            //USB(Rndis,ECM)MACַ
    ABMAC_GMAC_NVPARAM,            //GMAC(PHY/Switch) MACַ
    ABFEATURE_KEY_MD5_NVPARAM,            //7520MBBĿˢMD5ֵ
    ABAUTH_KEY_NVPARAM,                                           //GD113 ¼ƼȨ
    ABSOFTDOG_CIPHER_TEXT_NVPARAM,            //ֱͯ
    ABGBDATA_NVPARAM,               // GBNV data by wong 20150602

    MAXABNVPARAM_NVPARAM
} NvParam_AMT;

/*****************************************************************************
 *                         Ա־λĶ                              *
 *****************************************************************************/
typedef enum
{
    BOARDTEST_CURRENT = 0,  BOARDTEST_AUDIO,        BOARDTEST_BT,           BOARDTEST_RESERVED,     //ֽ0
    GSM_CAL,                GSM_FT,                 GSM_CPT,                GSM_RESERVED,           //ֽ1GSM
    GPRS_FT,                GPRS_CPT,               GPRS_RESERVED1,         GPRS_RESERVED2,         //ֽ2GPRS
    EDGE_CAL,               EDGE_FT,                EDGE_CPT,               EDGE_RESERVED,          //ֽ3EDGE
    CDMA_CAL,               CDMA_FT,                CDMA_CPT,               CDMA_DIV_CPT,           //ֽ4CDMA
    EVDO_FT,                EVDO_CPT,               EVDO_CAL,               EVDO_RESERVED2,         //ֽ5EVDO
    WCDMA_CAL,              WCDMA_FT,               WCDMA_CPT,              WCDMA_DIV_CPT,          //ֽ6WCDMA
    TD_CAL,                 TD_FT,                  TD_CPT,                 TD_RESERVED,            //ֽ7TD
    WIMAX_CAL,              WIMAX_FT,               WIMAX_CPT,              WIMAX_RESERVED,         //ֽ8WIMAX
    LTE_CAL,                LTE_FT,                 LTE_CPT,                LTE_DIV_CPT,            //ֽ9LTE ע˫LTEָFDD_LTE
    BLUETOOTH_CAL,          BLUETOOTH_FT,           BLUETOOTH_CPT,          BLUETOOTH_FUN,          //ֽ10
    WIFI_CAL,               WIFI_FT,                WIFI_CPT,               WIFI_FUN,               //ֽ11WIFI
    GPS_FT,                 GPS_CPT,                GPS_FUN,                GPS_RESERVED,           //ֽ12GPS
    MOBILETV_FT,            MOBILETV_CPT,           MOBILETV_FUN,           MOBILETV_RESERVED,      //ֽ13TV
    NFC_FT,                 NFC_FUN,                NFC_RESERVED1,          NFC_RESERVED2,          //ֽ14NFC
    BASEBAND_CURRENT,       BASEBAND_AUDIO,         BASEBAND_RESERVED1,     BASEBAND_RESERVED2,     //ֽ15
    CAC_PREVIEW,            CAC_FINALCHECK,         CAC_RESERVED2,          CAC_RESERVED3,          //ֽ16ܲ
    HSPA_FT,                HSPA_CPT,               HSPA_RESERVED1,         HSPA_RESERVED2,         //ֽ17HSPA
    WCDMA_GSM_FUN,          EVDO_CDMA_FUN,          TD_GSM_FUN,             LTE_TDD_FUN,
    LTE_FDD_FUN,            FUN_RESERVED1,          FUN_RESERVED2,          FUN_RESERVED3,          //1819ֽڣܲ

    TDD_CAL,                TDD_FT,                 TDD_CPT,                TDD_DIV_CPT,            //ֽ20 TDDFDD˫LTE͵TDD־
    GSM_2_CAL,              GSM_2_FT,               GSM_2_CPT,              GSM_2_DIV_CPT,          //ֽ21 GSM ˫λ͵ĵ2λ־
    GPRS_2_CAL,             GPRS_2_FT,              GPRS_2_CPT,             GPRS_2_DIV_CPT,         //ֽ22 GPRS ˫λ͵ĵ2λ־
    EDGE_2_CAL,             EDGE_2_FT,              EDGE_2_CPT,             EDGE_2_DIV_CPT,         //ֽ23 EDGE ˫λ͵ĵ2λ־
    WCDMA_2_CAL,            WCDMA_2_FT,             WCDMA_2_CPT,            WCDMA_2_DIV_CPT,        //ֽ24 WCDMA ˫λ͵ĵ2λ־
    HSPA_2_CAL,             HSPA_2_FT,              HSPA_2_CPT,             HSPA_2_DIV_CPT,         //ֽ25 HSPA ˫λ͵ĵ2λ־
    CDMA_2_CAL,             CDMA_2_FT,              CDMA_2_CPT,             CDMA_2_DIV_CPT,         //ֽ26 CDMA ˫λ͵ĵ2λ־
    EVDO_2_CAL,             EVDO_2_FT,              EVDO_2_CPT,             EVDO_2_DIV_CPT,         //ֽ27 EVDO ˫λ͵ĵ2λ־
    LTE_2_CAL,              LTE_2_FT,               LTE_2_CPT,              LTE_2_DIV_CPT,          //ֽ28 LTE ˫λ͵ĵ2λ־

    ICERA_CONFIG,           ICERA_RESERVED1,        ICERA_RESERVED2,        ICERA_RESERVED3,        //29ֽڣ ICERA

    LTE_BAND1_CAL,          LTE_BAND1_FT,           LTE_BAND1_CPT,          LTE_BAND1_RESERVED,     //30ֽڣ LTE Ƶ1
    LTE_BAND2_CAL,          LTE_BAND2_FT,           LTE_BAND2_CPT,          LTE_BAND2_RESERVED,     //31ֽڣ LTE Ƶ2
    LTE_BAND3_CAL,          LTE_BAND3_FT,           LTE_BAND3_CPT,          LTE_BAND3_RESERVED,     //32ֽڣ LTE Ƶ3
    LTE_BAND4_CAL,          LTE_BAND4_FT,           LTE_BAND4_CPT,          LTE_BAND4_RESERVED,     //33ֽڣ LTE Ƶ4
    LTE_BAND5_CAL,          LTE_BAND5_FT,           LTE_BAND5_CPT,          LTE_BAND5_RESERVED,     //34ֽڣ LTE Ƶ5
    LTE_BAND6_CAL,          LTE_BAND6_FT,           LTE_BAND6_CPT,          LTE_BAND6_RESERVED,     //35ֽڣ LTE Ƶ6
    LTE_BAND7_CAL,          LTE_BAND7_FT,           LTE_BAND7_CPT,          LTE_BAND7_RESERVED,     //36ֽڣ LTE Ƶ7
    LTE_BAND8_CAL,          LTE_BAND8_FT,           LTE_BAND8_CPT,          LTE_BAND8_RESERVED,     //37ֽڣ LTE Ƶ8
    LTE_BAND9_CAL,          LTE_BAND9_FT,           LTE_BAND9_CPT,          LTE_BAND9_RESERVED,     //38ֽڣ LTE Ƶ9
    LTE_BAND10_CAL,         LTE_BAND10_FT,          LTE_BAND10_CPT,         LTE_BAND10_RESERVED,    //39ֽڣ LTE Ƶ10

    TDD_2_CAL,              TDD_2_FT,               TDD_2_CPT,              TDD_2_DIV_CPT,          //40ֽڣTDD_LTE ˫λ͵ĵ2λ־
    GPS_2_FT,               GPS_2_CPT,              GPS_2_FUN,              GPS_2_RESERVED,         //41ֽڣGPS˫λ͵ĵ2λ־GPS
    DL_PV,                  DL_RELEASE,             DL_AMT,                 DL_RESERVED,            //42ֽڣ
    BAND_BIT_MAP_FLAG,      BAND_BIT_MAP_RESERVED1, BAND_BIT_MAP_RESERVED2, BAND_BIT_MAP_RESERVED3, //43ֽڣBAND_BIT_MAP_FLAG
    /* 蹦ܲ */
    SOFTVERSION_CHECK,      TESTINFO_CHECK,         BUTTION_CHECK,          LCD_BACKLIT_CHECK,      //44ֽ,
    MOTOR_CHECK,            LCD_TEST,               LOUDSPEAKER_CHECK,      EARPHONE_CHECK,         //45ֽ,
    MICRO_PHONE_CHECK,      HEAD_SET_CHECK,         FM_CHECK,               SIMCARD_CHECK,          //46ֽ,
    CHARGING_CHECK,         FLASH_LIGHT_CHECK,      KEY_LIGHT_CHECK,        RESET_CHECK,            //47ֽ,
    HEADSET_KEY_CHECK,      BATTERT_VOLTAGE_CHECHK, SDCARD_CHECK,           CAMERA_BACK_CHECK,      //48ֽ,
    IDLE_CURRENT_CHECK,     OFF_CURRENT_CHECK,      DEVICETEST_RESERVED1,   DEVICETEST_RESERVED2,   //49ֽ,
    DEVICETEST_RESERVED3,   DEVICETEST_RESERVED4,   DEVICETEST_RESERVED5,   DEVICETEST_RESERVED6,   //50ֽ,
    DEVICETEST_RESERVED7,   DEVICETEST_RESERVED8,   DEVICETEST_RESERVED9,   DEVICETEST_RESERVED10,  //51ֽ,
    DEVICETEST_RESERVED11,  DEVICETEST_RESERVED12,  DEVICETEST_RESERVED13,  DEVICETEST_RESERVED14,  //52ֽ,
    DEVICETEST_RESERVED15,  DEVICETEST_RESERVED16,  DEVICETEST_RESERVED17,  DEVICETEST_RESERVED18,  //53ֽ,

    MAXAMTFALGS_NVPARAM = 799,  // 200ֽڣһֽ4־λɱʾ0~799־λ44~199ֽԤ
} NvParam_AMTFlags;

typedef enum
{
    T_INITIAL    = 0,  //BIT: 00
    T_PASSED     = 1,  //BIT: 01
    T_FAILED     = 2,  //BIT: 10
    T_ERRORVALUE = 3
} TestResultAMT;
//} TestResult;

/*****************************************************************************
 * : zPS_NvAMTItemWrite
 * : дһNV
 * ˵:
              (IN)
                  nvParam:      NV
                  NvItemData:   д
                  NvItemLen:    ݳ
              (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32  zPS_NvAMTItemWrite(NvParam_AMT nvParam,UINT8 *NvItemData, UINT32 NvItemLen);

/*****************************************************************************
 * : zPS_NvAMTItemRead
 * : һNV
 * ˵:
              (IN)
                  nvParam:     NV
                  NvItemData:  
                  NvItemLen:   ݳ
              (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32  zPS_NvAMTItemRead(NvParam_AMT nvParam,UINT8 *NvItemData, UINT32 NvItemLen);

/*****************************************************************************
 * : zPS_NvAMTFlagsItemWrite
 * :дԱ־λ
 * ˵:
              (IN)
                  nvParam:    NV
                  NvItemData: д
              (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32  zPS_NvAMTFlagsItemWrite(NvParam_AMTFlags nvParam,UINT8 *NvItemData);

/*****************************************************************************
 * : zPS_NvAMFlagsTItemRead
 * : Ա־λ
 * ˵:
              (IN)
                  nvParam:     NV
                  NvItemData:  ȡ
              (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32 zPS_NvAMFlagsTItemRead(NvParam_AMTFlags nvParam,UINT8 *NvItemData);

/*****************************************************************************
 * : zPS_GetAmtNvBandInfo
 * :ƵϢ
 * ˵:
              (IN)
                  NvItemData ȡϢĴbuffer
              (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32  zPS_GetAmtNvBandInfo(UINT8 *NvItemData);
#if 0
/**************************************************************************
* : zPS_LteCalibNvCheck
* : LTEУ׼NVǷĳbandڣָƵݸһ
* ˵:
             (IN)
                 dest  ĿbandţΧ1128
                 src   ڸƵԴbandţΧ1128
                 read  0ʾ¶ȡNandRam0ʾ¶ȡNandRam
                 write 0ʾramдNand0ʾдNand

             (OUT)
*   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
* ˵:
**************************************************************************/
UINT32  zPS_LteCalibNvCheck(UINT16 dest, UINT16 src, UINT16 read, UINT16 write);
/*****************************************************************************
 * : zPS_NvRoUserWrite
 * : ûԶд
 * ˵:
             (IN)
                 dwStart : 0 ~ 1k
                 dwLen   : 0 ~ 1k
                 from    : д
             (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
SINT32 zPS_NvRoUserWrite(UINT32 dwStart, UINT32 dwLen, UINT8* from);

/*****************************************************************************
 * : zPS_NvRoUserRead
 * : ûԶ
 * ˵:
             (IN)
                 dwStart : 0 ~ 1k
                 dwLen   : 0 ~ 1k
                 to      : ص

             (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
SINT32 zPS_NvRoUserRead(UINT32 dwStart, UINT32 dwLen, UINT8* to);
/*****************************************************************************
 * : zPS_NvRoRefRead
 * : οԶ
 * ˵:
             (IN)
                 dwStart : 0 ~ 1k
                 dwLen   : 0 ~ 1k
                 to      : ص

             (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
SINT32 zPS_NvRoRefRead(UINT32 dwStart, UINT32 dwLen, UINT8* to);
/*****************************************************************************
 * : zPS_NvRoRefWrite
 * : οԶд
 * ˵:
             (IN)
                 dwStart : 0 ~ 1k
                 dwLen   : 0 ~ 1k
                 from    : д
             (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
SINT32 zPS_NvRoRefWrite(UINT32 dwStart, UINT32 dwLen, UINT8* from);
#endif
/*****************************************************************************
 * : zPs_NvCheckBandBitmap
 * : ʽУ׼ݣѰҴУ׼ݵbandдbitmap
 * ˵:
             (IN)
                 NvItemData: 
                 NvItemLen:  ݳ

             (OUT)
 *   ֵ: ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * ˵:
 *****************************************************************************/
UINT32 zPs_NvCheckBandBitmap(UINT8 *NvItemData, UINT32 NvItemLen);

/*****************************************************************************
 * ƣ zAmt_GetPublicKey
 *  عԿ
 * ˵
              pE(in/out): Eָ
              pELen(in/out): Eָ
              pN(in/out): Nָ
              pModulusLen(in/out): Nָ
 *   ֵɹ0ʧܷ-1
 * ˵
 *****************************************************************************/
SINT32 zAmt_GetPublicKey(BYTE *pE, UINT32 *pELen, BYTE *pN, UINT32 *pModulusLen);

/*****************************************************************************
 * : zAmt_GetCommNvSizeByNvParam
 * : ȡcomm nvÿnvĴС
 * ˵:
             (IN)
                 nvParam: comm nv

             (OUT)
                 nvsize
 *   ֵ: ɹʵnvsizeʧܷ0
 * ˵:
 *****************************************************************************/
UINT32 zAmt_GetCommNvSizeByNvParam(NvParam_AMT nvParam);

#endif

