/**
 * @file at_common.h
 * @brief Inter APIs of libatreg
 *
 * Copyright (C) 2022 Sanechips Technology Co., Ltd.
 * @author 
 * @ingroup 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */


#ifndef _ATREG_COMMON_H
#define _ATREG_COMMON_H


/*******************************************************************************
 *                           Include header files                              *
 *******************************************************************************/
#include <semaphore.h>
#include <pthread.h>
#include "softap_api.h"
#include "zxic_list.h"


/*******************************************************************************
 *                             Macro definitions                               *
 *******************************************************************************/
#define AT_REG_SER 0
#define AT_REG_INFO 1

#define AT_CMD_PREFIX 64

#define ATREG_SER_ID_MAX 64
#define ATREG_INFO_ID_MAX 32

#define WAIT_RSP_TIMEOUT 30

#define ATREG_PRINT     "[atreg]"


/*******************************************************************************
 *                             Type definitions                                *
 *******************************************************************************/
typedef void (*ser_cb_proc)(unsigned char *at_paras, unsigned char *res_msg);
typedef void (*info_cb_proc)(unsigned char *at_paras);


/** AT instance - ser */
struct atreg_ser_instance_t {
    struct list_head list;
	char at_cmd_prefix[AT_CMD_PREFIX];
    int req_msg_id;
	int rsp_msg_id;
    ser_cb_proc cb;
};


/** AT instance - info */
struct atreg_info_instance_t {
	struct list_head list;
	char at_cmd_prefix[AT_CMD_PREFIX];
    int req_msg_id;
    info_cb_proc cb;
};


/** AT - ser */
struct atreg_ser_context_t {
	/* ¼עAT */
	struct list_head at_ser_list;
	struct list_head at_ser_list_tmp;
	
	/* at_ser_listat_ser_list_tmpĻ*/
	pthread_mutex_t at_ser_lock;
	pthread_mutex_t at_ser_lock_tmp;
	
	/* atreg_ser_dynamic_idpoolĻ*/
	pthread_mutex_t at_ser_idpool_lock;
};



/** AT - info */
struct atreg_info_context_t {
	/* ¼עAT */
	struct list_head at_info_list;
	struct list_head at_info_list_tmp;
	
	/* atreg_info_listatreg_info_list_tmpĻ*/
	pthread_mutex_t at_info_lock;
	pthread_mutex_t at_info_lock_tmp;
	
	/* atreg_info_dynamic_idpoolĻ*/
	pthread_mutex_t at_info_idpool_lock;
};


/** AT - common */
struct atreg_common_context_t {
	/* źʵֺͬ: Ϣ󣬵ȴӦ */
	sem_t sem_id;	
	/* sem_timedwaitʱ */
	struct timespec ts;

	/* ߳ID */
	pthread_t threadid;

	/* module id */
	int modid;	
};


/** AT instancetype */
struct atreg_instance_and_type_t {
	int type;
    void *instance;
};


/*******************************************************************************
 *                       Global variable declarations                          *
 *******************************************************************************/
extern struct atreg_ser_context_t atreg_ser_ctx;
extern struct atreg_info_context_t atreg_info_ctx;
extern struct atreg_common_context_t atreg_common_ctx;

/** ser - ̬id,	Χ: 0~511 */
extern unsigned char atreg_ser_dynamic_idpool[ATREG_SER_ID_MAX];
/** info - ̬id,	Χ: 512~768 */
extern unsigned char atreg_info_dynamic_idpool[ATREG_INFO_ID_MAX];


/*******************************************************************************
 *                       Global function declarations                          *
 *******************************************************************************/
/** atreg_common.c */
void atreg_wait_rsp(int msg_cmd);

void *atreg_search_instance_by_prefix(char *at_cmd_prefix, int atreg_type);
void *atreg_search_instance_tmp_by_reqid(int req_msg_id, int atreg_type);

struct atreg_instance_and_type_t atreg_search_instance_and_type_by_reqid(int req_msg_id);


/** at_thread.c */
void atreg_msg_thread_entry(void *arg);


#endif

