#ifdef USE_CAP_SUPPORT
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "voice_ipc.h"
#include "voice_lib.h"
#include "linux/rpmsg_zx29.h"
#include "softap_api.h"
#include "pthread.h"
#include <linux/volte_drv.h>

extern int sc_audio_set_voice_device_mode(int dev_mode);
extern int sc_audio_get_voice_device_mode(int *p_dev_mode);
extern int sc_audio_set_rx_voice_vol(int vol);
extern int sc_audio_get_rx_voice_vol(int     * p_vol);
extern int sc_audio_set_tx_voice_vol(int vol);
extern int sc_audio_get_tx_voice_vol(int  *p_vol);
extern int sc_audio_set_tx_voice_mute_state(int mute         );
extern int sc_audio_get_tx_voice_mute_state(int *p_mute);
extern int sc_audio_set_rx_voice_mute_state(int mute);
extern int sc_audio_get_rx_voice_mute_state(int *p_mute);
extern int sc_audio_set_rx_voice_vol_gain(int gain);
extern int sc_audio_get_rx_voice_vol_gain(int     * p_gain);
extern int sc_audio_set_tx_voice_vol_gain(int gain);
extern int sc_audio_get_tx_voice_vol_gain(int     * p_gain);
//extern int sc_audio_set_loopback_enable_state(int enable);
//extern int sc_audio_get_loopback_enable_state(int *p_enable);
int ap_audio_set_loopback_enable(int dev_mode,int enable);
int ap_audio_get_loopback_enable(int *p_enable);

static unsigned char *recv_voice_nvrw_buf = NULL;
static int voice_ipc_fd = -1;
static voice_ipc_control_msg voice_ctrl_recvmsg[IPC_VOICE_FUNC_MAX] = {0};

int cap_alsa_voice_open(int vmode)
{
    int ret = 0;
    int msg_handle = 0;
	MSG_BUF msg;
	LONG msg_size =  sizeof(MSG_BUF)-sizeof(LONG);
    int module_id = MODULE_ID_VOICE_CLIENT;
    int dst_id = MODULE_ID_VOICE_SERVER;
    int msg_cmd = MSG_CMD_CAP_VALSA_OPEN;
    
    //Ϣ
	msg_handle = msgget(module_id, IPC_CREAT|0600);
    
    //Ϣ
    ret = ipc_send_message(module_id, dst_id, msg_cmd, sizeof(int), (unsigned char *)(&vmode), 0);
    if(0 != ret){
        printf("%s: send msg error(%d)!\n", __func__, ret);
        msgctl(msg_handle,IPC_RMID,0);
        return ret;
    }
    printf("%s: send msg success(%d)!\n", __func__, ret);
    
    //Ϣ
    while(1)
	{
		memset(&msg, 0x00, sizeof(MSG_BUF));

		//ȡϢϢ
		ret = msgrcv(msg_handle, &msg, msg_size, 0, 0);
        if(0 > ret){
            continue;
        }

        //ƥ䵽MSG_CMD_CAP_VALSA_OPENʱŴ
        if(msg_cmd == msg.usMsgCmd){
            ret = *((int *)msg.aucDataBuf);
            msgctl(msg_handle,IPC_RMID,0);
            printf("%s: receive msg success(%d)!\n", __func__, ret);
            break;
        }
	}

    return ret;
}

int cap_alsa_voice_close(int vmode)
{
    int ret = 0;
    int msg_handle = 0;
	MSG_BUF msg;
	LONG msg_size =  sizeof(MSG_BUF)-sizeof(LONG);
    int module_id = MODULE_ID_VOICE_CLIENT;
    int dst_id = MODULE_ID_VOICE_SERVER;
    int msg_cmd = MSG_CMD_CAP_VALSA_CLOSE;

    //Ϣ
	msg_handle = msgget(module_id, IPC_CREAT|0600);
    
    //Ϣ
    ret = ipc_send_message(module_id, dst_id, msg_cmd, sizeof(int), (unsigned char *)(&vmode), 0);
    if(0 != ret){
        printf("%s: send msg error(%d)!\n", __func__, ret);
        msgctl(msg_handle,IPC_RMID,0);
        return ret;
    }
    printf("%s: send msg success(%d)!\n", __func__, ret);

    //Ϣ
    while(1)
	{
		memset(&msg, 0x00, sizeof(MSG_BUF));

		//ȡϢϢ
		ret = msgrcv(msg_handle, &msg, msg_size, 0, 0);
        if(0 > ret){
            continue;
        }

        //ƥ䵽MSG_CMD_CAP_VALSA_CLOSEʱŴ
        if(msg_cmd == msg.usMsgCmd){
            ret = *((int *)msg.aucDataBuf);
            msgctl(msg_handle,IPC_RMID,0);
            printf("%s: receive msg success(%d)!\n", __func__, ret);
            break;
        }
	}

    return ret;
}

int ipc_cap_alsa_voice_open(int vmode)
{
    int ret = 0;
    int func_id = IPC_CAP_ALSA_VOICE_OPEN;
    voice_ctrl_recvmsg[func_id].func_id = VOICE_WAIT_MSG_FROM_CAP;

    ret = Voice_Ctrl_Rpmsg_Send(func_id, &vmode);
    
    if (0 >= ret){
		printf("%s: Voice_Ctrl_Rpmsg_Send error, return %d!\n", __func__, ret);
		return VOICEIPC_ERROR;
	}
    printf("%s: Voice_Ctrl_Rpmsg_Send success, write_len=%d!\n", __func__, ret);
    
    while(func_id != voice_ctrl_recvmsg[func_id].func_id){
        usleep(1);
    }
    
    memcpy(&ret, voice_ctrl_recvmsg[func_id].param, voice_ctrl_recvmsg[func_id].param_len);
    printf("%s: ipc receive success, ret=%d!\n", __func__, ret);

    return ret;
}

int ipc_cap_alsa_voice_close(int vmode)
{
    int ret = 0;
    int func_id = IPC_CAP_ALSA_VOICE_CLOSE;
    voice_ctrl_recvmsg[func_id].func_id = VOICE_WAIT_MSG_FROM_CAP;
    
    ret = Voice_Ctrl_Rpmsg_Send(func_id, &vmode);
    
    if (0 >= ret){
		printf("%s: Voice_Ctrl_Rpmsg_Send error, return %d!\n", __func__, ret);
		return VOICEIPC_ERROR;
	}
    printf("%s: Voice_Ctrl_Rpmsg_Send success, write_len=%d!\n", __func__, ret);

    while(func_id != voice_ctrl_recvmsg[func_id].func_id){
        usleep(1);
    }

    memcpy(&ret, voice_ctrl_recvmsg[func_id].param, voice_ctrl_recvmsg[func_id].param_len);
    printf("%s: ipc receive success, ret=%d!\n", __func__, ret);

    return ret;
}

void ipc_set_voice_device_mode_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int dev_mode = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    dev_mode = *((int *)msg.param);
    ret = sc_audio_set_voice_device_mode(dev_mode);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_voice_device_mode_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_dev_mode = NULL;

    p_dev_mode = (int *)msg.param;
    ret = sc_audio_get_voice_device_mode(p_dev_mode);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_dev_mode, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_rx_voice_vol_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int vol = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    vol = *((int *)msg.param);
    ret = sc_audio_set_rx_voice_vol(vol);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_rx_voice_vol_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_vol = NULL;

    p_vol = (int *)msg.param;
    ret = sc_audio_get_rx_voice_vol(p_vol);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_vol, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_rx_voice_vol_gain_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int gain = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    gain = *((int *)msg.param);
    ret = sc_audio_set_rx_voice_vol_gain(gain);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_rx_voice_vol_gain_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_vol = NULL;

    p_vol = (int *)msg.param;
    ret = sc_audio_get_rx_voice_vol_gain(p_vol);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_vol, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_tx_voice_vol_gain_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int gain = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    gain = *((int *)msg.param);
    ret = sc_audio_set_tx_voice_vol_gain(gain);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_tx_voice_vol_gain_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_vol = NULL;

    p_vol = (int *)msg.param;
    ret = sc_audio_get_tx_voice_vol_gain(p_vol);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_vol, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_tx_voice_vol_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int vol = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    vol = *((int *)msg.param);
    ret = sc_audio_set_tx_voice_vol(vol);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_tx_voice_vol_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_vol = NULL;

    p_vol = (int *)msg.param;
    ret = sc_audio_get_tx_voice_vol(p_vol);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_vol, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_tx_voice_mute_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int mute = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    mute = *((int *)msg.param);
    ret = sc_audio_set_tx_voice_mute_state(mute);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_tx_voice_mute_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_mute = NULL;

    p_mute = (int *)msg.param;
    ret = sc_audio_get_tx_voice_mute_state(p_mute);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_mute, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_rx_voice_mute_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int mute = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    mute = *((int *)msg.param);
    ret = sc_audio_set_rx_voice_mute_state(mute);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_rx_voice_mute_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_mute = NULL;

    p_mute = (int *)msg.param;
    ret = sc_audio_get_rx_voice_mute_state(p_mute);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_mute, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_set_loopback_enable_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
	int dev_mode = 0,enable = 0;

    //memcpy(&dev_mode, msg.param, msg.param_len);
    //enable = *((int *)msg.param);
	memcpy(&dev_mode, msg.param, sizeof(int));
	memcpy(&enable, msg.param+sizeof(int), sizeof(int));
	
    //ret = sc_audio_set_loopback_enable_state(enable);
	ret = ap_audio_set_loopback_enable(dev_mode,enable);

    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_get_loopback_enable_state_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int *p_enable = NULL;

    p_enable = (int *)msg.param;
    //ret = sc_audio_get_loopback_enable_state(p_enable);
    ret = ap_audio_get_loopback_enable(p_enable);	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    if(0 == ret)
        memcpy(msg.param, p_enable, msg.param_len);
    else
        memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

#ifdef _USE_VOICE_ALSA
void ipc_ap_alsa_voice_open_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int vmode = 0;

    vmode = *((int *)msg.param);
    ret = alsa_voice_open(vmode);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}

void ipc_ap_alsa_voice_close_rcv(voice_ipc_control_msg msg)
{
    int ret = VOICEIPC_OK;
    int msg_len = 0;
    int vmode = 0;

    vmode = *((int *)msg.param);
    ret = alsa_voice_close(vmode);
	
    //msg.func_id不变
    msg.param_len = sizeof(int);
    memcpy(msg.param, &ret, msg.param_len);
    msg_len = VOICE_HEAD_LEN + msg.param_len;

    ret = write(voice_ipc_fd, &msg, msg_len);
    
    if (0 >= ret){
		printf("%s: write error(%d)!\n", __func__, ret);
	}
}
#endif

void voice_ipc_recv_proc(voice_ipc_control_msg msg)
{
	switch(msg.func_id){
		case IPC_SET_VOICE_DEVICE_MODE:
			ipc_set_voice_device_mode_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
		case IPC_GET_VOICE_DEVICE_MODE:
			ipc_get_voice_device_mode_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_RX_VOICE_VOL:
			ipc_set_rx_voice_vol_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_RX_VOICE_VOL:
			ipc_get_rx_voice_vol_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_RX_VOICE_VOL_GAIN:
			ipc_set_rx_voice_vol_gain_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_RX_VOICE_VOL_GAIN:
			ipc_get_rx_voice_vol_gain_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_TX_VOICE_VOL_GAIN:
			ipc_set_tx_voice_vol_gain_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_TX_VOICE_VOL_GAIN:
			ipc_get_tx_voice_vol_gain_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_TX_VOICE_VOL:
			ipc_set_tx_voice_vol_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_TX_VOICE_VOL:
			ipc_get_tx_voice_vol_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_TX_VOICE_MUTE_STATE:
			ipc_set_tx_voice_mute_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_TX_VOICE_MUTE_STATE:
			ipc_get_tx_voice_mute_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_RX_VOICE_MUTE_STATE:
			ipc_set_rx_voice_mute_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_RX_VOICE_MUTE_STATE:
			ipc_get_rx_voice_mute_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_SET_LOOPBACK_ENABLE_STATE:
			ipc_set_loopback_enable_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_GET_LOOPBACK_ENABLE_STATE:
			ipc_get_loopback_enable_state_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
#ifdef _USE_VOICE_ALSA        
        case IPC_AP_ALSA_VOICE_OPEN:
			ipc_ap_alsa_voice_open_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
        case IPC_AP_ALSA_VOICE_CLOSE:
			ipc_ap_alsa_voice_close_rcv(voice_ctrl_recvmsg[msg.func_id]);
			break;
#endif        
		default:
		    break;
	}
}

void Voice_Ctrl_Rpmsg_Recv(void)
{
    int read_len = 0;
    voice_ipc_control_msg tmpbuf = {0};
    
    while(1){
        read_len = read(voice_ipc_fd, &tmpbuf, (VOICE_HEAD_LEN + VOICE_CONTROL_MAX_LEN));
        
        if (0 >= read_len){
            sleep(1);
			continue;
		}
        printf("%s: voice_ipc_fd=%d, read_len=%d\n", __func__, voice_ipc_fd, read_len);
        
        //ݶȡٸıfuc_id
        if(0 != tmpbuf.param_len){
            memcpy(voice_ctrl_recvmsg[tmpbuf.func_id].param, tmpbuf.param, tmpbuf.param_len);
        }
        voice_ctrl_recvmsg[tmpbuf.func_id].param_len = tmpbuf.param_len;
        voice_ctrl_recvmsg[tmpbuf.func_id].func_id = tmpbuf.func_id;
        printf("%s: tmpbuf.param_len=%d, tmpbuf.func_id=%d\n", __func__, tmpbuf.param_len, tmpbuf.func_id);
        
        voice_ipc_recv_proc(voice_ctrl_recvmsg[tmpbuf.func_id]);
    }
}

int Voice_Ctrl_Rpmsg_Send(int func_id, int *msg)
{
    voice_ipc_control_msg tmpbuf = {0};
    int tmpbuf_len = 0;
    int write_len = 0;
    
    tmpbuf.func_id = func_id;
    
    if(NULL == msg){
        tmpbuf.param_len = 0;
    }else{
        tmpbuf.param_len = sizeof(int);
        memcpy(tmpbuf.param, msg, tmpbuf.param_len);
    }
    
    tmpbuf_len = VOICE_HEAD_LEN + tmpbuf.param_len;

    //printf("Voice_Ctrl_Rpmsg_Send, voice_ipc_fd = %d\n", voice_ipc_fd);
    write_len = write(voice_ipc_fd, &tmpbuf, tmpbuf_len);

    return write_len;
}

int voice_ipc_init(void) //通道初始?
{
    voice_ipc_fd = open(VOICE_IPC_CONTROL_CHANNEL, O_RDWR);

    if(0 > voice_ipc_fd){
        printf("%s: open the channel(%s) error!\n", __func__, VOICE_IPC_CONTROL_CHANNEL);
        return VOICEIPC_ERROR;
    }

    if(0 > ioctl(voice_ipc_fd, RPMSG_CREATE_CHANNEL, VOICE_IPC_CONTROL_CHANNEL_SIZE)){
        printf("%s: ioctl RPMSG_CREATE_CHANNEL fail!\n", __func__);
        close(voice_ipc_fd);
        voice_ipc_fd = -1;
        return VOICEIPC_ERROR;
    }
    
    if(0 > ioctl(voice_ipc_fd, RPMSG_SET_INT_FLAG, NULL)){ //写中?
        printf("%s: ioctl RPMSG_SET_INT_FLAG fail!\n", __func__);
        close(voice_ipc_fd);
        voice_ipc_fd = -1;
        return VOICEIPC_ERROR;
    }
    
    if(0 > ioctl(voice_ipc_fd, RPMSG_CLEAR_POLL_FLAG, NULL)){ //阻塞方式读数?
        printf("%s: ioctl RPMSG_CLEAR_POLL_FLAG fail!\n", __func__);
        close(voice_ipc_fd);
        voice_ipc_fd = -1;
        return VOICEIPC_ERROR;
    }

    printf("voice_ipc_init %s create success! voice_ipc_fd = %d\n", VOICE_IPC_CONTROL_CHANNEL, voice_ipc_fd);
    
    return VOICEIPC_OK;
}

int recv_msg_proc(MSG_BUF msg)
{
    int ret = 0;
    int vmode = 0;
    int module_id = MODULE_ID_VOICE_SERVER;
    int dst_id = MODULE_ID_VOICE_CLIENT;
    
    switch(msg.usMsgCmd){
		case MSG_CMD_CAP_VALSA_OPEN:
            vmode = *((int *)msg.aucDataBuf);
			ret = ipc_cap_alsa_voice_open(vmode);
            //dst_id = MODULE_ID_CAP_VALSA_OPEN;
            ret = ipc_send_message(module_id, dst_id, msg.usMsgCmd, sizeof(int), (unsigned char *)(&ret), 0);
            if(0 != ret){
                printf("%s: ipc_send_message error, return %d!\n", __func__, ret);
            }
			break;
        case MSG_CMD_CAP_VALSA_CLOSE:
            vmode = *((int *)msg.aucDataBuf);
			ret = ipc_cap_alsa_voice_close(vmode);
			//dst_id = MODULE_ID_CAP_VALSA_CLOSE;
            ret = ipc_send_message(module_id, dst_id, msg.usMsgCmd, sizeof(int), (unsigned char *)(&ret), 0);
            if(0 != ret){
                printf("%s: ipc_send_message error, return %d!\n", __func__, ret);
            }
			break;
        default:
            printf("%s: msg.usMsgCmd=%d, not support!\n", __func__, msg.usMsgCmd);
            break;
    }
    
    return ret;
}

void recv_cap_voice_alsa(void)
{
    int ret = 0;
    int msg_handle = 0;
	MSG_BUF msg;
	LONG msg_size =  sizeof(MSG_BUF)-sizeof(LONG);
    int module_id = MODULE_ID_VOICE_SERVER;

    //Ϣ
	msg_handle = msgget(module_id, IPC_CREAT|0600);

    //Ϣ
    while(1)
	{
		memset(&msg, 0x00, sizeof(MSG_BUF));

		//ȡϢϢ
		ret = msgrcv(msg_handle, &msg, msg_size, 0, 0);
        
        if(0 > ret){
            continue;
        }

        recv_msg_proc(msg);
    }
}

void recv_update_voice_nvrw_ipc(void)
{
    int read_len = 0;
    int ret = -1;
    int fd = -1;

    recv_voice_nvrw_buf = (unsigned char*)malloc(VOICE_HEAD_LEN + VOICE_NVRW_MAX_LEN);
    if(!recv_voice_nvrw_buf){
        printf("%s: recv_voice_nvrw_buf malloc fail!\n", __func__);
        return;
    }
    
    while(1){
        read_len = read(voice_ipc_fd, recv_voice_nvrw_buf, VOICE_HEAD_LEN + VOICE_NVRW_MAX_LEN);
        if (0 >= read_len){
            sleep(1);
			continue;
		}

        printf("%s: read_len = %d, func_id = %d, param_len = %d!\n", __func__, read_len, \
        *((int*)recv_voice_nvrw_buf), *((int*)recv_voice_nvrw_buf + 1));
        
#if 0
        printf("%s: param[0]=%02x,param[1]=%02x,param[2]=%02x,param[3]=%02x,param[4]=%02x,param[5]=%02x,param[6]=%02x!\n", \
            __func__, recv_voice_nvrw_buf.param[0], recv_voice_nvrw_buf.param[1], recv_voice_nvrw_buf.param[2], \
            recv_voice_nvrw_buf.param[3], recv_voice_nvrw_buf.param[4], recv_voice_nvrw_buf.param[5], recv_voice_nvrw_buf.param[6]);
        
        int writesize = 0;
        FILE *ptest = fopen("/mnt/userdata/voice_nv_test_ap.bin", "wb");
        if(!ptest){
            printf("%s: Unable to create file '/mnt/userdata/voice_nv_test_ap.bin'!\n", __func__);
        }

        writesize = fwrite(recv_voice_nvrw_buf.param, 1, recv_voice_nvrw_buf.param_len, ptest);
        printf("%s: writesize = %d!\n", __func__, writesize);
        
        if(NULL != ptest){
            fclose(ptest);
        }
#endif
        
    	fd = open(VOICE_DEV_NAME, O_RDWR);

        if(0 > fd){
            printf("%s: open voice device error!\n", __func__);
        }
        else{
            ret = ioctl(fd, VOICE_IOCTL_SET_VOICE_NVRW, recv_voice_nvrw_buf);
            printf("%s: ioctl /dev/voice_device end, ret=%d!\n", __func__, ret);
            close(fd);
        }
        
        break;
    }

    if(recv_voice_nvrw_buf){
        free(recv_voice_nvrw_buf);
        recv_voice_nvrw_buf = NULL;
    }
    
    return;
}

int main(int argc, char **argv)
{
    int ret = 0;
    
    //ipcͨʼ
    ret = voice_ipc_init();
    if(0 > ret){
        printf("voice_ipc_init %s error!\n", VOICE_IPC_CONTROL_CHANNEL);
        return -1;
    }
    
    //ipcʼ󣬴msgϢ߳
	pthread_t recv_thread_tid;
	if(0 != pthread_create(&recv_thread_tid, NULL, (void *)recv_cap_voice_alsa, NULL)){
		printf("recv_cap_voice_alsa create error!\n");
	}

    sleep(4); //ȴcapƵ˼ͨ

    //ipcʼֱӻȡcapvoice nv
    recv_update_voice_nvrw_ipc();
    
    Voice_Ctrl_Rpmsg_Recv();
    
    return 0;
}

#endif
