/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_DISK_H
#define _DRVS_DISK_H

#include "drvs_list.h"
#include "drvs_io.h"
#include "drvs_io_dev.h"


typedef struct _T_ZDrvDisk_PartDevice T_ZDrvDisk_PartDevice;

typedef struct _T_ZDrvDisk_DevDesc {
	char dev_name[32];			/* device name */
	unsigned char	part_type;	/* partition type */
	unsigned char	target;		/* target SCSI ID */
	unsigned char	type;		/* device type */
	unsigned char	removable;	/* removable device */
	unsigned long		lba;		/* number of blocks */
	unsigned long	blksz;		/* block size */
	char		vendor [40+1];	/* IDE model, SCSI Vendor */
	char		product[20+1];	/* IDE Serial no, SCSI product */
	char		revision[8+1];	/* firmware revision */
	
	T_ZDrvDisk_PartDevice *partition;
	
	SINT32	(*block_read)(VOID *priv_data,
				      UINT32 start,
				      UINT32 blkcnt,
				      VOID *buffer);
	SINT32	(*block_write)(VOID *priv_data,
				       UINT32 start,
				       UINT32 blkcnt,
				       const VOID *buffer);
	SINT32 (*block_erase)(VOID *priv_data,
				       UINT32 start,
				       UINT32 blkcnt);
	VOID		*priv_data;		/* device private data */
}T_ZDrvDisk_DevDesc;


/* Part types */
#define PART_TYPE_UNKNOWN	0x00
#define PART_TYPE_MAC		0x01
#define PART_TYPE_DOS		0x02
#define PART_TYPE_ISO		0x03
#define PART_TYPE_AMIGA		0x04
#define PART_TYPE_EFI		0x05
#define PART_TYPE_TSP		0x06


/* device types */
#define DEV_TYPE_UNKNOWN	0xff	/* not connected */
#define DEV_TYPE_HARDDISK	0x00	/* harddisk */
#define DEV_TYPE_TAPE		0x01	/* Tape */
#define DEV_TYPE_CDROM		0x05	/* CD-ROM */
#define DEV_TYPE_OPDISK		0x07	/* optical disk */

typedef struct _T_ZDrvDisk_Partition {
	unsigned long	start;		/* # of first block in partition	*/
	unsigned long	size;		/* number of blocks in partition	*/
	unsigned long	blksz;		/* block size in bytes			*/
	unsigned char	name[48];	/* partition name			*/
	unsigned char	type[32];	/* string type description		*/
} T_ZDrvDisk_Partition;

typedef struct _T_ZDrvDisk_PartDevice
{
    struct list_head 		node;
    T_ZDrvDisk_Partition	part_info;
    T_ZDrvDisk_DevDesc    *blk_dev;
    T_ZDrvIODev_Handle  	   *io_dev;
}
T_ZDrvDisk_PartDevice;

SINT32 zDrvDisk_Register(T_ZDrvDisk_DevDesc *dev_desc);
VOID zDrvDisk_Unregister(T_ZDrvDisk_DevDesc *dev_desc);

#endif /* _DRVS_DISK_H */
