/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    drvs_dpram.h
 * File Mark:    
 * Description:  dpram interface declaration(W&TD).
 * Others:        
 * Version:       v0.1
 * Author:        shideyou
 * Date:          2013-6-19
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_DPRAM_H
#define _DRVS_DPRAM_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
//#include "ps_ephy_interface.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum
{
	DPRAM_RAT_W,
	DPRAM_RAT_TD,
	DPRAM_RAT_LTE,

	MAX_DPRAM_RAT
}
T_ZDrvDpram_Rat;

/* error code define */
typedef enum
{
    DPRAM_RET_SUCCESS                             = 0,        /* successed */
    DPRAM_RET_ERROR                                = 1,        /* error occured */
    DPRAM_RET_ERR_INVALID_PARAM  = 2,        /* the input parameter is invalid */
    DPRAM_RET_ERR_NO_MEMORY         = 3,        /* no enough memory in dpram to store data of the required length */
    DPRAM_RET_ERR_NO_DATA                 = 4,        /* no data in ring */
    DPRAM_RET_ERR_NOT_INITIALIZED = 5,        /* not initialized yet */

    MAX_DPRAM_ERR_CODE
} T_ZDrvDpram_RetCode;

typedef enum
{
	DPRAM_DATA_UL_PHY,
	DPRAM_DATA_HSUPA,
	DPRAM_DATA_BCH,
	DPRAM_DATA_DL_PHY,
	DPRAM_DATA_HSDPA,
	DPRAM_DATA_EAGCH,

    MAX_DPRAM_DATA_ID
} T_ZDrvDpram_DataId;       //used for TD

/* will be invoked when command has been received
  uiCmdId: command id
  pData: command data
  uiLen: length of command data. unit: byte
  */

typedef enum
{
    DPRAM_MSG_CFNSFN = 0xFF,
    DPRAM_MSG_EXCEPT = 0xFE,

    MAX_DPRAM_OTHER_MSG
} T_ZDrvDpram_OtherMsg;  


typedef struct
{
    UINT32  uiCfn;
    UINT32  uiSubfn;
    UINT32  uiSfn;
    UINT32  uiRtCfn;
    UINT32  uiRtSfn;
} T_ZDrvDpram_CfnSfnForW;

typedef struct
{
    UINT32  uiMemBaseAddr;      /* base address of dpram memory */
    //UINT32  uiRegBaseAddr;        /* base address of doram register */
    UINT32  uiMemSize;                /* memroy size of dpram */
    BOOL     bBigEndian;               /* big-endian if true, else little-endian */
} T_ZDrvDpram_Info;      //used for TD

#if 0
typedef enum
{
    DPRAM_UPA_ADDR_1 , 
    DPRAM_UPA_ADDR_2 ,

    MAX_DPRAM_UPAAddr_ID
} T_ZDrvDpram_UPAAddrSel;
#endif

/*used by td*/		   
typedef enum
{
    ARMTOZSP_INT1 =0, /*in order to let sleep time tell zsp ,е0bit÷֪ͨϵͳ˯ʱ */
    ARMTOZSP_INT2 =1, /*е1bit÷֪ͨϵͳ˯ʱ,ЭջϢsendcmd mailboxжϻzsp*/
    ARMTOZSP_INT3 = 2,/*used in HSUPA*/
    ARMTOZSP_INT4 = 3, //ps wakeup phy
    MAX_ARMTOZSPINT   = 100

}T_ZDrvIcp_IntType;      //used for TD


typedef struct
{
    UINT32  uiCfn;
    UINT32  uiSfn;
} T_ZDrvDpram_CfnSfn;      //used for TD

typedef UINT32 (*ZDRV_DPRAM_CMD_RECVFUNC)(UINT16 uiCmdId, VOID *pData, UINT16 uiLen);

typedef struct
{
    ZDRV_DPRAM_CMD_RECVFUNC      fCmdRecv;
} T_ZDrvDpram_CallbackFuncs;     

typedef VOID (*ZDRV_DPRAM_ISR_CALLBACK)( VOID );    

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/**************************************************************************
* Functin: zDrvWDpram_RegCallback
* Description: This function is used to register the interrupt callback function.
* Parameters:
*       (IN)
*               ptCallbackStruct: callback functions struct pointer.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: failed.
* Others:
*       None.
**************************************************************************/
extern SINT32 zDrvWDpram_RegCallback(T_ZDrvDpram_CallbackFuncs *ptCallbackStruct );
/**************************************************************************
* Functin: zDrvDpram_SendCmdForW
* Description: This function is used to send command.
* Parameters:
*       (IN)
*               uiCmdId: cmd id.
*               pData: cmd data pointer
*               uiLen: cmd data length. uint: byte. must be multiples of 4. maybe 0 for null command
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no enough space to send this command.
* Others:
*       None.
**************************************************************************/
//extern UINT32 zDrvDpram_SendCmdForW( UINT16 uiCmdId, VOID *pData, UINT16 uiLen );
/**************************************************************************
* Functin: zDrvWDpram_FrameInfoGet
* Description: This function is used to get the frameinfo block.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
*               puiBlockLen: pointer to store length of databuf in block. uint: byte
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: unknow error
*       DPRAM_RET_ERR_NO_DATA: no  data.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_FrameInfoGet(VOID **ppBlockAddr, UINT32 *puiRealLen);
/**************************************************************************
* Functin: zDrvWDpram_FrameInfoFree
* Description: This function is used to free the frameinfo block.
* Parameters:
*       (IN)
*               pBlockAddr: pointer to store address of databuf in block.
*       (OUT)
*               None
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*      DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_FrameInfoFree(VOID *pBlockAddr);/*Ϊ˱Ƶд֡жϢ10msʱÿ֡֡жϢЧˣЭջڶ֡жϢ֡жϢڴ˺д*/
/**************************************************************************
* Functin: zDrvWDpram_UlDataGet
* Description: This function is used to get the free block of UL data.
* Parameters:
*       (IN)
*               None
*       (OUT)
*               pBlockAddr: pointer to store address of databuf in block.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: unknow error
*       DPRAM_RET_ERR_NO_MEMORY: no  free block.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UlDataGet(VOID **pBlockAddr);
/**************************************************************************
* Functin: zDrvWDpram_UlDataSend
* Description: This function is used to send ul data.
* Parameters:
*       (IN)
*               pBlockAddr: ul data pointer.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UlDataSend(VOID *pBlockAddr);
/**************************************************************************
* Functin: zDrvDpram_GetDlDataForW
* Description: This function is used to get dl data.
* Parameters:
*       (IN)
*               Ret: DPRAM_RET_W.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_DATA: no data.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvDpram_GetDlDataForW(VOID **ppBlockAddr, T_ZDrvDpram_Rat Rat);
/**************************************************************************
* Functin: zDrvWDpram_PsDlDataFree
* Description: This function is used to free the DL data block.
* Parameters:
*       (IN)
*               Ret: DPRAM_RET_W.
*               ppBlockAddr: pointer to store address of databuf in block.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_PsDlDataFree(VOID *pBlockAddr, T_ZDrvDpram_Rat Rat);
/**************************************************************************
* Functin: zDrvWDpram_UpaDataGet
* Description: This function is used to get the free block of upadata.
* Parameters:
*       (IN)
*               uiHARQId
*       (OUT)
*               ppBlockAddr: pointer to store address of upadata in block.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no  free block.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UpaDataGet(UINT8 uiHARQId, VOID **ppBlockAddr);
/**************************************************************************
* Functin: zDrvWDpram_UpaDataSend
* Description: This function is used to send upa data.
* Parameters:
*       (IN)
*               uiHARQId: harq id of upa data.
*               pBlockAddr:upa data pointer
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UpaDataSend(UINT8 uiHARQId, VOID *pBlockAddr);

#if 0
/**************************************************************************
* Functin: zDrvDpram_GetUpaPhyBufAddrForW
* Description: This function is used to get UPA buffer data of phy.
* Parameters:
*       (IN)
*               uiHARQId: harq id of upa data.
*               cho: 0 or 1
*       (OUT)
*               ppBlockAddr: pointer to store address of phy databuf .
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvDpram_GetUpaPhyBufAddrForW(UINT8 uiHARQId, VOID **ppBlockAddr, T_ZDrvDpram_UPAAddrSel addsel);

#endif
/**************************************************************************
* Functin: zDrvWDpram_GrantMonitorReqSend
* Description: This function is used to send GrantMonitor request.
* Parameters:
*       (IN)
*               pBlockAddr: address of GrantMonitor request.
*               uiLen:length of data
*       (OUT)
*               None.
* Returns:
*              DPRAM_RET_ERR_NO_MEMORY: PHY is processing
*              DPRAM_RET_SUCCESS: successed.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_GrantMonitorReqSend(VOID *pBlockAddr, UINT16 uiLen);

/**************************************************************************
* Functin: zDrvWDpram_UlDataFree
* Description: This function is used to get free data of UL.
* Parameters:
*       (IN)
*               pBlockAddr: address of UL.
*       (OUT)
*               None.
* Returns:
*              DPRAM_RET_ERR_NO_DATA: no data in this buf
*              DPRAM_RET_SUCCESS: successed.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UlDataFree(VOID *pBlockAddr);

/**************************************************************************
* Functin: zDrvWDpram_PsDlDataGet
* Description: This function is used to get free data of DL.
* Parameters:
*       (IN)
*               uiLen:length of data
*       (OUT)
*               ppBlockAddr: address of DL free data.
* Returns:
*              DPRAM_RET_ERR_NO_MEMORY: no free memory 
*              DPRAM_RET_SUCCESS: successed.
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_PsDlDataGet(VOID **ppBlockAddr, UINT16 uiLen);

/**************************************************************************
* Functin: zDrvWDpram_UpaDataFree
* Description: This function is used to send GrantMonitor request.
* Parameters:
*       (IN)
*               pBlockAddr: address of GrantMonitor request.
*               uiHARQId: id of harq
*       (OUT)
*               None.
* Returns:
*              DPRAM_RET_ERR_NO_DATA: no data in this buf
*              DPRAM_RET_SUCCESS: successed.
*              DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
extern UINT32 zDrvWDpram_UpaDataFree(UINT8 uiHARQId, VOID *pBlockAddr);

/*-------------------------used for TD---------------------------*/
/**************************************************************************
* Functin: zDrvTDpram_Initiate
* Description: This function is used to initialize dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERROR: error
*       DRV_ERR_NOT_SUPPORTED: this device don't support open operation.
*       others: others error code. for detailed information, please refer to the header file of hal layer
* Others:
*       None.
**************************************************************************/
SINT32 zDrvTDpram_Initiate( VOID );

/**************************************************************************
* Functin: zDrvTDpram_RegCallback
* Description: This function is used to register the interrupt callback function.
* Parameters:
*       (IN)
*               ptCallbackStruct: callback functions struct pointer.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERROR: failed.
* Others:
*       None.
**************************************************************************/
UINT32 zDrvTDpram_RegCallback( T_ZDrvDpram_CallbackFuncs *ptCallbackStruct );


/**************************************************************************
* Functin: zDrvDpram_SendCmd
* Description: This function is used to send command.
* Parameters:
*       (IN)
*               uiCmdId: cmd id.
*               pData: cmd data pointer
*               uiLen: cmd data length. uint: byte. must be multiples of 4. maybe 0 for null command
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no enough space to send this command.
* Others:
*       None.
**************************************************************************/
//UINT32  zDrvDpram_SendCmd( UINT16 uiCmdId, VOID *pData, UINT16 uiLen );


/**************************************************************************
* Functin: zDrvDpram_GetFreeData
* Description: This function is used to get the free block.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
*               puiBlockLen: pointer to store length of databuf in block. uint: byte
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no free data space.
* Others:
*       None.
**************************************************************************/
//UINT32 zDrvDpram_GetFreeData ( UINT8 uiDataId, VOID **ppBlockAddr, UINT16 *puiBlockLen );


/**************************************************************************
* Functin: zDrvDpram_SendData
* Description: This function is used to send data.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*               ppBlockAddr: base address of databuf in block.
*               uiDataLen: data length. uint: byte
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_MEMORY: no enough space to send this data.
* Others:
*       None.
**************************************************************************/
//UINT32 zDrvDpram_SendData( UINT8 uiDataId, VOID *ppBlockAddr, UINT16 uiDataLen );


/**************************************************************************
* Functin: zDrvDpram_DataExist
* Description: This function is used to check if there is data.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*       (OUT)
*               None.
* Returns:
*               TRUE: have data; FALSE: no data.
* Others:
*       None.
**************************************************************************/
//BOOL zDrvDpram_DataExist( UINT8 uiDataId );  /*zyj,20110330*/

/**************************************************************************
* Functin: zDrvDpram_GetData
* Description: This function is used to get data.
* Parameters:
*       (IN)
*               puiDataId: pointer to stord data id. T_ZDrvDpram_DataId.
*       (OUT)
*               ppBlockAddr: pointer to store address of databuf in block.
*               puiRealLen: pointer to store data length. uint: byte
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
*       DPRAM_RET_ERR_NO_DATA: no data.
* Others:
*       None.
**************************************************************************/
//UINT32 zDrvDpram_GetData( UINT8 uiDataId, VOID **ppBlockAddr, UINT16 *puiRealLen );

/**************************************************************************
* Functin: zDrvDpram_FreeData
* Description: This function is used to free the data block.
* Parameters:
*       (IN)
*               uiDataId: T_ZDrvDpram_DataId.
*               pBlockAddr: base address of databuf in block.
*       (OUT)
*               None.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
//UINT32 zDrvDpram_FreeData( UINT8 uiDataId, VOID *pBlockAddr );


/**************************************************************************
* Functin: zDrvTDpram_GetInfo
* Description: This function is used to get the dpram information, such as base address.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               ptInfo: information pointer.
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
UINT32 zDrvTDpram_GetInfo( T_ZDrvDpram_Info *ptInfo );

#if ((defined ( _CHIP_ZX297502)||defined ( _CHIP_ZX2975)||defined ( _CHIP_ZX2960_02B)||defined ( _CHIP_ZX2804)) && defined (_USE_DPRAM_ADDR_NEWSW))
/**************************************************************************
* Functin: zDrvTDpram_GetUPHValue
* Description: This function is used to get the UPH value in Dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       UINT16: 2 bytes UPH Value.
* Others:
*       None.
**************************************************************************/
UINT16 zDrvTDpram_GetUPHValue( VOID );


/**************************************************************************
* Functin: zDrvTDpram_GetSNPLValue
* Description: This function is used to get the SNPL value in Dpram.
* Parameters:
*       (IN)
*               None.
*       (OUT)
*               None.
* Returns:
*       UINT16: 2 bytes SNPL Value.
* Others:
*       None.
**************************************************************************/
UINT16 zDrvTDpram_GetSNPLValue( VOID );
#endif
/**************************************************************************
* Functin: zDrvDpram_IntGen
* Description: This function is used to send mailbox int to zsp
* Parameters:
*       (IN)
*               inttype
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
//SINT32 zDrvDpram_IntGen(UINT32  inttype);

#ifdef _USE_PSM

/**************************************************************************
* Functin: zDrvDpram_WakeUpUphy
* Description: This function is used to wakeup phy for ps
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
//extern VOID zDrvDpram_WakeUpUphy(VOID);//psphy

#endif


/**************************************************************************
* Functin: zDrvDpram_L1tqueueFlag
* Description: жzspǷΪУзmaibloxzspֱdpramΪ0xa
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/


//VOID zDrvDpram_L1tqueueFlag(VOID); /*ж2963 l1tϢǷϢ*/
/**************************************************************************
* Functin: zDrvDpram_ClerrL1tqueueFlag
* Description: This function is used to clear drx flag
* Parameters:
*       (IN)
*               no
*       (OUT)
*          no
* Returns:
*       DPRAM_RET_SUCCESS: successed.
*       DPRAM_RET_ERR_INVALID_PARAM: the input parameters are invalid
* Others:
*       None.
**************************************************************************/
//VOID zDrvDpram_ClearL1tqueueFlag(VOID); /*l1tϢǷб־λ*/

/**************************************************************************
* Functin: zDrvDpram_MsgExist
* Description: This function is used to check PS <-->TD buffer has msg.
* Parameters:
*		(IN)
*				None.
*		(OUT)
*				None.
* Returns:
*		TRUE:PS <-->TD has msg
*		FALSE:PS <-->TD no msg
* Others:
*		none
**************************************************************************/
//BOOL zDrvDpram_MsgExist(VOID);

/**************************************************************************
* Functin: zDrvDpram_MsgExistForW
* Description: This function is used to check WPS ->WPHY cmd ring buffer has msg.
* Parameters:
*		(IN)
*				None.
*		(OUT)
*				None.
* Returns:
*		TRUE:WPS ->WPHY has msg
*		FALSE:WPS <-->WPHY has no msg
* Others:
*		none
**************************************************************************/
//BOOL zDrvDpram_MsgExistForW(VOID);



#endif/*_FILENAME_H*/

