/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: drvs_l2cache.h
 * File Mark:  	
 * Description:  This file contains the interface to operate L2 cache 
 *               controller(L2C310) on zx297510 platform .
 * Others:        
 * Version:       V1.0
 * Author:        xuzhiguo
 * Date:          2013-11-11
 * History 1: 
 *    
 *********************************************************************************/
#ifndef _DRVS_L2CACHE_H
#define _DRVS_L2CACHE_H


/*********************************************************************************
* 	                         Include files
**********************************************************************************/

/*********************************************************************************
* 	                         Macros
**********************************************************************************/

/*********************************************************************************
* 	                         Type
**********************************************************************************/

/*********************************************************************************
 *                           Global  Variable                                                                             *
 *********************************************************************************/


/*********************************************************************************
* 	                         Global Function Prototypes
**********************************************************************************/

/*******************************************************************************
* Function:  zDrvL2x0_Sync
* Description: Drain the STB. Operation complete when all buffers, LRB, LFB, STB, 
*              and EB, are empty,
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Sync(void);

/*******************************************************************************
* Function:  zDrvL2x0_Flush_All
* Description: clean and invalidate entire L2 cache by way
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Flush_All(void);

/*******************************************************************************
* Function:  zDrvL2x0_Clean_All
* Description: clean entire L2 cache by way
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Clean_All(void);

/*******************************************************************************
* Function:  zDrvL2x0_Inv_All
* Description: invalidate entire L2 cache by way
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Inv_All(void);

/*******************************************************************************
* Function:  zDrvL2x0_Flush_Range
* Description: clean and invalidate L2 cache by line
* Parameters:
*   Input:
*		base: base physical address of space  needs to be flushed
*       size:  size of space  needs to be flushed
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Flush_Range(unsigned long base, unsigned long size);

/*******************************************************************************
* Function:  zDrvL2x0_Clean_Range
* Description: clean  L2 cache by line
* Parameters:
*   Input:
*		base: base physical  address of  space  needs to be cleaned
*       size:  size of space  needs to be cleaned
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done.
*******************************************************************************/
void zDrvL2x0_Clean_Range(unsigned long base, unsigned long size);

/*******************************************************************************
* Function:  zDrvL2x0_Inv_Range
* Description: invalidate  L2 cache by line
* Parameters:
*   Input:
*		base: base physical address of  space  needs to be invalidated
*       size:  size of space  needs to be invalidated
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done. 
*******************************************************************************/
void zDrvL2x0_Inv_Range(unsigned long base, unsigned long size);

/*******************************************************************************
* Function:  zDrvL2x0_Enable
* Description: enable l2 cache simply
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done.
*******************************************************************************/
void zDrvL2x0_Enable(void);

/*******************************************************************************
* Function:  zDrvL2x0_Disable
* Description: disable l2 cache simply
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  this fucntion can not be used when l2 cache is not initialized. 
*          if you use it, nothing would be done.
*          this function can not be used in complex case of operating L1 cache, 
*		   L2 cache and mmu.
*******************************************************************************/
void zDrvL2x0_Disable(void);

/*******************************************************************************
* Function:  zDrvL2x0_Initiate
* Description: Initiate l2 cache controller
* Parameters:
*   Input:
*		None
*   Outpu:  
*		None
* Returns:
* 		None
* Others:  None
*******************************************************************************/
void zDrvL2x0_Initiate(void);

#endif
