/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v0.1
 * Author:        shideyou
 * Date:          2013-6-29
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_LPM_H
#define _DRVS_LPM_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
//#include "drvs_general.h"
#include "drvs_dpram.h"


/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
 typedef enum
{
	LPM_RAT_TD,
	LPM_RAT_LTE,
	LPM_RAT_W,
	LPM_T4_RAT_TD,
	LPM_T4_RAT_W,
	LPM_T2_RAT_LTE,

    MAX_LPM_RAT
} T_ZDrvLpm_RAT;

typedef struct
{
    UINT16 wWFrmCnt;               /*0~4095 Fn*/
    UINT16 wWSlotCnt;              /*0~14 slot*/
    UINT16 wWSymbolCnt;            /*0~9 symbol*/
    UINT16 wWChipCnt;              /*0~255 chip*/
}T_WLpmTime;

typedef struct
{
    UINT16 wTdFrmCnt;               /*0~8191 Fn*/
    UINT16 wTdChipCnt;              /*0~6400 chip*/
}T_TdLpmTime;

typedef struct
{
    UINT16 wLteSuperFrmCnt;
    UINT16 wLteFrmCnt;
    UINT16 wLteSubFrmCnt;
}T_LteLpmTime;


typedef VOID (*T_ZDrvLpm_CallbackFunction)(VOID);   //used for LTE

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
 * Function: zDrvLpm_RegCallbackForLTE
 * Description: regist callback function for LTE_lpm interrupt
 * Parameters: 
 *   Input:
 *		callback: function be register
 *   Output:
 *		None
 * Returns: 
 *		DRV_ERROR:interrupt install failed
 *              Drv_SUCCESS:successful!
 *
 * Others: 
 ********************************************************************************/
SINT32 zDrvLpm_RegCallbackForLTE(T_ZDrvLpm_CallbackFunction callback);

/*******************************************************************************
 * Function: zDrvLpm_RegCallbackForTD
 * Description: regist callback function for TD_lpm interrupt
 * Parameters: 
 *   Input:
 *		callback: function be register
 *   Output:
 *		None
 * Returns: 
 *		DRV_ERROR:interrupt install failed
 *              Drv_SUCCESS:successful!
 *
 * Others: 
 ********************************************************************************/
 SINT32 zDrvLpm_RegCallbackForTD(T_ZDrvLpm_CallbackFunction callback);

 /*******************************************************************************
 * Function: zDrvLpm_RegCallbackForW
 * Description: regist callback function for W_lpm interrupt
 * Parameters: 
 *   Input:
 *		callback: function be register
 *   Output:
 *		None
 * Returns: 
 *		DRV_ERROR:interrupt install failed
 *              Drv_SUCCESS:successful!
 *
 * Others: 
 ********************************************************************************/
 SINT32 zDrvLpm_RegCallbackForW(T_ZDrvLpm_CallbackFunction callback);
/*******************************************************************************
 * Function: zDrvLpm_IrqEnable
 * Description: enable interrupt of lpm
 * Parameters: 
 *   Input:
 *		rat: TD/W/LTE
 *   Output:
 *		None
 * Returns: 
 *		None
 *
 * Others: 
 ********************************************************************************/
VOID zDrvLpm_IrqEnable(T_ZDrvLpm_RAT rat);

/*******************************************************************************
 * Function: zDrvLpm_IrqDisable
 * Description: disable interrupt of lpm
 * Parameters: 
 *   Input:
 *		rat: TD/W/LTE
 *   Output:
 *		None
 * Returns: 
 *		None
 *
 * Others: 
 ********************************************************************************/
VOID zDrvLpm_IrqDisable(T_ZDrvLpm_RAT rat);

/**************************************************************************
* ƣ lpm_WDpramSfnIsValid
*  ȡWDpram֡ϢǷЧ
* ˵ 
*   ֵ	 TRUE Ч FALSE Ч
* ˵
**************************************************************************/
BOOL  zDrvLpm_WDpramSfnIsValid(void);

/**************************************************************************
* ƣ Lpm_GetWCfnSfn
*  PSȡW֡ŵϢ
* ˵ 
*   ֵ	 
* ˵
**************************************************************************/
VOID  zDrvLpm_GetWCfnSfn(T_ZDrvDpram_CfnSfnForW*  ptCfnSfn);
/**************************************************************************
* ƣ zDrvLpm_GetSfn_Lte
*  PSȡLTE֡Ϣ
* ˵ 
*   ֵ	 
* ˵
**************************************************************************/
UINT32 zDrvLpm_GetSfn_Lte(VOID);

/**************************************************************************
* ƣ zDrvLpm_TdDpramSfnIsValid
*  ȡTdDpram֡ϢǷЧ
* ˵
*   ֵ   TRUE Ч FALSE Ч
* ˵
**************************************************************************/
BOOL  zDrvLpm_TdDpramSfnIsValid(void);

/**************************************************************************
* ƣ zDrvLpm_GetTdCfnSfn
*  PSȡTD֡ŵϢ
* ˵
*   ֵ   TD NT ֡\Cfn
* ˵
**************************************************************************/
VOID  zDrvLpm_GetTdCfnSfn(T_ZDrvDpram_CfnSfn*  ptTdCfnSfn);

#endif/*_FILENAME_H*/

