/*******************************************************************************
 * Copyright (C) 2016, ZTE Corporation.
 *
 * File Name:    drvs_pmic_addr.h
 * File Mark:    register addresses of pmic
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2016-01-27
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#ifndef _DRVS_PMIC_ADDR_H
#define _DRVS_PMIC_ADDR_H

#if defined(_USE_PMIC_ZX234290)

/////////////////////////////////////////////////
/*slave address 0x12*/
/////////////////////////////////////////////////
#define ZX234290_I2C_SLAVE_ADDR0   			(0x12)

/*	interrupt and mask */
#define ZX234290_REG_ADDR_INTA         		0x00    /* INTERRUPT */
#define ZX234290_REG_ADDR_INTB          	0x01
#define ZX234290_REG_ADDR_INTA_MASK    		0x02
#define ZX234290_REG_ADDR_INTB_MASK   		0x03

/* interrupt status	*/
#define ZX234290_REG_ADDR_STSA        		0x04
#define ZX234290_REG_ADDR_STSB       		0x05
#define ZX234290_REG_ADDR_STS_STARTUP  		0x06

/* adc & softon select	*/
#define ZX234290_REG_ADDR_SYS_CTRL        	0x07  /*0x8 0x9*/

/* bucks normal voltage and sleep voltage	*/
#define ZX234290_REG_ADDR_BUCK1_VOL        	0x0A  /*[00xx xxxx]0xB 0xC */
#define ZX234290_REG_ADDR_BUCK1_SLPVOL    	0x0D

/* bucks mode	*/
#define ZX234290_REG_ADDR_BUCK1_MODE        0x0E  	/* [xx] NRM [xx] SLP [00 00]*/
#define ZX234290_REG_ADDR_BUCK23_MODE       0x0F    /*[xx]BUCK3 NRM [xx]BUCK3 SLP [xx]BUCK2 NRM [xx]BUCK2 SLP*/
#define ZX234290_REG_ADDR_BUCK4_MODE       	0x11	/* [00 00] [xx] NRM [xx] SLP   0X10	*/

/* ldo normal voltage	*/
#define ZX234290_REG_ADDR_LDO12_VOL         0x12	/* [xxxx xxxx] */
#define ZX234290_REG_ADDR_LDO34_VOL         0x13
#define ZX234290_REG_ADDR_LDO56_VOL       	0x14
#define ZX234290_REG_ADDR_LDO78_VOL         0x15
#define ZX234290_REG_ADDR_LDO9_VOL          0x16    /* [xxxx 0000] */
#define ZX234290_REG_ADDR_LDO10_RTCLDO_VOL  0x17	/* [00 xx]VORTC [xx xx]LDO10*/


#define ZX234290_REG_ADDR_BUCK2_VOL        	0x1A	/* BUCK2 VLOT	*/

/* ldo sleep voltage	*/
#define ZX234290_REG_ADDR_LDO12_SLPVOL     	0x18	/* [xx xx]ldo2  [xx xx]ldo1*/
#define ZX234290_REG_ADDR_LDO3_SLPVOL       0x19	/* [00 00] [xx xx] */
#define ZX234290_REG_ADDR_LDO78_SLPVOL     	0x1B    /* [xx xx]ldo8  [xx xx]ldo7*/
#define ZX234290_REG_ADDR_LDO9_SLPVOL       0x1C    /* [xx xx] [00 00] */
#define ZX234290_REG_ADDR_LDO10_SLPVOL      0x1D    /* [00 00] [xx xx] */

/* ldo mode	*/
#define ZX234290_REG_ADDR_LDO1234_MODE   	0x1E    /* [xx][xx][xx][xx]*/
#define ZX234290_REG_ADDR_LDO5678_MODE      0x1F
#define ZX234290_REG_ADDR_LDO910_MODE       0x20	/* [00] [xx] [xx] [00] */

/* ldo enable	*/
#define ZX234290_REG_ADDR_LDO_EN1			0x21	/* LDO8-1 */
#define ZX234290_REG_ADDR_LDO_EN2			0x22	/* [xx xx]BUCK4-1, [0xx0]LDO10-9*/

/* adc code	*/
#define ZX234290_REG_ADDR_VBATADC_MSB		0x23    /*[xxxx xxxx]*/
#define ZX234290_REG_ADDR_VBATADC_LSB		0x24    /*[xxxx 0000]*/
#define ZX234290_REG_ADDR_ADC1_MSB			0x25
#define ZX234290_REG_ADDR_ADC1_LSB			0x26
#define ZX234290_REG_ADDR_ADC2_MSB			0x27
#define ZX234290_REG_ADDR_ADC2_LSB			0x28

/* rtc */
#define ZX234290_REG_ADDR_RTC_CTRL1			0x30
#define ZX234290_REG_ADDR_RTC_CTRL2			0x31

/* date and time */
#define ZX234290_REG_ADDR_SECONDS         	0x32
#define ZX234290_REG_ADDR_MINUTES         	0x33
#define ZX234290_REG_ADDR_HOURS           	0x34
#define ZX234290_REG_ADDR_DAY             	0x35
#define ZX234290_REG_ADDR_WEEK            	0x36
#define ZX234290_REG_ADDR_MONTH           	0x37
#define ZX234290_REG_ADDR_YEAR            	0x38

/* alarm */
#define ZX234290_REG_ADDR_ALARM_MINUTE      0x39
#define ZX234290_REG_ADDR_ALARM_HOUR  		0x3A
#define ZX234290_REG_ADDR_ALARM_DAY        	0x3B
#define ZX234290_REG_ADDR_ALARM_WEEK      	0x3C
#define ZX234290_REG_ADDR_ALARM_SECOND     	0x3D

#define ZX234290_REG_ADDR_TIMER_CTRL		0x3E
#define ZX234290_REG_ADDR_TIMER_CNT			0x3F

/* enable ldo output discharge resistance */
#define ZX234290_REG_ADDR_EN_DISCH1			0x40
#define ZX234290_REG_ADDR_EN_DISCH2			0x41

/* power key control */
#define ZX234290_REG_ADDR_PWRKEY_CONTROL1	0x42
#define ZX234290_REG_ADDR_PWRKEY_CONTROL2   0x43

#define ZX234290_REG_ADDR_VERSION           0x44

/*fault status*/
#define ZX234290_REG_ADDR_BUCK_FAULT_STATUS 0x45
#define ZX234290_REG_ADDR_LDO_FAULT_STATUS  0x46

#define ZX234290_REG_ADDR_BUCK_INT_MASK     0x47
#define ZX234290_REG_ADDR_LDO_INT_MASK      0x48

#define ZX234290_REG_ADDR_USER_RESERVED     0x50

#define ZX234290_REG_ADDR_GMT_TESTING       0xf1

#endif

#endif
