/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       0.1
 * Author:        zhangdongdong
 * Date:          2015-10-21
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_RPMSG_H
#define _DRVS_RPMSG_H

/*******************************************************************************
*                                  Include files                               *
*******************************************************************************/
#include "ram_config.h"

/*******************************************************************************
*                                  Macro                                       *
*******************************************************************************/
#define RPMSG_WRITE_INT  	 (0x1)       
#define RPMSG_READ_POLL 	 (0x1<<1)

#define CHANNEL_FLAG          0x1

#define M0AP_CHANNEL_MAXID    10
/*******************************************************************************
*                                  Types                                       *
*******************************************************************************/

/*-----------------------[Begin] [used  by normal]-----------------------------*/
/*channels definition*/
#define DRIVER              channel_0
#define PSM                   channel_1
#define USB_ADB           channel_2


#define WAN1                channel_3
#define WAN2                channel_4
#define WAN3                channel_5
#define WAN4                channel_6

#define DTMF     			channel_7
#define DEV_BUFFREE         channel_8

#define AMT                 channel_9
#define RAMDUMP             channel_10

#define VSIM                channel_11
#define ISMS                channel_12

#define IPSEC1            channel_13
#define IPSEC2            channel_14
#define IPSEC3            channel_15
#define IPSEC4            channel_16


typedef enum _T_ZDrvRpMsg_MsgActor
{
#ifdef _OS_TOS
    ICP_MSG_ACTOR_A9,
#endif
    ICP_MSG_ACTOR_ZSP,
    ICP_RPMSG_ACTOR_M0,
    MAX_RPMSG_ACTOR
} T_ZDrvRpMsg_MsgActor;

typedef enum _T_ZDrvRpMsg_ChID
{
    CHANNEL_BASEID,

    channel_0 = CHANNEL_BASEID,    //driver     just for AP<->PS
    channel_1,             		   //PSM
    channel_2,					  //USB_DETCT
    channel_3,					  //USB_ADB
    channel_4,					 //WAN
    channel_5,					 //LAN1
    channel_6,					 //LAN2
    channel_7,					//DEV_BUFMALLOC
    channel_8,					//DEV_BUFFREE
    channel_9,					//AT
    CHANNEL_PS2M0_MAXID,
    
    channel_10 = CHANNEL_PS2M0_MAXID,				    //AMT
    channel_11,				    //LOG
    channel_12,                                //FOTA

	channel_13,
	channel_14,
	channel_15,
	channel_16,
	channel_17,
	channel_18,
	channel_19,
	channel_20,
	channel_21,
	channel_22,
	channel_23,
	channel_24,
	channel_25,
	channel_26,
	channel_27,
	channel_28,
	channel_29,
	channel_30,
	channel_31,
	channel_32,
	channel_33,
	channel_34,
	channel_35,
	channel_36,
	channel_37,
	channel_38,
	channel_39,
	channel_40,
	channel_41,
	channel_42,
	channel_43,
	channel_44,
	channel_45,
	channel_46,
	channel_47,
	channel_48,
	channel_49,
	channel_50,
	channel_51,
	channel_52,
	channel_53,
	channel_54,
	channel_55,
	channel_56,
	channel_57,
	channel_58,
	channel_59,
	channel_60,
	channel_61,
	channel_62,
	channel_63,
	
    PSAP_CHANNEL_MAXID
}T_ZDrvRpMsg_ChID;

typedef struct _T_ZDrvRpMsg_Msg
{
    T_ZDrvRpMsg_MsgActor actorID;
    T_ZDrvRpMsg_ChID     chID;
    UINT32 flag;        /*bit0:is need send icp int    1:y; 0:n*/
    				   /*bit1: read mode    1:poll; 0:semaphore*/
    VOID  *buf;
    UINT32 len;
} T_ZDrvRpMsg_Msg;

typedef enum _T_ZDrvRpMsg_ErrCode
{
    RPMSG_INVALID_PARAMETER = -101,			//ȷ
    RPMSG_SPACE_NOT_ENOUGH = -102,			//ռ䲻㹻
    RPMSG_CHANNEL_ALREADY_EXIST = -103,		//ͨѾ
    RPMSG_CHANNEL_INEXISTANCE = -104,		//ͨ
    RPMSG_CHANNEL_MSG_ERR = -105,			//ͨϢ
    RPMSG_CHANNEL_NOMSG = -107,				//ͨûϢ
}
T_ZDrvRpMsg_ErrCode;

typedef VOID (*T_ZDrvRpMsg_CallbackFunction)(VOID *buf, UINT32 len);/*for normal*/

/*******************************************************************************
*                           Function Prototypes                                *
*******************************************************************************/

/*******************************************************************************
* Function: zDrvRpMsg_CreateChannel
* Description: This function is used for create channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       size: size of channel
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   DRV_ERROR: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_CreateChannel (T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, UINT32 size);

/*******************************************************************************
* Function: zDrvRpMsg_RegCallBack
* Description: This function is used for registing callback functions;
* Parameters:
*   Input:
*       actor:  core id.
*       chID  : channel id
*       callback: callback function
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, T_ZDrvRpMsg_CallbackFunction callback);

/*******************************************************************************
* Function: zDrvRpMsg_MaskInt
* Description: This function is used for mask ICP interrupt from another core;
* Parameters:
*   Input:
*       actor: which core.
*       bit_map: which interrupts will be masked.
*   Output:None
*
* Returns:
*   None
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_MaskInt(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID);

/*******************************************************************************
* Function: zDrvRpMsg_UnmaskInt
* Description: This function is used for unmask ICP interrupt from another core;
* Parameters:
*   Input:
*       actor: which core.
*       bit_map: which interrupts will be unmasked.
*   Output:None
*
* Returns:
*   None
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_UnmaskInt(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID);

/*******************************************************************************
* Function: zDrvRpMsg_Write
* Description: This function is used for sending message to remote cpu, mutex;
* Parameters:
*   Input:
*       pMsg: the msg which will be sent
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully send msg.
*   other: fail to send msg.
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_WriteWithId
* Description: This function is used for ps&phy to send msg to remote cpu.
* Parameters:
*   Input:
*       msgId:msg id that ps will put into the ring buffer
*       pMsg: the msg which will be sent
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully send msg.
*   other: fail to send msg.
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_WriteWithId(UINT32 msgId, const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_WriteLockIrq
* Description: This function is used for sending message to remote cpu, no mutex;
* Parameters:
*   Input:
*       pMsg: the msg which will be sent
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully send msg.
*   other: fail to send msg.
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_Read
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read
*   Output:
*       pMsg
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_Read(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_ReadWithId
* Description: This function is used for ps&phy to read message from remote cpu;
* Parameters:
*   Input:
*       pMsgId:msg id that ps will get from the ring buffer
*       pMsg:message which will be read
*   Output:
*       pMsg
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_ReadWithId(UINT32 *pMsgId, const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_ReadWithIdLockIrq
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsgId:msg id that ps will get from the ring buffer
*       pMsg:message which will be read
*   Output:
*       pMsg
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_ReadWithIdLockIrq(UINT32 *pMsgId, const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_ReadLockIrq
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read
*   Output:
*       pMsg
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_ChIsEmpty
* Description: This function is used for checking the channel used to receive message is empty or not;
* Parameters:
*   Input:
*        actorID:remote cpu
*        chID:channel id
*   Output:None
*
* Returns:
*        TRUE: channel is empty .
*        FALSE: channel is not empty .
*
* Others:
********************************************************************************/
BOOL zDrvRpMsg_ChIsEmpty(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID);

/*******************************************************************************
* Function: zDrvRpMsg_WriteChIsEmpty
* Description: This function is used for checking the channel used to send message is empty or not;
* Parameters:
*   Input:
*        actorID:remote cpu
*        chID:channel id
*   Output:None
*
* Returns:
*        TRUE: channel is empty .
*        FALSE: channel is not empty .
*
* Others:
********************************************************************************/
BOOL zDrvRpMsg_WriteChIsEmpty(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID);

/*******************************************************************************
* Function: zDrvRpMsg_CreateBlock
* Description: This function is used for create block channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       blkSize: size of block, 4 bytes reserve at leaset 
*       blkNums: numbers of block
*       memtype: 0:iram   1:ddr
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   DRV_ERROR: fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_CreateBlock(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, UINT32 blkSize, UINT32 blkNums, UINT32 memType);

/*******************************************************************************
* Function: zDrvRpMsg_GetWriteAddr
* Description: This function is used for getting write addr;
* Parameters:
*   Input:
*       actorID:remote processor id
*	 chID:channel id
*   Output:
*       wrAddr:addr for write
*
* Returns:
*   positive:  success
*   negative:  fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_GetWriteAddr(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, VOID **wrAddr);

/*******************************************************************************
* Function: zDrvRpMsg_WriteUpdate
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       actorID:remote processor id
*		chID:channel id
*       addr:addr for update
*       len:update len
*       intFlag: 0:without icp int   1:with icp int
*   Output:
*       NULL
*
* Returns:
*   positive:  len
*   negative:  fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_WriteUpdate(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, UINT32 addr, UINT32 len, BOOL intFlag);

/*******************************************************************************
* Function: zDrvRpMsg_GetReadAddr
* Description: This function is used for getting read addr;
* Parameters:
*   Input:
*       actorID:remote processor id
*	 chID:channel id
*   Output:
*       rdAddr:addr for read
*
* Returns:
*   positive:  len
*   negative:  fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_GetReadAddr(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, VOID **rdAddr);

/*******************************************************************************
* Function: zDrvRpMsg_ReadUpdate
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       actorID:remote processor id
*		chID:channel id
*       addr:update addr
*   Output:
*       NULL
*
* Returns:
*   positive:  len
*   negative:  fail .
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_ReadUpdate(T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, UINT32 addr);

/*******************************************************************************
* Function: zDrvRpMsg_Initiate
* Description: This function is used to init rpmsg module;
* Parameters:
*   Input:
*       null
*       
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   other: fail .
*
*
* Others:
********************************************************************************/
SINT32 zDrvRpMsg_Initiate (VOID);

/*******************************************************************************
* Function: zDrvRpMsg_ReadExit
* Description: This function is used to exit from the block read func,for ctrm;
* Parameters:
*   Input:
*       null
*       
*   Output:None
*
* Returns:
*   null .
*   
*
*
* Others:
********************************************************************************/
VOID zDrvRpMsg_ReadExit(T_ZDrvRpMsg_MsgActor actor, T_ZDrvRpMsg_ChID chID);

#endif
