/***********************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name: 	drvs_config.h
* File Mark:
* Description:  drv configurate declaration.
* Others:
* Version:  v1.0
* Author:   geanfeng
* Date:     2013-04-03

**********************************************************************/
#ifndef    _DRVS_CONFIG_H_
#define    _DRVS_CONFIG_H_


/*************************************************************************
*                            Include files                                                                         *
*************************************************************************/

/****************************************************************************
* 	                         Base Type
****************************************************************************/
#define DRV_CONFIG(x)  DRV_CONFIG_##x

#ifdef DRV_CONFIG_C_DEFINE
#define DRV_CONFIG_DEFINE(x)  int DRV_CONFIG_##x;
#else
#ifdef DRV_CONFIG_WRITE_ENABLE
#define DRV_CONFIG_DEFINE(x)  extern int DRV_CONFIG_##x;
#else
#define DRV_CONFIG_DEFINE(x)  extern const int DRV_CONFIG_##x;
#endif
#endif
/**************************************************************************
*                            Types                                                                                   *
**************************************************************************/
/*
* INT
*/


/*
* TIMER
*/

/*
* USB
*/
DRV_CONFIG_DEFINE(USB_HIGHSPEED)
DRV_CONFIG_DEFINE(USB_VNIC_HALF_DL_BUFF_CNT)
DRV_CONFIG_DEFINE(USB_IP_4BYTE_ALIGNMENT)
DRV_CONFIG_DEFINE(USB_VNIC_ADJUST_MAXPKTNUM)

/*
* I2C
*/
DRV_CONFIG_DEFINE(USE_PMIC_I2C)
DRV_CONFIG_DEFINE(USE_I2C0)
DRV_CONFIG_DEFINE(USE_I2C1)

/*
* FLASH TYPE
*/
DRV_CONFIG_DEFINE(USE_NAND)
DRV_CONFIG_DEFINE(USE_SPI_NAND)
DRV_CONFIG_DEFINE(USE_MMC)
DRV_CONFIG_DEFINE(USE_PART)

/*
* UART 
*/
DRV_CONFIG_DEFINE(USE_UART_AUTOBAUD)
/**************************************************************************
*                            Global  Variable                                                                             *
**************************************************************************/

/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
 /****************************************************************************
 * Function:   zDrvConfig_Initiate
 * Description: initialize drv configuration;
 * Parameters:
 *   Input:
 *   Output:
 *
 * Returns:
 *     SINT32
 *
 * Others:
 ***************************************************************************/
SINT32 zDrvConfig_Initiate(VOID);

#endif    /*_DRVS_CONFIG_H_*/
