/*******************************************************************************
 * Copyright (C) 2008, ZTE Corporation.
 *
 * File Name:    drvs_ring.h
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        qinxiao
 * Date:          2009-09-03
 * History 1:   created
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
  ********************************************************************************/
#ifndef DRVS_RING_H
#define DRVS_RING_H

#ifdef __cplusplus
   extern "C"
   {
#endif 

/****************************************************************************
* 	                        Include files
****************************************************************************/

/****************************************************************************
* 	                         Macros
****************************************************************************/

/****************************************************************************
* 	                         Types
****************************************************************************/
typedef struct _T_Hal_Ring
{
	UINT32 writePos;    /* offset from start of buffer where to write next */
	UINT32 readPos;	    /* offset from start of buffer where to read next */
	UINT32 bufSize;		/* size of ring in bytes */
	UINT8 *pBuf;			/* pointer to start of buffer */
}T_Hal_Ring;

/****************************************************************************
* 	                         Constants
****************************************************************************/

/****************************************************************************
* 	                         Global  Variables
****************************************************************************/

/****************************************************************************
* 	                         Function Prototypes
****************************************************************************/
/******************************************************************************
 * Function:	hal_RingIsEmpty
 * Description:		жϻλǷΪ
 * Parameters:
 *   Input:
 *			pRing - :λָ
 *   Output:
 *			None
 * Returns:
 *			:TRUE; ǿ:FALSE
 *
 * Others:
 ******************************************************************************/
BOOL hal_RingIsEmpty( T_Hal_Ring *pRing);

/******************************************************************************
 * Function:	hal_RingIsFull
 * Description:		жϻλǷ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			:TRUE; :FALSE
 *
 * Others:
 ******************************************************************************/
BOOL hal_RingIsFull(T_Hal_Ring *pRing);

/******************************************************************************
 * Function:	hal_RingCreate
 * Description:		λ
 * Parameters:
 *   Input:
 *			nbytes -- λĴСλֽ
 *   Output:
 *			None
 * Returns:
 *			ɹλID; ʧ:hal_NULL
 *
 * Others:
 ******************************************************************************/
T_Hal_Ring *hal_RingCreate(UINT32 nBytes);

/******************************************************************************
 * Function:	hal_RingDelete
 * Description:		ɾλ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			None
 *
 * Others:
 ******************************************************************************/
VOID hal_RingDelete(T_Hal_Ring * pRing);

/******************************************************************************
 * Function:	hal_RingRead
 * Description:		ȡλе
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *			pBuffer -- ָ	  
 *			maxbytes -- Ҫȡֽ
 *   Output:
 *			buffer -- ָ	
 * Returns:
 *			ʵʶȡֽ
 *
 * Others: ֵҪȡֽһ¡Ϊգ򷵻0.
 ******************************************************************************/
UINT32 hal_RingRead(T_Hal_Ring *pRing, UINT8 *pBuffer, UINT32 maxBytes);

/******************************************************************************
 * Function:	hal_RingWrite
 * Description:	λд
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *			pBuffer -- ָ	  
 *			nBytes -- дݵĴС
 *   Output:
 *			None
 * Returns:
 *			ʵдֽ
 *
 * Others: ֵҪдֽһ¡Ϊ򷵻0.
 ******************************************************************************/
UINT32 hal_RingWrite(T_Hal_Ring * pRing, UINT8 *pBuffer, UINT32 nBytes);

/******************************************************************************
 * Function:	hal_RingFreeBytes
 * Description:	ȡλʣֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			ʣÿռֽ
 *
 * Others: 
 ******************************************************************************/
UINT32 hal_RingFreeBytes(T_Hal_Ring *pRing);
 
/******************************************************************************
 * Function:	hal_RingUsedBytes
 * Description:	ȡλʹõֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *			ʹõֽ
 *
 * Others: 
 ******************************************************************************/
UINT32 hal_RingUsedBytes(T_Hal_Ring *pRing);
 
/******************************************************************************
 * Function:	hal_RingFlush
 * Description:	λ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: 
 ******************************************************************************/
VOID hal_RingFlush(T_Hal_Ring * pRing);
#if 0
/******************************************************************************
 * Function:	hal_RingMoveAhead
 * Description:	λдָƶֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *          nBytes -- Ҫƶֽ,ǰƶƶ
 *                    Χ:-λֽ-- +λֽ
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: дָ볬󳤶ʱԶ.
 ******************************************************************************/
VOID hal_RingMoveWritePos(T_Hal_Ring * pRing, SINT32 nBytes);
 
/******************************************************************************
 * Function:	hal_RingMoveAhead
 * Description:	λ嵱ǰдָƫƴдһ
 *              ƶдָ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *          byte:д
 *          offset -- ƫ, ǰƶ, ƶ;
 *                    Χ:-λֽ-- +λֽ,
 *   Output:
 *			None
 * Returns:
 *          None
 * Others: дָ볬󳤶ʱԶ.
 ******************************************************************************/
VOID hal_RingPutAhead(T_Hal_Ring * pRing, UINT8 byte, SINT32 offset);

/******************************************************************************
 * Function:	hal_RingGetPossibleReadBlock
 * Description:	ȡλɶȡָֽ
 * Parameters:
 *   Input:
 *			pRing -- λָ
 *   Output:
 *			nBytes -- ɶȡֽ
 *          UINT8 * -- bufferָ
 * Returns:
 *			ʹõֽ
 *
 * Others: 
 ******************************************************************************/
UINT8 *hal_RingGetPossibleReadBlock(T_Hal_Ring * pRing, UINT32 *nBytes);

VOID hal_RingMoveReadPos(T_Hal_Ring * pRing, SINT32 nBytes);
#endif

#ifdef __cplusplus
}
#endif

#endif

