/*****************************************************************************
** Ȩ (C)2015, ͨѶɷ޹˾
** 
** ļ:     alsa_voice.c
** ļʶ:     
** ժҪ:    
** ʹ÷:     
** 
** ޸        汾      ޸ı        ޸          ޸
** -----------------------------------------------------------------------------
** 2019/09/25     V1.0        Create          xxq        
** 
* ******************************************************************************/
#ifdef _USE_VOICE_ALSA

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <stdint.h>
//#include "volte_drv.h"
#include <sys/ioctl.h>
#include <fcntl.h>
#include <tinyalsa/audio_mixer_ctrl.h>



#include <stdbool.h> 
#include "tinyalsa/asoundlib.h"
#include "tinyalsa/audio_mixer_ctrl.h"
//#include "audio_res_ctrl.h"
#include "voice_lib.h"


/**************************************************************************
*                        궨                                           *
**************************************************************************/

//#define AVOICE_TEAK_2G_3G_DEV_NUM 3
//#define AVOICE_SOFT_3G_DEV_NUM 4
//#define AVOICE_4G_DEV_NUM 2
//#define AVOICE_5G_DEV_NUM 2

/**************************************************************************
*                        Ͷ                                         *
**************************************************************************/
/*
typedef enum
{
    AVOICE_TEAK_2G_3G = 0,     
    AVOICE_SOFT_3G_NB,//1
    AVOICE_SOFT_3G_WB, //2   
    AVOICE_4G_NB, //3                 
    AVOICE_4G_WB, //4
    AVOICE_5G_NB,//5    
    AVOICE_5G_WB,//6      
    MAX_AVOICE_MODE               
}T_Alsa_Voice_Mode;
*/


/**************************************************************************
*                        ֲԭ                                 *
**************************************************************************/

/**********************************************************************************/
/**********************************************************************************/
/**********************************************************************************/

/**********************************************************************************/
/**************************************************************************
*                          ̬ȫֱ                                   *
**************************************************************************/


/**************************************************************************
*                            ȫֺ                                     *
**************************************************************************/


/**************************************************************************
*                            ֲ                                     *
**************************************************************************/


/****************************************************************************************************/
/* start for testing  ctm*/

/* data type for voice device  handle */

struct voice_handle
{
    struct pcm  *pcm_voice_out;
    struct pcm  *pcm_voice_in;
};

/* static  handle */
static struct voice_handle voice_handle = {0};

static int current_chanl = T_OUTPUT_RECEIVER;//T_OUTPUT_HEADSET;//T_OUTPUT_RECEIVER;
static int current_vol = T_VOICE_VOL_5_LEVEL;
static int dev_num = 1;
static int current_mode = MAX_AVOICE_MODE;
char* vocie_mode[]={"AVOICE_TEAK_2G_3G","AVOICE_SOFT_3G_NB","AVOICE_SOFT_3G_WB","AVOICE_4G_NB","AVOICE_4G_WB","AVOICE_5G_NB","AVOICE_5G_WB"};

/*
 * phone call   
 */
int alsa_voice_open(int vmode)
{
    int ret = 0;
	//int status = 0;
    struct pcm_config config_voice = {0};
    struct mxier *voice_mixer = NULL;
	
	printf( "%s: start vocie_mode(%d) %s, current_mode=%d!\n",__func__,vmode,vocie_mode[vmode],current_mode);

    if(vmode >= MAX_AVOICE_MODE||vmode < AVOICE_TEAK_2G_3G)
	{
		printf("alsa_voice_open: mode not support fail!\n");
		return -2;
	
	}
    /* open mixer dev for codec control */
    if(!(voice_mixer = mixer_open(0))) 
       printf("mixer open fail, file(%s), line(%d)\n", __FILE__, __LINE__);


	if(T_OUTPUT_SPEAKER == current_chanl) {
		mix_set_voice_path(voice_mixer,T_OUTPUT_SPEAKER);
		
		printf("chanl SPEAKER: mix_set_voice_path ret=%d!\n",ret);
		mix_set_voice_vol(voice_mixer,T_VOICE_VOL_5_LEVEL);
		
	    printf("chanl SPEAKER: mix_set_voice_vol ret=%d!\n",ret);
	}
	else if (T_OUTPUT_RECEIVER == current_chanl){
		mix_set_voice_path(voice_mixer, T_OUTPUT_RECEIVER);
		
		printf("chanl RECEIVER: mix_set_voice_path ret=%d!\n",ret);
		mix_set_voice_vol(voice_mixer,T_VOICE_VOL_5_LEVEL);
		
	    printf("chanl RECEIVER: mix_set_voice_vol ret=%d!\n",ret);
	}
	else if (T_OUTPUT_HEADSET == current_chanl){
		
		ret= mix_set_voice_path(voice_mixer, T_OUTPUT_HEADSET);
		
	    printf("chanl HEADSET: mix_set_voice_path ret=%d!\n",ret);
		ret = mix_set_voice_vol(voice_mixer,T_VOICE_VOL_5_LEVEL);
	    printf("chanl HEADSET: mix_set_voice_vol ret=%d!\n",ret);
		
	}	
	else
	{
		printf("alsa_voice_open: chanl not support fail!\n");
		return -2;

	}

    /*close mixer */
    mixer_close(voice_mixer);
    
    /* open pcm dev for data tranf*/
    config_voice.channels = 1; /* one channel */ 
    config_voice.rate = 8000;  /* 8K rate */ 
    config_voice.period_count = 3; /* buffer num */
    config_voice.period_size = 640; /* buffer size */
    config_voice.format = PCM_FORMAT_S16_LE; /* 16-bit signed */
    if(vmode == AVOICE_TEAK_2G_3G)
    {
         dev_num = AVOICE_TEAK_2G_3G_DEV_NUM;
		 config_voice.rate = 8000;  /* 8K rate */ 
    }
	else if(vmode == AVOICE_SOFT_3G_NB)
    {
         dev_num = AVOICE_SOFT_3G_DEV_NUM;
		 config_voice.rate = 8000;  /* 8K rate */  
    }
	else if(vmode == AVOICE_SOFT_3G_WB)
    {
         dev_num = AVOICE_SOFT_3G_DEV_NUM;
		 config_voice.rate = 16000;  /* 16K rate */  
    }
	else if(vmode == AVOICE_4G_NB)
    {
         dev_num = AVOICE_4G_DEV_NUM;
		 config_voice.rate = 8000;  /* 8K rate */  
    }
	else if(vmode == AVOICE_4G_WB)
    {
         dev_num = AVOICE_4G_DEV_NUM;
		 config_voice.rate = 16000;  /* 16K rate */  
    }
	else if(vmode == AVOICE_5G_NB)
    {
         dev_num = AVOICE_5G_DEV_NUM;
		 config_voice.rate = 8000;  /* 8K rate */  
    }
	else if(vmode == AVOICE_5G_WB)
    {
         dev_num = AVOICE_5G_DEV_NUM;
		 config_voice.rate = 16000;  /* 16K rate */  
    }
	else
	{
		printf("alsa_voice_open: mode not support fail!\n");
		return -2;
	
	}


    if(!(voice_handle.pcm_voice_out = pcm_open(0, dev_num, PCM_OUT, &config_voice))) 
		printf("pcm_out dev_num=%d open fail, file(%s), line(%d)\n",dev_num, __FILE__, __LINE__);
	
	printf("%s:pcm_open pcm_voice_out dev_num=%d end!\n",__func__,dev_num);
		
    if(!(voice_handle.pcm_voice_in = pcm_open(0,dev_num,PCM_IN, &config_voice))) 
		printf("pcm_in open dev_num=%d fail, file(%s), line(%d)\n",dev_num, __FILE__, __LINE__);
	
	printf("%s:pcm_open pcm_voice_in dev_num=%d end!\n",__func__,dev_num);
       
    if(0 != pcm_prepare(voice_handle.pcm_voice_out)) 
    	printf("pcm_out dev_num=%d prepare fail, file(%s), line(%d)\n",dev_num, __FILE__, __LINE__);
	
	printf("%s: pcm_voice_out pcm_prepare dev_num=%d end!\n",__func__,dev_num);
		
    if(0 != pcm_prepare(voice_handle.pcm_voice_in))
   		printf("pcm_in dev_num=%d prepare fail, file(%s), line(%d)\n",dev_num, __FILE__, __LINE__);

	
	printf("%s: pcm_voice_in pcm_prepare vmode=%d dev_num=%d end!\n",__func__,vmode,dev_num);
    current_mode = vmode;
	printf("%s: end!\n",__func__); 
	
    return 0;
}

int alsa_voice_close(int vmode)
{
    int ret = 0;
	printf("%s: start!\n",__func__); 

    if(vmode >= MAX_AVOICE_MODE||vmode < AVOICE_TEAK_2G_3G)
	{
		printf("alsa_voice_close: mode not support fail!\n");
		return -2;
	
	}

if(voice_handle.pcm_voice_in) {
	ret = pcm_close(voice_handle.pcm_voice_in);
	voice_handle.pcm_voice_in = 0;

	printf("pcm_close pcm_voice_in	ret=%d!\n",ret);
}

if(voice_handle.pcm_voice_out) {
	ret = pcm_close(voice_handle.pcm_voice_out);
	voice_handle.pcm_voice_out = 0;

	printf("pcm_close pcm_voice_out  ret=%d!\n",ret);
}





	current_mode = MAX_AVOICE_MODE;
	printf("%s: end!\n",__func__); 
	
    return ret; 
}



#endif
