#ifdef USE_CAP_SUPPORT
#include "message.h"

#define VOICEIPC_OK 0
#define VOICEIPC_ERROR -1
#define VOICE_WAIT_MSG_FROM_CAP -2 //waitting msg from cap

#define VOICE_IPC_CONTROL_CHANNEL "/dev/rpmsg6"
#define VOICE_IPC_CONTROL_CHANNEL_SIZE 256

#define VOICE_HEAD_LEN (2 * sizeof(int))
#define VOICE_CONTROL_MAX_LEN 32

enum  voice_ipc_func_type{
	IPC_SET_VOICE_DEVICE_MODE = 0,
    IPC_GET_VOICE_DEVICE_MODE = 1,
    IPC_SET_RX_VOICE_VOL = 2,
    IPC_GET_RX_VOICE_VOL = 3,
    IPC_SET_TX_VOICE_VOL = 4,
    IPC_GET_TX_VOICE_VOL = 5,
    IPC_SET_TX_VOICE_MUTE_STATE = 6,
    IPC_GET_TX_VOICE_MUTE_STATE = 7,
    IPC_SET_RX_VOICE_MUTE_STATE = 8,
    IPC_GET_RX_VOICE_MUTE_STATE = 9,
    IPC_SET_LOOPBACK_ENABLE_STATE = 10,
    IPC_GET_LOOPBACK_ENABLE_STATE = 11,
    IPC_AP_ALSA_VOICE_OPEN = 12,
    IPC_AP_ALSA_VOICE_CLOSE = 13,
    IPC_CAP_ALSA_VOICE_OPEN = 14,
    IPC_CAP_ALSA_VOICE_CLOSE = 15,

    IPC_VOICE_FUNC_MAX
};

enum  voice_msg_cmd{
    MSG_CMD_CAP_VALSA_OPEN = MSG_CMD_VOICE_BASE + 0x0, //37070
    MSG_CMD_CAP_VALSA_CLOSE
};

typedef struct{
    int func_id;
    int param_len;
    unsigned char param[VOICE_CONTROL_MAX_LEN];
}voice_ipc_control_msg;

//msg
int cap_alsa_voice_open(int vmode);
int cap_alsa_voice_close(int vmode);
int recv_msg_proc(MSG_BUF msg);
void recv_cap_voice_alsa(void);

//voice ipc interface
int voice_ipc_init(void);
int Voice_Ctrl_Rpmsg_Send(int func_id, int *msg);
void Voice_Ctrl_Rpmsg_Recv(void);
void voice_ipc_recv_proc(voice_ipc_control_msg msg);

//send message to cap
int ipc_cap_alsa_voice_open(int vmode);
int ipc_cap_alsa_voice_close(int vmode);

//receive message from cap
void ipc_set_voice_device_mode_rcv(voice_ipc_control_msg msg);
void ipc_get_voice_device_mode_rcv(voice_ipc_control_msg msg);
void ipc_set_rx_voice_vol_rcv(voice_ipc_control_msg msg);
void ipc_get_rx_voice_vol_rcv(voice_ipc_control_msg msg);
void ipc_set_tx_voice_vol_rcv(voice_ipc_control_msg msg);
void ipc_get_tx_voice_vol_rcv(voice_ipc_control_msg msg);
void ipc_set_tx_voice_mute_state_rcv(voice_ipc_control_msg msg);
void ipc_get_tx_voice_mute_state_rcv(voice_ipc_control_msg msg);
void ipc_set_rx_voice_mute_state_rcv(voice_ipc_control_msg msg);
void ipc_get_rx_voice_mute_state_rcv(voice_ipc_control_msg msg);
void ipc_set_loopback_enable_state_rcv(voice_ipc_control_msg msg);
void ipc_get_loopback_enable_state_rcv(voice_ipc_control_msg msg);
#ifdef _USE_VOICE_ALSA
void ipc_ap_alsa_voice_open_rcv(voice_ipc_control_msg msg);
void ipc_ap_alsa_voice_close_rcv(voice_ipc_control_msg msg);
#endif

#endif
