/**
 * 
 * @file      logcat_drv_printf.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatprintf豸
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/02/22  1.2      jiang.fenglin  رzcat_device.cļ,ָlogcat_drv_printf.c
 * ---------------------------------------------------------------------------
 * 
 * 
 */


/**
 * ͷļ
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/ioport.h>
#include <linux/serial_reg.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <asm/io.h>
#include "linux/memory.h"
#include <linux/vmalloc.h>
#include <linux/kthread.h>

#include "logcat_drv.h"
#include "ringbuf.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * ⲿ
 */
#ifndef CONFIG_SYSTEM_RECOVERY
#ifndef CONFIG_SYSTEM_CAP
extern ssize_t zCatAgt_App_Write(const char __user *buf, size_t count);
#endif
#endif

/**
 * 궨
 */

/**
 * Ͷ
 */
typedef struct
{
    unsigned short type;
    UINT8 operation;
    UINT8 reserved;
}T_ZCAT_DIAG_CONFIG_REQ;

typedef enum
{
    DISABLE_LOGGING = 0,
    ENABLE_LOGGING,
    GET_MASK,
    SET_MASK,
    DIAG_LAST_OPERATION
        
}T_ZCAT_DIAG_CONFIG_OPERATION_TYPE;

T_RINGBUFFER *g_AP2_KernelToCpBuffer = NULL;
EXPORT_SYMBOL(g_AP2_KernelToCpBuffer);

T_RINGBUFFER *g_AP2_AppToCpBuffer = NULL;
EXPORT_SYMBOL(g_AP2_AppToCpBuffer);

volatile T_RINGBUFFER *g_zCat_app_mem = NULL;
EXPORT_SYMBOL(g_zCat_app_mem);

struct mutex  g_zCat_app_mutex;
EXPORT_SYMBOL(g_zCat_app_mutex);

volatile int g_zcat_kernel_fst = 0;
EXPORT_SYMBOL(g_zcat_kernel_fst);


/**
 * ֲ
 */
static int logcatf_open(struct inode *ip, struct file *fp);
static int logcatf_release(struct inode *ip, struct file *fp);
static ssize_t logcatf_read(struct file *fp, char __user *buf, size_t count, loff_t *pos);
static ssize_t logcatf_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos);
static long logcatf_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);

/**
 * ȫֱ
 */
static const struct file_operations logcatf_fops = {
    .owner = THIS_MODULE,
    .read = logcatf_read,
    .write = logcatf_write,
    .open = logcatf_open,
    .unlocked_ioctl = logcatf_ioctl,
    .release = logcatf_release,
};

static struct miscdevice logcatf_device = {
    .minor = MISC_DYNAMIC_MINOR,
    .name  = "logcat_printf",
    .fops  = &logcatf_fops,
};

static int enable_applog = 1;

/**
 * ʵ
 */

#ifdef CONFIG_SYSTEM_CAP

static struct mutex printf_mutex;

/**
 * @brief AP App LOGд뵽"Master"
 * @param[in] buf ûָ̬
 * @param[in] count ݳ
 * @return ʵдĳ
 * @note
 * @see 
 */
ssize_t zCatAgt_App_Write(const char __user *buf, size_t count)
{
    ssize_t cnt = -1;

    if (buf && count && g_AP2_AppToCpBuffer)
    {
        mutex_lock(&printf_mutex);
        cnt = WriteRingBuffer(g_AP2_AppToCpBuffer, buf, count, ZCAT_MEM_TYPE_USER);
    	mutex_unlock(&printf_mutex);
    }

	return cnt;
}

/**
 * @brief AP Kernel LOGд뵽"Master"
 * @param[in] buf ںָ̬
 * @param[in] count ݳ
 * @return ʵдĳ
 * @note
 * @see 
 */
ssize_t zCatAgt_Kernel_Write(const char *buf, size_t count)
{
    ssize_t cnt = 0;

    if (buf && count && g_AP2_KernelToCpBuffer)
   	{
        cnt = WriteRingBuffer(g_AP2_KernelToCpBuffer, buf, count, ZCAT_MEM_TYPE_KERNEL);
    }
	return cnt;
}
EXPORT_SYMBOL(zCatAgt_Kernel_Write);
#endif

static ssize_t logcatf_read(struct file *fp, char __user *buf,size_t count, loff_t *pos)
{
    #if 0
    UINT8 *appbuf = NULL;
    UINT32 appbufLen = 0;   
    int ret = -1;
    
    if(buf ==NULL)
    return -1;
    /*
    appbuf = kzalloc(count*sizeof(UINT8),GFP_KERNEL);
    if(appbuf == NULL)
    return -1;*/
    ret = wait_for_completion_interruptible(&_app_dev.write_done);
    if(ret < 0)
    {
        //kfree(appbuf);
        return ret;
    }
    appbufLen = ReadRingBuffer_AP(APP_BUFF, buf, count);
    //copy_to_user(buf, appbuf, appbufLen);
    //kfree(appbuf);
    return appbufLen;
    #endif
    return 0;
}

static ssize_t logcatf_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos)
{
    ssize_t ret = -1;
    if(enable_applog == 1)
    {
#ifndef CONFIG_SYSTEM_RECOVERY
    #ifdef USE_CPPS_KO
        if (cpps_callbacks.zCatAgt_App_Write)
            ret = cpps_callbacks.zCatAgt_App_Write(buf, count);
        else
        {
            #ifdef _USE_MBIM
                if (g_zCat_app_mem)
                {
                    mutex_lock_killable(&g_zCat_app_mutex);
                    WriteRingBuffer(g_zCat_app_mem, buf, count, ZCAT_MEM_TYPE_USER);
                    mutex_unlock(&g_zCat_app_mutex);
                }
            #endif
        }
    #else
        ret = zCatAgt_App_Write(buf, count);
    #endif
#endif
    }
    return ret;
}

static int logcatf_open(struct inode *ip, struct file *fp)
{
    //printfڲͬӦд򿪣Ƶĵopen/close
    //printk("logcat_printf open.\n");
    return 0;
}

static long logcatf_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{   
    #if 0
    T_ZCAT_DIAG_CONFIG_REQ aprule = {0};
    int copy_ret = -1;
    void __user* ubuf = (void __user*)arg;

    // printfʹfopenʽ򿪵logcat_printffcntlioctlĲҪ
    printk("logcat_printf ioctl,enable=%d.\n", enable_applog);
    
    copy_ret = copy_from_user(&aprule, ubuf, sizeof(T_ZCAT_DIAG_CONFIG_REQ));
    
    if(aprule.operation == DISABLE_LOGGING)
        enable_applog = 0;
    else if(aprule.operation == ENABLE_LOGGING)
        enable_applog = 1;
    #endif
    return 0;
}

static int logcatf_release(struct inode *ip, struct file *fp)
{
    //printk("logcat_printf release.\n");
    return 0;
}

/**
 * @brief zcatץȡprintf豸ʼ
 * @param[in] N/A
 * @return ׼
 * @note
 * @see 
 */
static int __init logcatf_init(void)
{
#ifdef _USE_MBIM
    void *mem;
#endif
    
    int ret = misc_register(&logcatf_device);
    printk("logcat_printf init.\n");
    if (ret){
        printk(KERN_ERR "logcat_printf driver init failed.\n");
    }

#ifdef _USE_MBIM
    mem = vmalloc(0x10000);
    if (!mem) {
        panic("logcat_printf driver init failed.\n");
    }
    g_zCat_app_mem = CreateRingBuffer((UINT8 *)mem, 0x10000);
    mutex_init(&g_zCat_app_mutex);
    g_zcat_kernel_fst = 1;
#else
    g_zCat_app_mem = NULL;
    mutex_init(&g_zCat_app_mutex);
    g_zcat_kernel_fst = 0;
#endif

#ifdef _USE_CAP_SYS

	// ap2ϴ/д(ap)ap1/ȡ(ps)
#ifdef CONFIG_SYSTEM_CAP
	mutex_init(&printf_mutex);
	g_AP2_KernelToCpBuffer = CreateRingBuffer((UINT8 *)(ZX_DDR_CAPBUF_BASE + ICP_CAP_BUF_LEN), 0x4000);
	g_AP2_AppToCpBuffer = CreateRingBuffer((UINT8 *)(ZX_DDR_CAPBUF_BASE + ICP_CAP_BUF_LEN + 0x4000), 0x4000);
#else
	g_AP2_KernelToCpBuffer = (T_RINGBUFFER *)(ZX_DDR_CAPBUF_BASE + ICP_CAP_BUF_LEN);
	g_AP2_AppToCpBuffer = (T_RINGBUFFER *)(ZX_DDR_CAPBUF_BASE + ICP_CAP_BUF_LEN + 0x4000);
#endif

#endif

    return ret;
}


/**
 * @brief zcatץȡprintf豸˳
 * @param[in] N/A
 * @return N/A
 * @note
 * @see 
 */
static void __exit logcatf_exit(void)
{
    misc_deregister(&logcatf_device);
}


#ifdef __cplusplus
}
#endif

module_init(logcatf_init);
module_exit(logcatf_exit);

MODULE_AUTHOR("jinkai");
MODULE_DESCRIPTION("zCat logcat_printf driver");
MODULE_LICENSE("GPL");

