#ifndef __LINUX_FT6X06_TS_H__ 
#define __LINUX_FT6X06_TS_H__ 

#define FT_I2C_SLAVE_ADDR		0x38
 
/*ft marco*/ 
#define FT_MAX_ID				0x0F 
#define FT_TOUCH_STEP			6 
#define FT_TOUCH_X_H_POS		3 
#define FT_TOUCH_X_L_POS		4 
#define FT_TOUCH_Y_H_POS		5 
#define FT_TOUCH_Y_L_POS		6 
#define FT_TOUCH_EVENT_POS	3 
#define FT_TOUCH_ID_POS		5 

struct ft6x06_platform_data { 
	unsigned int irq_gpio; 
	unsigned int reset_gpio;
	unsigned int irq_func;
	unsigned int reset_func;
}; 

/* 
* This struct is a touchpoint as stored in hardware. Note that the id, 
* as well as the event, are stored in the upper nybble of the hi byte. 
*/ 
struct ts_touchpoint { 
	union { 
		u8 xhi; 
		u8 event; 
	}; 
	u8 xlo; 
	union { 
		u8 yhi; 
		u8 id; 
	}; 
	u8 ylo; 
	u8 unk0; 
	u8 unk1; 
} __attribute__((__packed__)); 

/* This packet represents the register map as read from offset 0 */ 
struct ft6x06_packet { 
	u8 unk0; 
	u8 unk1; 
	u8 touches; 
	struct ts_touchpoint points[CFG_MAX_TOUCH_POINTS]; 
} __attribute__((__packed__)); 

int ft6x06_id_detect(struct i2c_client *client);

#endif 

