/*******************************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name: icp.h
* File Mark:
* Description:  
* Others:
* Version:       V0.1
* Author:        ShiDeYou
* Date:          2013-03-13
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
*******************************************************************************/

/*******************************************************************************
*                                  Include files                               *
*******************************************************************************/

/*******************************************************************************
*                                  Types                                       *
*******************************************************************************/
#ifndef ICP_H
#define ICP_H

#ifdef CONFIG_ARCH_ZX297520V3_CAP
typedef enum _T_ZDrvRpMsg_ActorID
{
    ACTOR_BASEID,
    
    M0_ID = ACTOR_BASEID,
    AP_ID,
    ACTOR_MAXID
} T_ZDrvRpMsg_ActorID;

#else
typedef enum _T_ZDrvRpMsg_ActorID
{
    ICP_MSG_ACTOR_ZSP,
    M0_ID,
    CAP_ID = M0_ID,//zsp\m0???cpko2,cap?linux2??
    ACTOR_MAXID
} T_ZDrvRpMsg_ActorID;
#endif

typedef struct _T_HalIcp_Dword{
    unsigned int low_word;
    unsigned int high_word;
}T_HalIcp_Dword;

typedef struct _T_HalIcp_Reg{
	volatile T_HalIcp_Dword control;
	T_HalIcp_Dword 			state;
	volatile T_HalIcp_Dword clear;
	volatile T_HalIcp_Dword mask;
	volatile T_HalIcp_Dword sfn;
	T_HalIcp_Dword 			in_state;
}T_HalIcp_Reg;

struct zx29_icp_hwdata
{
	int 			int_line;
	T_HalIcp_Reg	*reg;
};

/*******************************************************************************
* Function: HalRpMsg_SenInt
* Description: This function is used for generating icp interrupt to inform remote cpu;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns: 
*      RPMSG_INVALID_PARAMETER:parameter is invalid
*	   RPMSG_SUCCESS:success
* Others:
********************************************************************************/
extern int zDrvIcp_SetInt(T_ZDrvRpMsg_ActorID actorID, unsigned int chID);

#endif
