/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */
#ifndef _FAST_NAT_H
#define _FAST_NAT_H

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <net/SI/fast_common.h>
#include <net/SI/pkt_lost_track.h>

/******************************궨***********************/
/******************************궨***********************/
/******************************궨***********************/

/******************************ṹ嶨***********************/
/******************************ṹ嶨***********************/
/******************************ṹ嶨***********************/
typedef struct ack_delay_stats_s{
    unsigned long total_count;         //͸ڵĶackܸ
    unsigned long forword_count;       //͸ڵĶackĸ
    unsigned long drop_count;          //Ķackĸ
    unsigned long timeout_xmit_count;  //ackʱĶack͸
    unsigned long timeout_drop_count;  //ûʵ壬ȥ
}ack_delay_stats_t;

/*****************************************************/
/*****************************************************/
/*****************************************************/

extern spinlock_t fastnat_spinlock; //Ĳ
extern fast_list_t working_list;
extern struct hlist_nulls_head *working_hash;
extern traverse_command_t timeout_cmd;

extern struct ack_delay_stats_s ack_delay_stats;

extern int ackdrop_maxnum;
extern int ackdrop_tick_num;
extern int fastnat_ack_param;

/******************************ӿ***********************/
/******************************ӿ***********************/
/******************************ӿ***********************/
int fast_nat_get_tuple(struct sk_buff *skb, struct nf_conntrack_tuple *tuple);

int fast_nat_recv(struct sk_buff *skb);

unsigned int napt_handle(unsigned int hooknum,
            struct sk_buff *skb,
            const struct net_device *in,
            const struct net_device *out, int (*okfn) (struct sk_buff *));

int ackfilter(struct sk_buff *skb, fast_entry_t *nat_entry, fast_list_t *list_head);
int tcpack_timeout(fast_entry_t *entry, unsigned long *next_schedule, int *set_next);
int tcpack_rel(fast_entry_t *entry);

#endif //_FAST_NAT_H

