#ifndef __NAND_LINUX_INTERFACE_H__
#define __NAND_LINUX_INTERFACE_H__

typedef enum {
	
   ZFTL_PART_NVRO_NVRW=0,
   ZFTL_PART_NVFAC,
   ZFTL_PART_SMS,
   ZFTL_PART_SIMNV,
   ZFTL_PART_SIMNVFAC,
   ZFTL_PART_MAX
   	
} T_ZFTL_PART_NO;

typedef struct{
    unsigned char pbyManu;      /* id */
    unsigned char pbyDevice;    /* оƬid  */
    unsigned char pbyID3;       /* id */
    unsigned char pbyID4;       /* id */
    unsigned char pbyID5;       /* id */
}T_ZDrvNand_DeviceID;

/**
 * NAND Flash part information
*/
typedef struct _T_Nand_Part_Info
{
		
	unsigned int			PageSize;
	unsigned int			PageSpareSize;
	unsigned int			BlockSize;
	unsigned int			PartOffset;
	unsigned int			PartSize;
	unsigned int			TotalSize;
	unsigned char			*PartName;
}T_Nand_Part_Info;

extern int zDrvNand_Read(unsigned int dwStart, unsigned int dwLen, char* to);
extern int zDrvNand_Program(unsigned int dwStart, unsigned int dwLen, char* from);





#endif
