/*
 * Copyright (C) 2013 ZTE, China
 *
 * It has the ioctl definitions for the volte driver that
 * userspace needs to know about.
 */

#ifndef __LINUX_VOLTE_DRV_H
#define __LINUX_VOLTE_DRV_H

#include <linux/ioctl.h>

typedef enum {
    VOICE_GSM_MODE = 0,
    VOICE_TD_MODE ,
    VOICE_WCDMA_MODE,
    VOICE_LTE_MODE,
    VOICE_GSM_TD_MODE,//GSM TD share
    VOICE_GSM_WCDMA_MODE,    //GSM WCDMA share
    MAX_VOICE_MODE
} T_ZDrvVoice_MODE;
typedef struct {
	uint32_t clock_rate;
	uint32_t channel_count;
	uint32_t samples_per_frame;
	uint32_t bits_per_sample;
	uint32_t mode;
} T_ZDrvVoice_Cfg;

typedef   T_ZDrvVoice_Cfg T_ZDrvVolte_Cfg;

#ifdef __KERNEL__
struct volte_dev {
	T_ZDrvVoice_Cfg param;
	void *readbuf;
	void *writebuf;
};
#endif

#define VOLTE_IOCTL_READ_START	_IO('v', 1)
#define VOLTE_IOCTL_READ_STOP	_IO('v', 2)
#define VOLTE_IOCTL_WRITE_START	_IO('v', 3)
#define VOLTE_IOCTL_WRITE_STOP	_IO('v', 4)
#define VOLTE_IOCTL_SET_CFG	_IOW('v', 5, T_ZDrvVoice_Cfg)
#define VOLTE_IOCTL_GET_SLIC_USE_FLAG	_IOR ('v', 6, int)

/**************voice  define****************/
typedef enum {
    AMR_NB_CODEC = 0,
    AMR_WB_CODEC,

    MAX_CODEC_TYPE
} T_Codec_Type;

typedef enum {
    DSP_PATH = 0,
    SOFT_PATH,
    MAX_CODEC_PATH
} T_Codec_Path;

typedef enum {
    VOICE_STOP = 0,
    VOICE_START,
    MAX_VOICE_STATE
} T_Voice_State;

typedef struct {
	uint32_t clock_rate;  //8000;16000
	uint32_t mode; //// 0 gsm;1 td;2 wcdma;3 lte
	uint32_t codec_type;//0 amr-nb;1 amr-wb
	uint32_t codec_path;//0 hardware dsp;1 soft amr lib


} T_Voice_Para;

#ifdef __KERNEL__
struct voice_dev {
	T_Voice_Para param;
	uint32_t voice_state;
};
#endif

#define VOICE_IOCTL_START	_IOW('v', 10, T_ZDrvVoice_Cfg)
#define VOICE_IOCTL_STOP	_IOW('v', 11, T_ZDrvVoice_Cfg)
#define VOICE_IOCTL_GET_SLIC_USE_FLAG	_IOR ('v', 12, int)
#define VOICE_IOCTL_VPLOOP	_IOW('v', 13, int)

#ifdef _USE_VEHICLE_DC
#define VOICE_IOCTL_SET_VOL	_IOW('v', 14, int)
#define VOICE_IOCTL_GET_VOL	_IOR('v', 15, int) 

#define VOICE_IOCTL_SET_MUTE	_IOW('v', 16, bool)
#define VOICE_IOCTL_GET_MUTE	_IOR('v', 17, bool)

#define VOICE_IOCTL_SET_PATH	_IOW('v', 18, int)
#define VOICE_IOCTL_GET_PATH	_IOR('v', 19, int) 
#endif

#ifdef __KERNEL__
#define  print_audio(fmt, ...)  \
		printk(fmt, ##__VA_ARGS__)
#endif

/**************audiomix  define****************/
typedef struct {
    uint32_t sample_rate;
    uint32_t audioType;
    //uint32_t samples_per_frame;
    //uint32_t bits_per_sample;
} T_ZDrvAudioMix_Cfg;

#ifdef __KERNEL__
struct audio_mix_dev {
    T_ZDrvAudioMix_Cfg param;
    //void *readbuf;
    void *writebuf;
};
#endif
 
#define AUDIOMIX_IOCTL_SET_CFG _IOW('v', 7, T_ZDrvAudioMix_Cfg) 

#endif

