/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */
#ifndef _FAST_COMMON_H
#define _FAST_COMMON_H

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/addrconf.h>

#include <linux/module.h>

#include <linux/proc_fs.h>

/* ******************************궨******************************* */
/* ******************************궨******************************* */
/* ******************************궨******************************* */
#define MONITOR_PROCESS_INTERVAL    60 /* seconds */
#define ENTRY_TIMEOUT_TIME  300        /* seconds */
#define FAST_DSCP_MASK 0xfc
#define FAST_ALL_DIR ((1<<IP_CT_DIR_MAX) - 1)

#define WWW_PORT 80

#define MAX_NET_DEVICE_NAME_LEN 10

#define NOFAST_PROTO_MAX 100
//for cov
#define fast_test_bit(nr, val)   ((val) & (1UL<<(nr)))
/* *****************************ṹ嶨***************************** */
/* *****************************ṹ嶨***************************** */
/* *****************************ṹ嶨***************************** */
enum{
    FN_TYPE_SRC = 0,
    FN_TYPE_DST,
};

// ת𣬿תõ
enum{
    FAST_CLOSE = 0,               // رfastnat߱׼linuxԭӲ
    FAST_NET_CORE,                // IP׼fasnatжϵȣԲع
    FAST_NET_DEVICE,              // net_deviceж
    FAST_PS_USB,                  // ֻucʹãusbpsֱ֮͸
    FAST_CLOSE_KEEP_LINK = 5,     // رfastnat߱׼linuxԭӲ
};

/* λͼʽ  --- ӹܿת */
enum{
    /* 0: ϵfastʽԼ洢fastݣ 1: µfastʽʹںԴ*/
    FAST_TYPE_VERSION_BIT = 0,
    FAST_TYPE_VERSION       = (1 << FAST_TYPE_VERSION_BIT),

    /* IPv4תתر */
    FAST_TYPE_FW4_BIT = 1,
    FAST_TYPE_FW4     = (1 << FAST_TYPE_FW4_BIT), 

    /* IPv6תתر */
    FAST_TYPE_FW6_BIT = 2,
    FAST_TYPE_FW6     = (1 << FAST_TYPE_FW6_BIT),

    /* IPv4ؿתر */
    FAST_TYPE_LOCAL4_BIT = 3,
    FAST_TYPE_LOCAL4     = (1 << FAST_TYPE_LOCAL4_BIT),

    /* IPv6ؿתر */
    FAST_TYPE_LOCAL6_BIT = 4,
    FAST_TYPE_LOCAL6     = (1 << FAST_TYPE_LOCAL6_BIT),

    /* תر */
    FAST_TYPE_BR_BIT = 5,
    FAST_TYPE_BR     = (1 << FAST_TYPE_BR_BIT),

    /* 23ֱӵŵ */
    FAST_TYPE_BR_LOCAL_BIT = 6,
    FAST_TYPE_BR_LOCAL     = (1 << FAST_TYPE_BR_LOCAL_BIT),
};

// ָʾĳconnǰʹõẒ̇μֵct->fast_ct.isFast
enum conn_fast_type{
    FAST_CT_NOT = 0,          // δпת
    FAST_CT_WND4,              // ģʽIPv4пת
    FAST_CT_WND6,              // ģʽIPv6пת
    FAST_CT_FW4,              // IPv4תת
    FAST_CT_FW6,             // IPv6תת
    FAST_CT_LOCAL4,          // IPv4ת
    FAST_CT_LOCAL6,          //IPv6ת
};

enum{
    RELEASE_ALL_SK_BIT = 0,
    RELEASE_ALL_SK = (1 << RELEASE_ALL_SK_BIT),
    
    RELEASE_ALL_DST_BIT = 1,
    RELEASE_ALL_DST = (1 << RELEASE_ALL_DST_BIT),
};

typedef struct fast_sysctl_arg
{
    u_int32_t path[8];
    u_int32_t path_len;
    void *value;
    u_int32_t value_len;
}fast_sysctl_arg_t;

/* all information set from conntrack */
typedef struct fast_entry_data_s{
    struct nf_conntrack_tuple_hash tuplehash;
    u_int32_t     nat_addr;
    u_int16_t     nat_port;
    //u_int8_t      flow_lbl[3];
    u_int8_t      type;
    u_int8_t      dmac[ETH_ALEN];
    u_int8_t      tos;
    u_int8_t      pad;
    u_int32_t     priority;
    u_int32_t     mark;
    struct net_device *indev;
    struct net_device *outdev;
    unsigned long packet_num;

    //ethͣ˴MACͷԿʵMACͷֵ
    u_int8_t            hh_flag;
    unsigned char        hh_data[14];
    
    u_int8_t       is_not_nat; //Ϊ1ʾ֧NAT
}fast_entry_data_t;

typedef struct fast_entry_s{
    struct fast_entry_s *next;
    struct fast_list_s *list_head;       //
    spinlock_t *fast_spinlock;           //
    struct nf_conn *ct;
    struct fast_entry_data_s data[IP_CT_DIR_MAX];
    u_int32_t flags;
    struct timer_list timeout;
    
    int ackdrop_num;                //Ѷackĸ
    struct sk_buff *predrop_skb;    //¼һλakc
    unsigned long ackstart_tick;    //һackڵʼʱ̵
}fast_entry_t;

typedef struct fast_list_s{
    u_int32_t count;
    struct fast_entry_s *next;
}fast_list_t;

struct conn_list{    
    struct nf_conn __rcu *nfct;
    struct list_head list;
};

enum{
    TRAVERSE_CMD_TIMEOUT = 0,
    TRAVERSE_CMD_DEV_DOWN,
    TRAVERSE_CMD_IP_MAC,
    TRAVERSE_CMD_MAX,
};

typedef struct traverse_command{
    u_int32_t cmd;
    unsigned long arg;
}traverse_command_t;

/* ********************************************************** */
/* ********************************************************** */
/* ********************************************************** */
extern struct kmem_cache *fast_head_cache;

/* 
* 0: رfastnat߱׼linuxжԭ
* 1: IP׼fasnatжϵȣԲع
* 2: net_deviceж
* 5: رfastnat߱׼linuxԭӲ
* ͨproc޸ֵ
*/
extern int fastnat_level;

/* λͼʽ  --- ӹܿת */
extern unsigned long fast_switch;

extern int fastbr_level;                 //ת

/* ***************************** ƽ̨ر ***************************** */
/*
 *br_nameȼַͨprocڵã
 *˴Ƕ͸ֵ
 */
extern char br_name[];
extern char ps_name[];
extern char usb_name[];
extern char ppp_name[];
//cp:ˣģ̬Ҫ·ɶ
//ap:˫ˣģ̬ɼŽ
extern char need_jilian[];

extern unsigned int tcp_timeouts[] __read_mostly;

extern unsigned int fast_udp_timeout_stream;
extern unsigned int fast_udp_timeout; /*normal is 30*HZ*/

extern unsigned int nofast_port[];

extern unsigned char zeromac[];

extern spinlock_t fast_fw_spinlock;
extern spinlock_t fastlocal_spinlock;

//ݿת͸ӹܿõĻص
extern int (*fast_nat4_proc)(struct sk_buff *skb);
extern int (*fast_nat6_proc)(struct sk_buff *skb);
extern int (*fast_fw4_proc)(struct nf_conn * tmpl, 
    struct sk_buff *skb, 
    struct nf_conn * ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
extern int (*fast_fw6_proc)(struct nf_conn * tmpl, 
    struct sk_buff *skb, 
    struct nf_conn * ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);

extern int (*fast_local4_proc)(struct nf_conn * tmpl, 
    struct sk_buff *skb, 
    struct nf_conn * ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
extern int (*fast_local6_proc)(struct nf_conn * tmpl, 
    struct sk_buff *skb, 
    struct nf_conn * ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);

extern int (*fast_local4_output_proc)(struct sk_buff *skb);
extern int (*fast_local6_output_proc)(struct sk_buff *skb);

extern int (*fast_br_proc)(struct sk_buff *skb);

/* *****************************ӿ***************************** */
/* *****************************ӿ***************************** */
/* *****************************ӿ***************************** */
static inline struct fast_entry_data_s *
fast_hash_to_data(const struct nf_conntrack_tuple_hash *hash)
{
    return container_of(hash, struct fast_entry_data_s, tuplehash);
}

static inline struct fast_entry_s *
fast_data_to_entry(const struct fast_entry_data_s *edata)
{
    return container_of(edata, struct fast_entry_s, data[edata->tuplehash.tuple.dst.dir]);
}

fast_entry_t *fn_list_del(fast_list_t *list_head, fast_entry_t *entry, bool free_entry);
void fn_list_add(fast_list_t *list_head, fast_entry_t *entry);

fast_entry_data_t *fast_find_entry_data(const struct hlist_nulls_head *working_hash, const struct nf_conntrack_tuple *tuple);
int fast_add_entry(struct hlist_nulls_head *working_hash, fast_entry_data_t *entry_data);
fast_entry_t *fast_get_entry(fast_list_t *list_head, struct nf_conn *ct, char dir, int version);
void fast_entry_del_cleanup(void);

unsigned int get_conntrack_index(const struct tcphdr *tcph);

void update_tcp_timeout(fast_entry_t *entry, fast_entry_data_t *entry_data, struct tcphdr *tcph);

int record_MAC_header(const struct hlist_nulls_head *working_hash, struct nf_conn *ct, 
    fast_entry_t *entry, fast_entry_data_t *entry_data, 
    struct neighbour *neigh, const struct net_device *out, int proto);

struct net_device *getBridgePort(struct neighbour *neigh, const struct net_device *out);

int check_skip_ports(unsigned int net_dst_port);

void traverse_process(fast_list_t *list_head, unsigned long param);

void fast_device_down_event_by_name(char *dev_name);

void fast_cleanup_links(fast_list_t *list_head);

void athr_fast_dump(int ctl);

//void fast_dump_entry(fast_entry_t *fast_entry, int debug_it, int debug_level, int detail);

extern u_int32_t hash_conntrack_fast(const struct nf_conntrack_tuple *tuple);

void fast_level_change(int new_level);
void fast_switch_change(unsigned long new_switch);

struct dst_entry *dst_get_by_ct(struct nf_conn *ct, int dir);

struct nf_conn *skb_get_ct(struct nf_conn **tmpl,
          struct sk_buff *skb,
          struct nf_conntrack_l4proto **l4proto,
          unsigned int *dataoff,
          u_int8_t pf,
          unsigned int hooknum,
          int *dir,
          u_int8_t *protonum);

int fast_local4_recv(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
int fast_local_output(struct sk_buff *skb);

int fast_local6_recv(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);

int fast_local_output_v6(struct sk_buff *skb);

void fast_sk_add_ct(struct sk_buff *skb, struct sock *sk);
void fast_dst_add_ct(struct dst_entry *dst, struct nf_conn *ct);
void fast_fw_conn_release(struct nf_conn *ct);
void fast_fw_dst_entry_release(struct dst_entry *dst);
void fast_release_all(int mark);
void fast_tcpdump(struct sk_buff *skb);
struct sk_buff *fast_expand_headroom(struct sk_buff *skb, struct net_device *dev);
struct sk_buff *fast_expand_headroom_v6(struct sk_buff *skb, struct net_device *dev);

#endif //_FAST_COMMON_H

