/*
 *  arch/arm/include/asm/uaccess.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef _ASMARM_UACCESS_H
#define _ASMARM_UACCESS_H

/*
 * User space memory access functions
 */
#include <linux/string.h>
#include <linux/thread_info.h>
#include <asm/errno.h>
#include <asm/memory.h>
#include <asm/domain.h>
#include <asm/unified.h>
#include <asm/compiler.h>

#define VERIFY_READ 0
#define VERIFY_WRITE 1
/*
 *comlee
 *
 */


#define __GUP_CLOBBER_1	"lr", "cc"
#ifdef CONFIG_CPU_USE_DOMAINS
#define __GUP_CLOBBER_2	"ip", "lr", "cc"
#else
#define __GUP_CLOBBER_2 "lr", "cc"
#endif
#define __GUP_CLOBBER_4	"lr", "cc"


extern int __myget_user_1(void *);
extern int __myget_user_2(void *);
extern int __myget_user_4(void *);

#define __myget_user_x(__r2,__p,__e,__l,__s)				\
	   __asm__ __volatile__ (					\
		__asmeq("%0", "r0") __asmeq("%1", "r2")			\
		__asmeq("%3", "r1")					\
		"bl	__myget_user_" #__s				\
		: "=&r" (__e), "=r" (__r2)				\
		: "0" (__p), "r" (__l)					\
		: __GUP_CLOBBER_##__s)

#define myget_user(x,p)							\
	({								\
		unsigned long __limit = current_thread_info()->addr_limit - 1; \
		register const typeof(*(p)) __user *__p asm("r0") = (p);\
		register unsigned long __r2 asm("r2");			\
		register unsigned long __l asm("r1") = __limit;		\
		register int __e asm("r0");				\
		switch (sizeof(*(__p))) {				\
		case 1:							\
			__myget_user_x(__r2, __p, __e, __l, 1);		\
			break;						\
		case 2:							\
			__myget_user_x(__r2, __p, __e, __l, 2);		\
			break;						\
		case 4:							\
			__myget_user_x(__r2, __p, __e, __l, 4);		\
			break;						\
		default: __e = __get_user_bad(); break;			\
		}							\
		x = (typeof(*(p))) __r2;				\
		__e;							\
	})



extern int __myput_user_1(void *, unsigned int);
extern int __myput_user_2(void *, unsigned int);
extern int __myput_user_4(void *, unsigned int);
extern int __myput_user_8(void *, unsigned long long);

#define __myput_user_x(__r2,__p,__e,__l,__s)				\
	   __asm__ __volatile__ (					\
		__asmeq("%0", "r0") __asmeq("%2", "r2")			\
		__asmeq("%3", "r1")					\
		"bl	__myput_user_" #__s				\
		: "=&r" (__e)						\
		: "0" (__p), "r" (__r2), "r" (__l)			\
		: "ip", "lr", "cc")

#define myput_user(x,p)							\
	({								\
		unsigned long __limit = current_thread_info()->addr_limit - 1; \
		const typeof(*(p)) __user *__tmp_p = (p);		\
		register const typeof(*(p)) __r2 asm("r2") = (x);	\
		register const typeof(*(p)) __user *__p asm("r0") = __tmp_p; \
		register unsigned long __l asm("r1") = __limit;		\
		register int __e asm("r0");				\
		switch (sizeof(*(__p))) {				\
		case 1:							\
			__myput_user_x(__r2, __p, __e, __l, 1);		\
			break;						\
		case 2:							\
			__myput_user_x(__r2, __p, __e, __l, 2);		\
			break;						\
		case 4:							\
			__myput_user_x(__r2, __p, __e, __l, 4);		\
			break;						\
		case 8:							\
			__myput_user_x(__r2, __p, __e, __l, 8);		\
			break;						\
		default: __e = __put_user_bad(); break;			\
		}							\
		__e;							\
	})


 


