/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: icp_rpmsg.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.1
 * Author:        ShiDeYou
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 ******************************************************************************/

/*******************************************************************************
*                                  Include files                               *
*******************************************************************************/

#include <linux/interrupt.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/kfifo.h>
#include <linux/err.h>
#include <linux/notifier.h>
#include <linux/semaphore.h>
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
#include <linux/device.h>
#include <mach/rpmsg.h>
#include <linux/module.h>
#include <linux/string.h>

#include <asm/system.h>

#include <linux/wakelock.h>


/*******************************************************************************
*                                    Macro                                     *
*******************************************************************************/
#define RPMSG_ALIGN 0x4
#define RPMSG_ADDTIONAL_BYTES 0x4
#define RPMSG_SPACEEND 0x4445         /*ED*/
#define ALIGN_RPMSG(size,align) (((unsigned int)size + align - 1)&(~(align - 1)))
#define RPMSG_MSGHEAD_FLAG 0x5453          /*ST*/


/*******************************************************************************
*                           Global  Variable                                   *
*******************************************************************************/	
typedef struct _T_HalRpoc
{
	T_ZDrvRpMsg_ActorID actorID;
	T_ZDrvRpMsg_ChID chID;
}T_HalRpoc;
	
typedef struct _T_RpMsg_struct
{
	T_HalRpoc event;
	struct work_struct rpmsg_work;
}T_RpMsg_struct;
	
struct semaphore RpmsgSema[ACTOR_MAXID][CHANNEL_MAXID];
Icp_rpmsg_drv *Icp_rpmsg_drvs[ACTOR_MAXID];
static T_ZDrvRpMsg_CallbackFunction s_RpMsgCallbackList[ACTOR_MAXID][CHANNEL_MAXID];
struct workqueue_struct *rpmsg_workqueue[2];
T_RpMsg_struct rpmsg_struct[2];
unsigned int RpMsgRead_Exit[ACTOR_MAXID][CHANNEL_MAXID] = {{0,0}};

struct mutex rpmsgread_mutex[ACTOR_MAXID][CHANNEL_MAXID];
struct mutex rpmsgwrite_mutex[ACTOR_MAXID][CHANNEL_MAXID];
struct mutex rpmsgch_mutex[ACTOR_MAXID];

#if defined(CONFIG_HAS_WAKELOCK)
static struct wake_lock icp_wake_lock;
#endif
/*******************************************************************************
* Function: halRpMsg_IsRecvChEmpty
* Description: This function is used for checking the channel used to receive message is empty or not;
* Parameters:
*   Input:
*        channel_send:channel message will be send to
*        channel_recv:channel message will be received from
*   Output:None
*
* Returns:
*        TRUE: the Recch is empty .
*        FALSE: the Recch is not empty .
*
* Others:
********************************************************************************/
static bool halRpMsg_IsRecvChEmpty(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	T_HalRpMsg_ChInfo *channel_recv = Icp_rpmsg_drvs[actorID]->ChInfo_Recv_Base + chID;
	
	if(!(channel_recv->flag & CHANNEL_FLAG)){
		return TRUE;
	}
	
	if (Icp_rpmsg_drvs[actorID]->Channel_config.ChConfig[chID] == CH_IRAM){
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[actorID]->ChInfo_RecvBase_offset;
	}
	else{
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[actorID]->Ddr_RecvBase_offset;
	}
	
	if (channel_recv->SendPos == channel_send->RecvPos){
		return TRUE;
	}
	else{
		if (((T_HalRpMsg_RpMsg *)(channel_send->RecvPos + RecvBase_remap))->MsgHeader.flag == RPMSG_SPACEEND){
			channel_send->RecvPos = 0x0;/*\u017eĶ\u017e*/
		}
		if (channel_recv->SendPos == channel_send->RecvPos){
			return TRUE;
		}
		
		return FALSE;
	}
}

/*******************************************************************************
* Function: zDrvRpMsg_Read
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   DRV_ERROR
*
* Others:
********************************************************************************/
int zDrvRpMsg_Read(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int size=0;
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Send_Base + (pMsg->chID);
	T_HalRpMsg_ChInfo *channel_recv = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Recv_Base + (pMsg->chID);
	T_HalRpMsg_RpMsg *RpMsg = NULL;
	unsigned int result_len = 0;

	if ((pMsg == NULL)|| (pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= CHANNEL_MAXID)){
	    return RPMSG_INVALID_PARAMETER;
	}

	if (!(channel_send->flag & CHANNEL_FLAG)){
	    return RPMSG_CHANNEL_INEXISTANCE;
	}
	
	if ((pMsg->flag & RPMSG_READ_POLL) &&(halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE)){
	    return RPMSG_NO_MSG;
	}
	
	RpMsgRead_Exit[pMsg->actorID][pMsg->chID] = 0;

	mutex_lock(&rpmsgread_mutex[pMsg->actorID][pMsg->chID]);
	/*check the read buf is empty,if empty wait semaphore*/
	while (halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE)/*ȷûźѻ*/
	{
		if(down_interruptible(&RpmsgSema[pMsg->actorID][pMsg->chID])){
			mutex_unlock(&rpmsgread_mutex[pMsg->actorID][pMsg->chID]);
			return -ERESTARTSYS;
		}
		if(RpMsgRead_Exit[pMsg->actorID][pMsg->chID] == 1){
			mutex_unlock(&rpmsgread_mutex[pMsg->actorID][pMsg->chID]);
			return 0;
		}
	}

	if (Icp_rpmsg_drvs[pMsg->actorID]->Channel_config.ChConfig[pMsg->chID] == CH_IRAM){
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_RecvBase_offset;
	}
	else{
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->Ddr_RecvBase_offset;
	}

	RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->RecvPos + RecvBase_remap);
	if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		mutex_unlock(&rpmsgread_mutex[pMsg->actorID][pMsg->chID]);
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(RpMsg->MsgHeader.len));
	size = RpMsg->MsgHeader.len + sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size, RPMSG_ALIGN);
	memcpy((unsigned int *)pMsg->buf, &(RpMsg->data), result_len);
	channel_send->RecvPos += size;
	mutex_unlock(&rpmsgread_mutex[pMsg->actorID][pMsg->chID]);
	
	return result_len;
}
EXPORT_SYMBOL(zDrvRpMsg_Read);

/*******************************************************************************
* Function: zDrvRpMsg_ReadLockIrq
* Description: This function is used for reading message and lock irq;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   DRV_ERROR
*
* Others:
********************************************************************************/
int zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int size=0;
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Send_Base + (pMsg->chID);
	T_HalRpMsg_ChInfo *channel_recv = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Recv_Base + (pMsg->chID);
	T_HalRpMsg_RpMsg *RpMsg = NULL;
	unsigned int result_len = 0;

	if (!(pMsg->flag & RPMSG_READ_POLL) ||(pMsg == NULL) || (pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= CHANNEL_MAXID)){
	    return RPMSG_INVALID_PARAMETER;
	}

	if (!(channel_send->flag & CHANNEL_FLAG) || !(channel_recv->flag & CHANNEL_FLAG)){
	    return RPMSG_CHANNEL_INEXISTANCE;
	}
	
	local_irq_disable();
	/*check the read buf is empty,if empty wait semaphore*/
	if(halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE){
		local_irq_enable();
		return RPMSG_NO_MSG;
	}
	
	if (Icp_rpmsg_drvs[pMsg->actorID]->Channel_config.ChConfig[pMsg->chID] == CH_IRAM){
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_RecvBase_offset;
	}
	else{
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->Ddr_RecvBase_offset;
	}

	RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->RecvPos + RecvBase_remap);
	if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		local_irq_enable();
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(RpMsg->MsgHeader.len));
	size = RpMsg->MsgHeader.len + sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size, RPMSG_ALIGN);
	memcpy((unsigned int *)pMsg->buf, &(RpMsg->data), result_len);
	channel_send->RecvPos += size;
	local_irq_enable();
	
	return result_len;
}
EXPORT_SYMBOL(zDrvRpMsg_ReadLockIrq);

/*******************************************************************************
* Function: halRpMsg_IsChFreeSpace
* Description: This function is used for checking channel free buffer;
* Parameters:
*   Input:
*         channel_send:channel used for sending message
*         channel_recv:channel used for receiving message
*         size:size of message
*   Output:None
*
* Returns:
*        TRUE: the channel has free buffer .
*        FALSE: the channel no free buffer .
*
* Others:
********************************************************************************/
static bool halRpMsg_IsChFreeSpace(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID,  unsigned int size)
{
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	T_HalRpMsg_ChInfo *channel_recv = Icp_rpmsg_drvs[actorID]->ChInfo_Recv_Base + chID;

	if (Icp_rpmsg_drvs[actorID]->Channel_config.ChConfig[chID] == CH_IRAM){
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[actorID]->ChInfo_SendBase_offset;
	}
	else{
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[actorID]->Ddr_SendBase_offset;
	}
	
	if (channel_send->SendPos < channel_recv->RecvPos){
        	if ((channel_recv->RecvPos - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
	else{
		if ((channel_send->size - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
			return TRUE;
		}
		else if ((size + RPMSG_ADDTIONAL_BYTES) <= channel_recv->RecvPos){
			 *(unsigned short *)(SendBase_remap + channel_send->SendPos) = RPMSG_SPACEEND;
			channel_send->EndAddr = channel_send->SendPos;
			channel_send->SendPos = 0x0;
            
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
}

/*******************************************************************************
* Function: zDrvRpMsg_Write
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   DRV_ERROR
*
* Others:
********************************************************************************/
int zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int size=0;
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Send_Base + (pMsg->chID);
	T_HalRpMsg_RpMsg *RpMsg = NULL;

	if ((pMsg == NULL)||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= CHANNEL_MAXID)){
		return RPMSG_INVALID_PARAMETER;
	}
	if (!(channel_send->flag & CHANNEL_FLAG)){
		return RPMSG_CHANNEL_INEXISTANCE;
	}
	size = pMsg->len+ sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	
	if (Icp_rpmsg_drvs[pMsg->actorID]->Channel_config.ChConfig[pMsg->chID] == CH_IRAM){
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_SendBase_offset;
	}
	else{
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->Ddr_SendBase_offset;
	}

	mutex_lock(&rpmsgwrite_mutex[pMsg->actorID][pMsg->chID]);
	if (halRpMsg_IsChFreeSpace(pMsg->actorID, pMsg->chID, size) == TRUE){
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->SendPos + SendBase_remap);
		RpMsg->MsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		RpMsg->MsgHeader.len = (unsigned short)(pMsg->len);
		memcpy(&(RpMsg->data), pMsg->buf, pMsg->len);
		channel_send->SendPos += size;
	}
	else{
		mutex_unlock(&rpmsgwrite_mutex[pMsg->actorID][pMsg->chID]);
		return RPMSG_SPACE_NOT_ENOUGH;
	}
	if (Icp_rpmsg_drvs[pMsg->actorID]->ops->Icp_GetIntState(pMsg->actorID,  pMsg->chID) == FALSE){
		if (pMsg->flag & RPMSG_WRITE_INT){
			Icp_rpmsg_drvs[pMsg->actorID]->ops->Icp_SetInt(pMsg->actorID,  pMsg->chID);
		}
	}
	mutex_unlock(&rpmsgwrite_mutex[pMsg->actorID][pMsg->chID]);
	
	return (pMsg->len);
}

EXPORT_SYMBOL(zDrvRpMsg_Write);

/*******************************************************************************
* Function: zDrvRpMsg_WriteIrqLock
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   DRV_ERROR
*
* Others:
********************************************************************************/
int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int size=0;
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_Send_Base + (pMsg->chID);
	T_HalRpMsg_RpMsg *RpMsg = NULL;

	if ((pMsg == NULL)||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= CHANNEL_MAXID)){
		return RPMSG_INVALID_PARAMETER;
	}
	if (!(channel_send->flag & CHANNEL_FLAG)){
		return RPMSG_CHANNEL_INEXISTANCE;
	}
	size = pMsg->len+ sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	
	if (Icp_rpmsg_drvs[pMsg->actorID]->Channel_config.ChConfig[pMsg->chID] == CH_IRAM){
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->ChInfo_SendBase_offset;
	}
	else{
		SendBase_remap = channel_send->Base_Addr + Icp_rpmsg_drvs[pMsg->actorID]->Ddr_SendBase_offset;
	}

	local_irq_disable();
	if (halRpMsg_IsChFreeSpace(pMsg->actorID, pMsg->chID, size) == TRUE){
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->SendPos + SendBase_remap);
		RpMsg->MsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		RpMsg->MsgHeader.len = (unsigned short)(pMsg->len);
		memcpy(&(RpMsg->data), pMsg->buf, pMsg->len);
		channel_send->SendPos += size;
	}
	else{
		local_irq_enable();
		return RPMSG_SPACE_NOT_ENOUGH;
	}
	if (Icp_rpmsg_drvs[pMsg->actorID]->ops->Icp_GetIntState(pMsg->actorID,  pMsg->chID) == FALSE){
		if (pMsg->flag & RPMSG_WRITE_INT){
			Icp_rpmsg_drvs[pMsg->actorID]->ops->Icp_SetInt(pMsg->actorID,  pMsg->chID);
		}
	}
	local_irq_enable();
	
	return (pMsg->len);
}

EXPORT_SYMBOL(zDrvRpMsg_WriteLockIrq);

/*******************************************************************************
* Function: zDrvRpMsg_CreateChannel
* Description: This function is used for creating channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       size: size of channel
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   DRV_ERROR: fail .
*
* Others:  
********************************************************************************/
int zDrvRpMsg_CreateChannel (T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size)
{	
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	if ((actorID>=ACTOR_MAXID) || (chID>=CHANNEL_MAXID)){
		return RPMSG_INVALID_PARAMETER;
	}

	if (channel_send->flag & CHANNEL_FLAG){
		return RPMSG_CHANNEL_ALREADY_EXIST;
	}

	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	mutex_lock(&rpmsgch_mutex[actorID]);
	if (Icp_rpmsg_drvs[actorID]->Channel_config.ChConfig[chID] == CH_IRAM){
		if (size > Icp_rpmsg_drvs[actorID]->Channel_config.CurIramSpace_Size){
			mutex_unlock(&rpmsgch_mutex[actorID]);
			return RPMSG_SPACE_NOT_ENOUGH;
		}

		channel_send->Base_Addr =  Icp_rpmsg_drvs[actorID]->Channel_config.CurIramAddr;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurIramAddr += size;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurIramSpace_Size -=size;
	}
	else if (Icp_rpmsg_drvs[actorID]->Channel_config.ChConfig[chID] == CH_DDR){
		if (size > Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrSpace_Size){
			mutex_unlock(&rpmsgch_mutex[actorID]);
			return RPMSG_SPACE_NOT_ENOUGH;
		}

		channel_send->Base_Addr =  Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrAddr;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrAddr += size;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrSpace_Size -=size;
	}
	else{
		mutex_unlock(&rpmsgch_mutex[actorID]);
		return RPMSG_INVALID_PARAMETER;
	}	
	
	mutex_unlock(&rpmsgch_mutex[actorID]);
	channel_send->size = size;

	sema_init(&RpmsgSema[actorID][chID], 0);	
	mutex_init(&rpmsgread_mutex[actorID][chID]);
	mutex_init(&rpmsgwrite_mutex[actorID][chID]);
 	channel_send->flag |= CHANNEL_FLAG;
	Icp_rpmsg_drvs[actorID]->ops->Icp_UnMask(actorID, chID);
 
	return RPMSG_SUCCESS;
	
}

EXPORT_SYMBOL(zDrvRpMsg_CreateChannel);
/*******************************************************************************
* Function: zDrvRpMsg_GetDataSize
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int zDrvRpMsg_RecvCh_GetDataSize(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	T_HalRpMsg_ChInfo *channel_recv = Icp_rpmsg_drvs[actorID]->ChInfo_Recv_Base + chID;

	if(channel_send->RecvPos <= channel_recv->SendPos){
		return (channel_recv->SendPos - channel_send->RecvPos);
	}
	else{
		return (channel_recv->EndAddr - channel_send->RecvPos + channel_recv->SendPos);
	}
}

EXPORT_SYMBOL(zDrvRpMsg_RecvCh_GetDataSize);
/*******************************************************************************
* Function: RpMsg_Dispatch
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int RpMsg_Dispatch(struct work_struct *work)
{
	void *buf = NULL;
	unsigned int size = 0;
	unsigned short len = 0;
	unsigned int RecvBase_remap = 0;
	T_ZDrvRpMsg_CallbackFunction callback;
	T_RpMsg_struct *rpmsg_struct;
	T_ZDrvRpMsg_ActorID actorID;
	T_ZDrvRpMsg_ChID chID;
	T_HalRpMsg_ChInfo *channel_send = NULL;
	T_HalRpMsg_ChInfo *channel_recv = NULL;
	T_HalRpMsg_RpMsg *RpMsg = NULL;

	rpmsg_struct = container_of(work, T_RpMsg_struct, rpmsg_work);
	actorID = rpmsg_struct->event.actorID;
	chID = rpmsg_struct->event.chID;
	channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	channel_recv = Icp_rpmsg_drvs[actorID]->ChInfo_Recv_Base + chID;
	
	if (!(channel_recv->flag & CHANNEL_FLAG))
	{
        	return RPMSG_CHANNEL_INEXISTANCE;
	}
	if (Icp_rpmsg_drvs[actorID]->Channel_config.ChConfig[chID] == CH_IRAM){
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[actorID]->ChInfo_RecvBase_offset;
	}
	else{
		RecvBase_remap = channel_recv->Base_Addr + Icp_rpmsg_drvs[actorID]->Ddr_RecvBase_offset;
	}
	
	while( halRpMsg_IsRecvChEmpty(actorID, chID) != TRUE)
	{
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->RecvPos + RecvBase_remap);
		if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
			return RPMSG_CHANNEL_MSG_ERR;
		}
		len = RpMsg->MsgHeader.len;
		size = ALIGN_RPMSG(len, RPMSG_ALIGN) + sizeof(T_HalRpMsg_MsgHeader);
		buf = &(RpMsg->data);
		/* actorchIDs_RpMsgCallbackListȡص\u017e */
		callback = s_RpMsgCallbackList[actorID][chID];
		if (callback == NULL){
			return RPMSG_ERROR;
		}

		/* pMsgΪûص\u017d\u0160\u017d?*/
		(*callback)(buf, len);
		channel_send->RecvPos += size;
    }
	return RPMSG_SUCCESS;
}

/*******************************************************************************
* Function: zDrvIcp_interrupt
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/

static irqreturn_t icp_rpmsg_interrupt(int intline, void *p)
{
	unsigned int i;
	Icp_rpmsg_drv *Icp_rpmsg_driver= p;
	T_HalIcp_Dword chIDs;
	
	chIDs = Icp_rpmsg_driver->ops->Icp_GetInt(Icp_rpmsg_driver->actorID);

	for(i=0; i<CHANNEL_MAXID; i++)
    	{
      	 	 if((((i<32)&&((chIDs.low_word>>i) & 0x1))||((i>=32)&&((chIDs.high_word>>(i-32)) & 0x1)))&& ((Icp_rpmsg_drvs[Icp_rpmsg_driver->actorID]->ChInfo_Send_Base + i)->flag & CHANNEL_FLAG)){
			if(s_RpMsgCallbackList[Icp_rpmsg_driver->actorID][i] != NULL){
				rpmsg_struct[Icp_rpmsg_driver->actorID].event.actorID = Icp_rpmsg_driver->actorID;
				rpmsg_struct[Icp_rpmsg_driver->actorID].event.chID = i;
				queue_work(rpmsg_workqueue[Icp_rpmsg_driver->actorID], &(rpmsg_struct[Icp_rpmsg_driver->actorID].rpmsg_work));
			}
			else{
				//if (RpmsgChnStatus[rpmsg_drve->actorID][i])
					up(&RpmsgSema[Icp_rpmsg_driver->actorID][i]);
			}
			Icp_rpmsg_driver->ops->Icp_ClearInt(Icp_rpmsg_driver->actorID, i);
      	 	 }
   	 } 

#if defined(CONFIG_HAS_WAKELOCK)
	wake_lock_timeout(&icp_wake_lock, msecs_to_jiffies(5*1000)); 
#endif
	
	return IRQ_HANDLED;	
}
/*******************************************************************************
* Function: HalRpMsg_SenInt
* Description: This function is used for generating icp interrupt to inform remote cpu;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:None
*
*
* Others:
********************************************************************************/
int zDrvIcp_SetInt(T_ZDrvRpMsg_ActorID actorID, unsigned int chID)
{
	if(actorID >= ACTOR_MAXID ||chID >= CHANNEL_MAXID){
		return RPMSG_INVALID_PARAMETER;
	}
	Icp_rpmsg_drvs[actorID]->ops->Icp_SetInt(actorID, chID);
	
   	return 0;
}

EXPORT_SYMBOL(zDrvIcp_SetInt);
/*******************************************************************************
* Function: zDrvRpMsg_RegCallBack
* Description: This function is used for register callback fuction of icp interrupt;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:None
*
*
* Others:
********************************************************************************/
int zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback)
{
	if(actorID >= ACTOR_MAXID ||chID >= CHANNEL_MAXID)
		return RPMSG_INVALID_PARAMETER;

	s_RpMsgCallbackList[actorID][chID] = callback;
	if(callback!=NULL)
	{
		printk("rpmsg: actorID = %d chID = %d register callback success!\n", actorID, chID);
		rpmsg_struct[actorID].event.actorID = actorID;
		rpmsg_struct[actorID].event.chID = chID;
		queue_work(rpmsg_workqueue[actorID], &(rpmsg_struct[actorID].rpmsg_work));		
	}
	return 0;
}

EXPORT_SYMBOL(zDrvRpMsg_RegCallBack);

void zDrvRpMsg_ReadExit(T_ZDrvRpMsg_ActorID actor, T_ZDrvRpMsg_ChID chID)
{
	RpMsgRead_Exit[actor][chID] = 1;

	if(RpmsgSema[actor][chID].count)
	{
		up(&RpmsgSema[actor][chID]);
	}
}
EXPORT_SYMBOL(zDrvRpMsg_ReadExit);

/**********************************************************************************
*                           used by devices
**********************************************************************************/
int icp_rpmsg_register( Icp_rpmsg_drv *icp_rpmsg)
{
	int ret;
	char s[30];
	Icp_rpmsg_drvs[icp_rpmsg->actorID] = icp_rpmsg; 
		
	sprintf(s, "rpmsg_work%d", (unsigned int)(icp_rpmsg->actorID));
	rpmsg_workqueue[icp_rpmsg->actorID] = create_workqueue(s);
	INIT_WORK(&(rpmsg_struct[icp_rpmsg->actorID].rpmsg_work), (void *)RpMsg_Dispatch);/*process regcallback function*/
	mutex_init(&rpmsgch_mutex[icp_rpmsg->actorID]);

#if defined(CONFIG_HAS_WAKELOCK)
	if(icp_rpmsg->actorID == PS_ID)
	{
		wake_lock_init(&icp_wake_lock, WAKE_LOCK_SUSPEND, "icp_msg");
		printk("[zxp] icp_wake_lock inited! \n");		
	}
#endif	
  
	ret = request_irq(icp_rpmsg->intline, icp_rpmsg_interrupt, 0,
							icp_rpmsg->name, icp_rpmsg);
    
	if(icp_rpmsg->actorID == PS_ID){
		icp_rpmsg->dev.id = icp_rpmsg->actorID;
		ret = icp_rpmsg_device_register(icp_rpmsg);
		if(ret < 0)
			printk("rpmsg_zx29 register failed!");
	}
	
	return 0;
		
}

unsigned int icp_rpmsg_getchflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;
	
	return channel_send->flag;
}

int icp_rpmsg_setchIntflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag)
{
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;

	if(flag == 1)
		channel_send->flag |= CHANNEL_INT_FLAG;
	else if(flag == 0)
		channel_send->flag &= ~CHANNEL_INT_FLAG;
	else
		return RPMSG_ERROR;
	
	return RPMSG_SUCCESS;
}

int icp_rpmsg_setchpollflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag)
{
	T_HalRpMsg_ChInfo *channel_send = Icp_rpmsg_drvs[actorID]->ChInfo_Send_Base + chID;

	if(flag == 1)
		channel_send->flag |= CHANENL_POLL_FLAG;
	else if(flag == 0)
		channel_send->flag &= ~CHANENL_POLL_FLAG;
	else
		return RPMSG_ERROR;
	
	return RPMSG_SUCCESS;
}

int icp_rpmsg_unregister(Icp_rpmsg_drv *icp_rpmsg)
{
	return 0;
}

