/*
 * linux/arch/arm/mach-zx297510/mach/clock.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef CLOCK_H
#define CLOCK_H

#include <linux/clkdev.h>
#include <mach/iomap.h>
#include <linux/clk-private.h>

#define NAME_work_clk_104m  "work_clk_104m"
#define NAME_main_clk_26m   "main_clk_26m"
#define NAME_standby_clk_32k    "standby_clk_32k"
#define NAME_apb_clk    "apb_clk"

/*
 * flags used across common struct clk.  these flags should only affect the
 * top-level framework.  custom flags for dealing with hardware specifics
 * belong in struct clk_foo
 */
#define CLK_IGNORE_UNUSED	BIT(3) /* do not gate even if unused */
#define CLK_IS_ROOT		BIT(4) /* root clk, has no parent */
#define CLK_AUTO_ROUND_PARENT		BIT(5) /* auto round parent to select rate */


struct clk;

/**
 * struct clk_hw - handle for traversing from a struct clk to its corresponding
 * hardware-specific structure.  struct clk_hw should be declared within struct
 * clk_foo and then referenced by the struct clk instance that uses struct
 * clk_foo's clk_ops
 *
 * clk: pointer to the struct clk instance that points back to this struct
 * clk_hw instance
 */
struct clk_hw {
	struct clk *clk;
};

struct clk_ops {
	int		(*prepare)(struct clk_hw *hw);
	void		(*unprepare)(struct clk_hw *hw);
	int		(*enable)(struct clk_hw *hw);
	void		(*disable)(struct clk_hw *hw);
	int		(*is_enabled)(struct clk_hw *hw);
	unsigned long	(*recalc_rate)(struct clk_hw *hw,
					unsigned long parent_rate);
	long		(*round_rate)(struct clk_hw *hw, unsigned long,
					unsigned long *);
	int		(*set_parent)(struct clk_hw *hw, u8 index);
	u8		(*get_parent)(struct clk_hw *hw);
	int		(*set_rate)(struct clk_hw *hw, unsigned long);
	void		(*init)(struct clk_hw *hw);
	int    (*set_auto_gate)(struct clk_hw *hw, bool enable);
};

struct clk {
	const char		*name;
	const struct clk_ops	*ops;
	struct clk_hw		*hw;
	struct clk		*parent;
	char			**parent_names;
	struct clk		**parents;
	u8			num_parents;
	unsigned long		rate;
	unsigned long		new_rate;
	unsigned long		flags;
	unsigned int		enable_count;
	struct list_head list;
};

#define CLK_ZX29_CONFIG(dev, con, ck) 	\
	{				\
			.dev_id = dev,	\
			.con_id = con,	\
			.clk = ck,	\
	}



/**
 * clk_set_auto_gate - set the clock auto gate
 * @clk: clock source
 * @enable: enable auto gate true or false
 *
 * Returns success (0) or negative errno.
 */
int clk_set_auto_gate(struct clk *clk, bool enable);


void __init zx297510_clock_init(struct clk_lookup *clock_tbl, unsigned num_clocks);

extern struct clk_lookup periph_clocks_lookups[];
extern unsigned int periph_clocks_lookups_num;
#endif
