/*******************************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name: icp.h
* File Mark:
* Description:  
* Others:
* Version:       V0.1
* Author:        ShiDeYou
* Date:          2013-03-13
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
*******************************************************************************/

/*******************************************************************************
*                                  Include files                               *
*******************************************************************************/

/*******************************************************************************
*                                  Types                                       *
*******************************************************************************/
#ifndef ICP_H
#define ICP_H

#define RPMSG_WRITE_INT (0x1)
#define RPMSG_READ_POLL (0x1<<1)

/*channels or devices definition */
#define DRIVER              channel_0
#define PSM                   channel_1
#define USB_ADB           channel_2


#define WAN1                channel_3
#define WAN2                channel_4
#define WAN3                channel_5
#define WAN4                channel_6

#define DEV_BUFMALLOC     channel_7
#define DEV_BUFFREE         channel_8

#define AMT                   channel_9
#define RAMDUMP          channel_10

#define AT1                 channel_11
#define AT2                 channel_12
#define AT3                 channel_13
#define AT4                 channel_14
#define AT5                 channel_15

#define IPSEC1            channel_16
#define IPSEC2            channel_17
#define IPSEC3            channel_18
#define IPSEC4            channel_19
#define IPSEC5            channel_20
#define IPSEC6            channel_21
#define IPSEC7            channel_22
#define IPSEC8            channel_23
#define IPSEC9            channel_24
#define IPSEC10          channel_25
#define IPSEC11          channel_26
#define IPSEC12          channel_27
#define IPSEC13          channel_28
#define IPSEC14          channel_29
#define IPSEC15          channel_30
#define IPSEC16          channel_31
#define IPSEC17          channel_32
#define IPSEC18          channel_33
#define IPSEC19          channel_34
#define IPSEC20          channel_35

#define AT6              channel_36
#define AT7              channel_37
#define AT8              channel_38
#define AT9              channel_39

#define RESERVE          channel_40



typedef enum _T_ZDrvRpMsg_ChID
{
    CHANNEL_BASEID,

    channel_0 = CHANNEL_BASEID,    //driver     just for AP<->PS
    channel_1,             		   //PSM
    channel_2,					  //USB_DETCT
    channel_3,					  //USB_ADB
    channel_4,					 //WAN
    channel_5,					 //LAN1
    channel_6,					 //LAN2
    channel_7,					//DEV_BUFMALLOC
    channel_8,					//DEV_BUFFREE
    channel_9,					//AT
    channel_10,				    //AMT
    channel_11,				    //LOG
    channel_12,                           //FOTA

    channel_13,
    channel_14,
    channel_15,
    channel_16,


    channel_17,
    channel_18,
    channel_19,
    channel_20,

    channel_21,
    channel_22,
    channel_23,
    channel_24,

    channel_25,
    channel_26,
    channel_27,
    channel_28,

    channel_29,
    channel_30,
    channel_31,
    channel_32,

    channel_33,
    channel_34,
    channel_35,
    channel_36,

    channel_37,
    channel_38,
    channel_39,
    channel_40,

    CHANNEL_MAXID
}T_ZDrvRpMsg_ChID;


typedef enum _T_ZDrvRpMsg_ActorID
{
    ACTOR_BASEID,
    
    M0_ID = ACTOR_BASEID,
    PS_ID,
    
    ACTOR_MAXID
} T_ZDrvRpMsg_ActorID;

typedef struct _T_ZDrvRpMsg_Msg
{
    T_ZDrvRpMsg_ActorID actorID;
    T_ZDrvRpMsg_ChID     chID;
    unsigned int flag;
    void  *buf;
    unsigned int len;
} T_ZDrvRpMsg_Msg;

typedef enum _T_ZDrvRpMsg_ErrCode
{
    RPMSG_SUCCESS = 0,
    RPMSG_INT_NOCLEAR = 2,
    RPMSG_ERROR = -1,
    RPMSG_INVALID_PARAMETER = -101,
    RPMSG_SPACE_NOT_ENOUGH = -102,
    RPMSG_CHANNEL_ALREADY_EXIST = -103,
    RPMSG_CHANNEL_INEXISTANCE = -104,
    RPMSG_CHANNEL_MSG_ERR = -105,
    RPMSG_CHANNEL_ERROR = -107,
    RPMSG_NO_MSG = -108,
}T_ZDrvRpMsg_ErrCode;


typedef void (*T_ZDrvRpMsg_CallbackFunction)(void *buf, unsigned int len);


/*******************************************************************************
* Function: zDrvRpMsg_CreateChannel
* Description: This function is used for creating channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       size: size of channel
*   Output:None
*
* Returns:
*   RPMSG_SUCCESS: successfully.
*   RPMSG_INVALID_PARAMETER:parameter is invalid.
*   RPMSG_CHANNEL_ALREADY_EXIST: channel already exist.
*   RPMSG_SPACE_NOT_ENOUGH: space of iram is not enough.
*   RPMSG_ERROR:error
*
* Others:  
********************************************************************************/
extern int zDrvRpMsg_CreateChannel (T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size);

/*******************************************************************************
* Function: zDrvRpMsg_Write
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_SPACE_NOT_ENOUGH: There is no enough space
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_WriteLockIrq
* Description: This function is used for writing message and disable irq;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_SPACE_NOT_ENOUGH: There is no enough space
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_Read
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_NO_MSG: There is no message
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_Read(const T_ZDrvRpMsg_Msg *pMsg);
/*******************************************************************************
* Function: zDrvRpMsg_ReadLockIrq
* Description: This function is used for reading message and disable irq;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_NO_MSG: There is no message
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_RegCallBack
* Description: This function is used for register callback fuction of icp interrupt;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:
*      RPMSG_INVALID_PARAMETER:parameter is invalid
*	   RPMSG_SUCCESS:success
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback);

/*******************************************************************************
* Function: zDrvRpMsg_GetDataSize
* Description: This function is used to get datasize of channel ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*     RPMSG_INVALID_PARAMETER:parameter is invalid
*     RPMSG_ERROR:error
*     size: size of data
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_RecvCh_GetDataSize(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);

/*******************************************************************************
* Function: HalRpMsg_SenInt
* Description: This function is used for generating icp interrupt to inform remote cpu;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns: 
*      RPMSG_INVALID_PARAMETER:parameter is invalid
*	   RPMSG_SUCCESS:success
* Others:
********************************************************************************/
extern int zDrvIcp_SetInt(T_ZDrvRpMsg_ActorID actorID, unsigned int chID);

#endif
