
#ifndef RPMSG_H
#define RPMSG_H

#include <mach/iomap.h>
#include <mach/icp.h>
#include <linux/device.h>


#define TRUE 1
#define FALSE 0

#define CHANNEL_FLAG (0x1)
#define CHANNEL_INT_FLAG (0x1<<16)
#define CHANENL_POLL_FLAG (0x1<<17)

#define ZX297510_RPMSG_DDR_BASE 0x23B00000

#define ZX297510_ICP_A9M0_REG (ZX297510_ICP1_BASE + 0xf0)
#define ZX297510_ICP_A9M0_REG_SIZE SZ_1K
	
#define ZX297510_ICP_A9A0_REG (ZX297510_ICP1_BASE + 0x180)
#define ZX297510_ICP_A9A0_REG_SIZE SZ_1K

#define ICP_IRAM_BASE (ZX297510_SRAM02_BASE + 0x11800)
#define ICP_MSG_ARRAY_SIZE          		(0x400)      //just for ARM0 & ARM1 communication

#define SOFTLOCK_BASE (ICP_IRAM_BASE + 0x4400)  //for spin softlock

//ֱ־
#define CROSS_FLAG_ADDR  (ICP_IRAM_BASE + ICP_MSG_ARRAY_SIZE)
#define CROSS_FLAG_LEN 0x10

#define ICP_IRAM_M0A0_BASEADDR		(CROSS_FLAG_ADDR + CROSS_FLAG_LEN)
#define ICP_IRAM_M0A0_SIZE                      (0x90 + CHANNEL_MAXID *24)
#define ICP_IRAM_M0A1_BASEADDR 	    	(ICP_IRAM_M0A0_BASEADDR + ICP_IRAM_M0A0_SIZE)
#define ICP_IRAM_M0A1_SIZE                      (0x40 + CHANNEL_MAXID *24)
#define ICP_IRAM_M0A9_BASEADDR 		(ICP_IRAM_M0A1_BASEADDR + ICP_IRAM_M0A1_SIZE)
#define ICP_IRAM_M0A9_SIZE                      (0x40 + CHANNEL_MAXID *24)

#define ICP_IRAM_A1M0_BASEADDR 		(ICP_IRAM_M0A9_BASEADDR + ICP_IRAM_M0A9_SIZE)
#define ICP_IRAM_A1M0_SIZE                      (0x40 + CHANNEL_MAXID *24)

#define ICP_IRAM_A0M0_BASEADDR            (ICP_IRAM_A1M0_BASEADDR + ICP_IRAM_A1M0_SIZE)
#define ICP_IRAM_A0M0_SIZE                      (0x70 + CHANNEL_MAXID *24)
#define ICP_IRAM_A0A9_BASEADDR             (ICP_IRAM_A0M0_BASEADDR + ICP_IRAM_A0M0_SIZE)
#define ICP_IRAM_A0A9_SIZE                       (0x100 + CHANNEL_MAXID *24)

#define ICP_IRAM_A9M0_BASEADDR            (ICP_IRAM_A0A9_BASEADDR + ICP_IRAM_A0A9_SIZE)
#define ICP_IRAM_A9M0_SIZE                      (0x40 + CHANNEL_MAXID *24)
#define ICP_IRAM_A9A0_BASEADDR            (ICP_IRAM_A9M0_BASEADDR + ICP_IRAM_A9M0_SIZE)
#define ICP_IRAM_A9A0_SIZE                       (0x100 + CHANNEL_MAXID *24)
	
#define ZX297510_ICP_A9M0_SEND_IRAM ICP_IRAM_A9M0_BASEADDR
#define ZX297510_ICP_A9M0_SEND_IRAM_SIZE ICP_IRAM_A9M0_SIZE
	
#define ZX297510_ICP_A9M0_RECV_IRAM ICP_IRAM_M0A9_BASEADDR
#define ZX297510_ICP_A9M0_RECV_IRAM_SIZE ICP_IRAM_M0A9_SIZE

#define ZX297510_ICP_A9M0_SEND_DDR (ZX297510_RPMSG_DDR_BASE)
#define ZX297510_ICP_A9M0_SEND_DDR_SIZE 0
	
#define ZX297510_ICP_A9M0_RECV_DDR (ZX297510_RPMSG_DDR_BASE)
#define ZX297510_ICP_A9M0_RECV_DDR_SIZE 0
	
#define ZX297510_ICP_A9A0_SEND_IRAM ICP_IRAM_A9A0_BASEADDR
#define ZX297510_ICP_A9A0_SEND_IRAM_SIZE ICP_IRAM_A9A0_SIZE
	
#define ZX297510_ICP_A9A0_RECV_IRAM ICP_IRAM_A0A9_BASEADDR
#define ZX297510_ICP_A9A0_RECV_IRAM_SIZE ICP_IRAM_A0A9_SIZE

#define ZX297510_ICP_A9A0_SEND_DDR (ZX297510_RPMSG_DDR_BASE)
#define ZX297510_ICP_A9A0_SEND_DDR_SIZE 0x80000

#define ZX297510_ICP_A9A0_RECV_DDR (ZX297510_ICP_A9A0_SEND_DDR + ZX297510_ICP_A9A0_SEND_DDR_SIZE)
#define ZX297510_ICP_A9A0_RECV_DDR_SIZE 0x80000

typedef struct _T_HalIcp_Dword{
    unsigned int low_word;
    unsigned int high_word;
}T_HalIcp_Dword;

typedef struct _T_HalIcp_Reg{
	T_HalIcp_Dword control;
	T_HalIcp_Dword state;
	T_HalIcp_Dword clear;
	T_HalIcp_Dword mask;
	T_HalIcp_Dword sfn;
	T_HalIcp_Dword in_state;
}T_HalIcp_Reg;

typedef struct _T_HalRpMsg_MsgHeader
{
    unsigned short flag;
    unsigned short len;
}T_HalRpMsg_MsgHeader;

typedef struct _T_HalRpMsg_RpMsg
{
    T_HalRpMsg_MsgHeader MsgHeader;
    void *data;
} T_HalRpMsg_RpMsg;

typedef struct _T_HalRpMsg_ChInfo
{
    unsigned int Base_Addr;
    unsigned int SendPos;
    unsigned int RecvPos;
    unsigned int size;
    unsigned int flag;
    unsigned int EndAddr;
}T_HalRpMsg_ChInfo;

typedef enum _T_HalRpMsg_ChRam
{
	CH_IRAM,
	CH_DDR
}T_HalRpMsg_ChRam;

typedef struct _T_HalRpMsg_ChConfig
{
	unsigned int CurIramAddr;
	unsigned int CurIramSpace_Size;
	unsigned int CurDdrAddr;
	unsigned int CurDdrSpace_Size;
	T_HalRpMsg_ChRam ChConfig[CHANNEL_MAXID];
}T_HalRpMsg_ChConfig;


typedef struct _T_HalRpMsg_RWP
{
	unsigned int *writep;
	unsigned int *readp;
	unsigned int *endp;
}T_HalRpMsg_RWP;

typedef struct _T_HalRpMsg_Addr
{
	unsigned int ChAddr;
	unsigned int ChAddr_map;

}T_HalRpMsg_Addr;

typedef struct _T_HalCh_Addr
{
	unsigned int ChAddr_Start;
	unsigned int ChAddr_End;

}T_HalCh_Addr;

typedef struct _icp_operations{
	int (*Icp_SetInt)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_ClearInt)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	T_HalIcp_Dword (*Icp_GetInt)(T_ZDrvRpMsg_ActorID actorID);
	int (*Icp_GetIntState)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_Mask)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_UnMask)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
}icp_operations;

typedef struct _Icp_rpmsg_drv {
	char			*name;
	unsigned int		intline;
	struct device	dev;
	void			*priv;
	int			use_count;
	T_HalIcp_Reg *IcpReg;
    	T_ZDrvRpMsg_ActorID actorID;
  	T_HalRpMsg_ChInfo *ChInfo_Send_Base;
  	T_HalRpMsg_ChInfo *ChInfo_Recv_Base;
	unsigned int ChInfo_SendBase_offset;      //IRAM  send_baseaddr remap
	unsigned int ChInfo_RecvBase_offset;     //IRAM  recv baseaddr remap
  	unsigned int Ddr_SendBase;
  	unsigned int Ddr_RecvBase;
  	unsigned int Ddr_SendBase_offset;
  	unsigned int Ddr_RecvBase_offset;
  	T_HalRpMsg_ChConfig Channel_config;
	unsigned int ChStartAddr_map[CHANNEL_MAXID];
	icp_operations *ops;
}Icp_rpmsg_drv;

int icp_rpmsg_register(Icp_rpmsg_drv *icp_rpmsg);
int icp_rpmsg_unregister(Icp_rpmsg_drv *icp_rpmsg);
int icp_rpmsg_device_register(Icp_rpmsg_drv *icp_rpmsg);

int icp_rpmsg_setchIntflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag);
int icp_rpmsg_setchpollflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag);
unsigned int icp_rpmsg_getchflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);

#endif


