/*
 * arch/arm/mach-zx297510/include/mach/uncompress.h
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ASM_ARCH_UNCOMPRESS_H
#define __ASM_ARCH_UNCOMPRESS_H

#include <linux/io.h>
#include <mach/iomap.h>


#define UART_FR 0x14
#define UART_DR 0x04


/*
 * The following code assumes the serial port has already been
 * initialized by the bootloader.  If you didn't setup a port in
 * your bootloader then nothing will appear (which might be desired).
 *
 * This does not append a newline
 */
static void putc(int c)
{
	void __iomem *p = (void __iomem *) ZX297510_UART0_BASE;	/* physical address */

	while ( __raw_readb(p+UART_FR) & 0x20 )   /*check transmit FIFO full or not*/
		barrier();
	__raw_writeb((char)c, p+UART_DR);
}

static inline void flush(void)
{
	void __iomem *p = (void __iomem *) ZX297510_UART0_BASE;	/* physical address */

	/* wait for transmission to complete */
	while (__raw_readb(p + UART_FR) & 0x80)
		barrier();
}

#define arch_decomp_setup()

#define arch_decomp_wdog()

#endif
