

#include <linux/sched.h>

#define USB_DEBUG_EN 1

void usb_dbg_showLog(void);
void usb_dbg_printf(const char *fmt,...);

//#define USB_CHG_DEV


#if USB_DEBUG_EN

#define HAL_DBG_EN		0
#define STACK_DBG_EN	1


#define USBHAL_DBG(_format, _args...)		do{if(HAL_DBG_EN)usb_dbg_printf("(%u)hal," _format "\n", \
												jiffies, ## _args);}while(0)
				
#define USBSTACK_DBG(_format, _args...)	do{if(STACK_DBG_EN)usb_dbg_printf("(%u)stack," _format "\n", \
												jiffies, ## _args);}while(0)

#define USB_ASSERT(_expr, _format, _args...)	do{if(!(_expr)) {usb_dbg_printf("(%u)ERROR(%s, %d): " _format "\n", \	
												jiffies,  __func__, __LINE__, ## _args);BUG_ON(1);}}while(0)

#else

#define USB_HALDBG(_format, _args...)			do{}while(0)
#define USB_STACKDBG(_format, _args...)		do{}while(0)
#define USB_ASSERT(_expr, _format, _args...)	do{}while(0)

#endif

