/*
 * arch/arm/mach-zx297510/zx-cpufreq.h
 *
 * Copyright (c) 2013, ZTE Corporation.
 * write by zxp
 *
 */

#ifndef __MACH_ZX_CPU_FREQ_H
#define __MACH_ZX_CPU_FREQ_H

enum cpufreq_level_index {
	L0, L1, L2, L3, L4,
	L5, L6, L7, L8, L9,
	L10, L11, L12, L13, L14,
	L15, L16, L17, L18, L19,
	L20,
};

struct zx_dvfs_info {
	unsigned int	freq_cur_idx;
	unsigned int	pll_safe_idx;
	unsigned int	max_support_idx;
	unsigned int	min_support_idx;
	struct clk	*cpu_clk;
	unsigned int	*volt_table;
	struct cpufreq_frequency_table	*freq_table;
	int (*set_freq)(unsigned int, unsigned int);
};

#ifdef CONFIG_AXI_FREQ
typedef enum
{
    AXI_FREQ_26M 		= 0,
    AXI_FREQ_39M 		= 1,
    AXI_FREQ_52M 		= 2,
    AXI_FREQ_61_44M 	= 3,
    AXI_FREQ_78M 		= 4,
    AXI_FREQ_104M 		= 5,
    AXI_FREQ_122_88M 	= 6,
    AXI_FREQ_156M 		= 7,
    AXI_FREQ_NULL,
    MAX_AXI_FREQ
}zx297510_axi_freq;
#endif

extern unsigned int zx_getspeed(unsigned int cpu);
extern int zx_update_cpu_speed(unsigned long rate);
extern int zx_cpu_set_speed_cap(unsigned int *speed_cap);
extern unsigned int zx_count_slow_cpus(unsigned long speed_limit);
extern unsigned int zx_get_slowest_cpu_n(void);
extern unsigned long zx_cpu_lowest_speed(void);
extern unsigned long zx_cpu_highest_speed(void);


extern int zx297510_cpufreq_init(struct zx_dvfs_info *info);
#ifdef CONFIG_ZX_PM_DEBUG
extern void cpufreq_test(unsigned int old_index, unsigned int new_index);
#endif

#ifdef CONFIG_AXI_FREQ
extern int request_axi_freq(zx297510_axi_freq axi_freq);
#endif

#endif /* __MACH_ZX_CPU_FREQ_H */
